/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, Supplier<DynamicConverter>> CONVERTER_MAP = new HashMap<String, Supplier<DynamicConverter>>();
    String pattern;
    Converter<Object> headTokenConverter;

    public FileNamePattern(String string, Context context) {
        this.setPattern(FileFilterUtil.slashify(string));
        this.setContext(context);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            FileNamePattern fileNamePattern = this;
            Object object = fileNamePattern.escapeRightParantesis(fileNamePattern.pattern);
            object = new Parser((String)object, new AlmostAsIsEscapeUtil());
            ((ContextAwareBase)object).setContext(this.context);
            Node node = ((Parser)object).parse();
            this.headTokenConverter = ((Parser)object).compile(node, CONVERTER_MAP);
            return;
        }
        catch (ScanException scanException) {
            FileNamePattern fileNamePattern = this;
            fileNamePattern.addError("Failed to parse pattern \"" + fileNamePattern.pattern + "\".", scanException);
            return;
        }
    }

    String escapeRightParantesis(String string) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        int n2 = 31 + (this.pattern == null ? 0 : this.pattern.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FileNamePattern)object;
        return !(this.pattern == null ? ((FileNamePattern)object).pattern != null : !this.pattern.equals(((FileNamePattern)object).pattern));
    }

    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            DateTokenConverter dateTokenConverter;
            if (!(converter instanceof DateTokenConverter) || !(dateTokenConverter = (DateTokenConverter)converter).isPrimary()) continue;
            return dateTokenConverter;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (!(converter instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)converter;
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter integerTokenConverter = this.getIntegerTokenConverter();
        return integerTokenConverter != null;
    }

    public String convertMultipleArguments(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof MonoTypedConverter) {
                MonoTypedConverter monoTypedConverter = (MonoTypedConverter)((Object)converter);
                Object[] objectArray2 = objectArray;
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = objectArray2[i2];
                    if (!monoTypedConverter.isApplicable(object)) continue;
                    stringBuilder.append(converter.convert(object));
                }
                continue;
            }
            stringBuilder.append(converter.convert(objectArray));
        }
        return stringBuilder.toString();
    }

    public String convert(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            stringBuilder.append(converter.convert(object));
        }
        return stringBuilder.toString();
    }

    public String convertInt(int n2) {
        return this.convert(n2);
    }

    public void setPattern(String string) {
        if (string != null) {
            this.pattern = string.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegexForFixedDate(Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("(\\d+)");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            stringBuilder.append(converter.convert(date));
        }
        return stringBuilder.toString();
    }

    public String toRegexForFixedDate(Instant instant) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("(\\d+)");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            stringBuilder.append(converter.convert(instant));
        }
        return stringBuilder.toString();
    }

    public String toRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("\\d+");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            DateTokenConverter dateTokenConverter = (DateTokenConverter)converter;
            stringBuilder.append(dateTokenConverter.toRegex());
        }
        return stringBuilder.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter::new);
        CONVERTER_MAP.put("d", DateTokenConverter::new);
    }
}

