/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover$ArchiveRemoverRunnable;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    @Override
    public Future<?> cleanAsynchronously(Instant future) {
        future = new TimeBasedArchiveRemover$ArchiveRemoverRunnable(this, (Instant)((Object)future));
        ExecutorService executorService = this.context.getAlternateExecutorService();
        future = executorService.submit((Runnable)((Object)future));
        return future;
    }

    @Override
    public void clean(Instant instant) {
        long l2 = instant.toEpochMilli();
        int n2 = this.computeElapsedPeriodsSinceLastClean(l2);
        this.lastHeartBeat = l2;
        if (n2 > 1) {
            this.addInfo("Multiple periods, i.e. " + n2 + " periods, seem to have elapsed. This can happen at application start.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getPeriodOffsetForDeletionTarget() - i2;
            Instant instant2 = this.rc.getEndOfNextNthPeriod(instant, n3);
            this.cleanPeriod(instant2);
        }
    }

    protected File[] getFilesInPeriod(Instant object) {
        object = this.fileNamePattern.convert(object);
        if (this.fileExistsAndIsFile((File)(object = new File((String)object)))) {
            return new File[]{object};
        }
        return new File[0];
    }

    private boolean fileExistsAndIsFile(File file) {
        return file.exists() && file.isFile();
    }

    public void cleanPeriod(Instant fileArray) {
        Object object = fileArray = this.getFilesInPeriod((Instant)fileArray);
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = object[i2];
            this.checkAndDeleteFile(file);
        }
        if (this.parentClean && fileArray.length > 0) {
            object = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty((File)object);
        }
    }

    private boolean checkAndDeleteFile(File file) {
        this.addInfo("deleting historically stale " + String.valueOf(file));
        if (file == null) {
            this.addWarn("Cannot delete empty file");
            return false;
        }
        if (!file.exists()) {
            this.addWarn("Cannot delete non existent file");
            return false;
        }
        boolean bl2 = file.delete();
        if (!bl2) {
            this.addWarn("Failed to delete file " + file.toString());
        }
        return bl2;
    }

    void capTotalSize(Instant instant) {
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.maxHistory; ++i2) {
            File[] fileArray = this.rc.getEndOfNextNthPeriod(instant, -i2);
            File[] fileArray2 = this.getFilesInPeriod((Instant)fileArray);
            this.descendingSort(fileArray2, (Instant)fileArray);
            fileArray = fileArray2;
            int n4 = fileArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                File file = fileArray[i3];
                long l4 = file.length();
                if ((l2 += l4) <= this.totalSizeCap) continue;
                this.addInfo("Deleting [" + String.valueOf(file) + "] of size " + String.valueOf(new FileSize(l4)) + " on account of totalSizeCap " + this.totalSizeCap);
                boolean bl2 = this.checkAndDeleteFile(file);
                if (bl2) {
                    ++n2;
                    l3 += l4;
                    continue;
                }
                ++n3;
            }
        }
        if (n2 + n3 == 0) {
            TimeBasedArchiveRemover timeBasedArchiveRemover = this;
            timeBasedArchiveRemover.addInfo("No removal attempts were made on account of totalSizeCap=" + timeBasedArchiveRemover.totalSizeCap);
            return;
        }
        this.addInfo("Removed  " + String.valueOf(new FileSize(l3)) + " of files in " + n2 + " files on account of totalSizeCap=" + this.totalSizeCap);
        if (n3 != 0) {
            this.addInfo("There were " + n3 + " failed deletion attempts.");
        }
    }

    protected void descendingSort(File[] fileArray, Instant instant) {
    }

    File getParentDir(File file) {
        file = file.getAbsoluteFile();
        file = file.getParentFile();
        return file;
    }

    int computeElapsedPeriodsSinceLastClean(long l2) {
        long l3;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            long l4 = l2;
            l3 = this.rc.periodBarriersCrossed(l4, l4 + 2764800000L);
            l3 = Math.min(l3, 336L);
        } else {
            l3 = this.rc.periodBarriersCrossed(this.lastHeartBeat, l2);
        }
        return (int)l3;
    }

    boolean computeParentCleaningFlag(FileNamePattern converter) {
        DateTokenConverter<Object> dateTokenConverter = ((FileNamePattern)((Object)converter)).getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = ((FileNamePattern)((Object)converter)).headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            if (converter instanceof LiteralConverter && ((String)((Object)(dateTokenConverter = converter.convert(null)))).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n2) {
        while (true) {
            if (n2 >= 3) {
                return;
            }
            if (!file.isDirectory() || !FileFilterUtil.isEmptyDirectory(file)) break;
            this.addInfo("deleting folder [" + String.valueOf(file) + "]");
            this.checkAndDeleteFile(file);
            ++n2;
            file = file.getParentFile();
        }
    }

    @Override
    public void setMaxHistory(int n2) {
        this.maxHistory = n2;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    @Override
    public void setTotalSizeCap(long l2) {
        this.totalSizeCap = l2;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }
}

