/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.PrintStream;
import java.util.Iterator;

public abstract class OnPrintStreamStatusListenerBase
extends ContextAwareBase
implements LifeCycle,
StatusListener {
    boolean isStarted = false;
    static final long DEFAULT_RETROSPECTIVE = 300L;
    long retrospectiveThresold = 300L;
    boolean resetResistant = false;
    String prefix;

    protected abstract PrintStream getPrintStream();

    private void print(Status status) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix != null) {
            stringBuilder.append(this.prefix);
        }
        StatusPrinter.buildStr(stringBuilder, "", status);
        this.getPrintStream().print(stringBuilder);
    }

    @Override
    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        if (this.context == null) {
            return;
        }
        long l2 = System.currentTimeMillis();
        Iterator<Status> iterator = this.context.getStatusManager();
        iterator = iterator.getCopyOfStatusList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status status = iterator.next();
            long l3 = status.getTimestamp();
            if (!this.isElapsedTimeLongerThanThreshold(l2, l3)) continue;
            this.print(status);
        }
    }

    private boolean isElapsedTimeLongerThanThreshold(long l2, long l3) {
        long l4 = l2 - l3;
        return l4 < this.retrospectiveThresold;
    }

    @Override
    public void start() {
        this.isStarted = true;
        if (this.retrospectiveThresold > 0L) {
            this.retrospectivePrint();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setRetrospective(long l2) {
        this.retrospectiveThresold = l2;
    }

    public long getRetrospective() {
        return this.retrospectiveThresold;
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isResetResistant() {
        return this.resetResistant;
    }

    public void setResetResistant(boolean bl2) {
        this.resetResistant = bl2;
    }
}

