/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusUtil {
    StatusManager sm;

    public StatusUtil(StatusManager statusManager) {
        this.sm = statusManager;
    }

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context list) {
        if ((list = list.getStatusManager()) == null) {
            return false;
        }
        return (list = list.getCopyOfStatusListenerList()) != null && list.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> object, long l2) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            if (status.getTimestamp() < l2) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public void addStatus(Status status) {
        if (this.sm != null) {
            this.sm.add(status);
        }
    }

    public void addInfo(Object object, String string) {
        this.addStatus(new InfoStatus(string, object));
    }

    public void addWarn(Object object, String string) {
        this.addStatus(new WarnStatus(string, object));
    }

    public void addError(Object object, String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, object, throwable));
    }

    public boolean hasXMLParsingErrors(long l2) {
        return this.containsMatch(l2, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long l2) {
        return !this.hasXMLParsingErrors(l2);
    }

    public int getHighestLevel(long l2) {
        Object object = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            if (status.getLevel() <= n2) continue;
            n2 = status.getLevel();
        }
        return n2;
    }

    public boolean isErrorFree(long l2) {
        return this.getHighestLevel(l2) < 2;
    }

    public boolean isWarningOrErrorFree(long l2) {
        return 1 > this.getHighestLevel(l2);
    }

    public boolean containsMatch(long l2, int n2, String object) {
        Object object2 = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        Pattern pattern = Pattern.compile((String)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (Status)object2.next();
            if (n2 != object.getLevel()) continue;
            object = object.getMessage();
            if (!((Matcher)(object = pattern.matcher((CharSequence)object))).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int n2, String string) {
        return this.containsMatch(0L, n2, string);
    }

    public boolean containsMatch(String object) {
        object = Pattern.compile((String)object);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string = status.getMessage();
            Matcher object2 = ((Pattern)object).matcher(string);
            if (!object2.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int levelCount(int n2, long l2) {
        Object object = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        int n3 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            if (status.getLevel() != n2) continue;
            ++n3;
        }
        return n3;
    }

    public int matchCount(String object) {
        int n2 = 0;
        object = Pattern.compile((String)object);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string = status.getMessage();
            Matcher object2 = ((Pattern)object).matcher(string);
            if (!object2.lookingAt()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean containsException(Class<?> clazz) {
        return this.containsException(clazz, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsException(Class<?> clazz, String string) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            void object;
            Throwable throwable = status.getThrowable();
            while (object != null) {
                if (object.getClass().getName().equals(clazz.getName())) {
                    if (string == null) {
                        return true;
                    }
                    if (this.checkRegexMatch(object.getMessage(), string)) {
                        return true;
                    }
                }
                Throwable throwable2 = object.getCause();
            }
        }
        return false;
    }

    private boolean checkRegexMatch(String object, String object2) {
        object2 = Pattern.compile((String)object2);
        object = ((Pattern)object2).matcher((CharSequence)object);
        return ((Matcher)object).lookingAt();
    }

    public long timeOfLastReset() {
        List<Status> list = this.sm.getCopyOfStatusList();
        if (list == null) {
            return -1L;
        }
        int n2 = list.size();
        --n2;
        while (n2 >= 0) {
            Status status = list.get(n2);
            if ("Will reset and reconfigure context ".equals(status.getMessage())) {
                return status.getTimestamp();
            }
            --n2;
        }
        return -1L;
    }

    public static String diff(Status status, Status status2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (status.getLevel() != status2.getLevel()) {
            stringBuilder.append(" left.level ").append(status.getLevel()).append(" != right.level ").append(status2.getLevel());
        }
        if (status.getTimestamp() != status2.getTimestamp()) {
            stringBuilder.append(" left.timestamp ").append(status.getTimestamp()).append(" != right.timestamp ").append(status2.getTimestamp());
        }
        if (!Objects.equals(status.getMessage(), status2.getMessage())) {
            stringBuilder.append(" left.message ").append(status.getMessage()).append(" != right.message ").append(status2.getMessage());
        }
        return stringBuilder.toString();
    }
}

