/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.ShutdownHook;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ContextUtil
extends ContextAwareBase {
    static final String GROOVY_RUNTIME_PACKAGE = "org.codehaus.groovy.runtime";

    public ContextUtil(Context context) {
        this.setContext(context);
    }

    public void addProperties(Properties object) {
        if (object == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : ((Properties)((Object)object)).entrySet()) {
            String string = (String)entry.getKey();
            this.context.putProperty(string, (String)entry.getValue());
        }
    }

    public static Map<String, String> getFilenameCollisionMap(Context object) {
        if (object == null) {
            return null;
        }
        object = (Map)object.getObject("FA_FILENAMES_MAP");
        return object;
    }

    public static Map<String, FileNamePattern> getFilenamePatternCollisionMap(Context object) {
        if (object == null) {
            return null;
        }
        object = (Map)object.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
        return object;
    }

    public void addGroovyPackages(List<String> list) {
        this.addFrameworkPackage(list, GROOVY_RUNTIME_PACKAGE);
    }

    public void addFrameworkPackage(List<String> list, String string) {
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    public void addOrReplaceShutdownHook(ShutdownHook runnable) {
        Runtime runtime = Runtime.getRuntime();
        Thread thread = (Thread)this.context.getObject("SHUTDOWN_HOOK");
        if (thread != null) {
            this.addInfo("Removing old shutdown hook from JVM runtime");
            runtime.removeShutdownHook(thread);
        }
        runnable = new Thread(runnable, "Logback shutdown hook [" + this.context.getName() + "]");
        this.addInfo("Registering shutdown hook with JVM runtime.");
        this.context.putObject("SHUTDOWN_HOOK", runnable);
        runtime.addShutdownHook((Thread)runnable);
    }
}

