/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.InvocationGate;

public class DefaultInvocationGate
implements InvocationGate {
    static final int MASK_DECREASE_RIGHT_SHIFT_COUNT = 2;
    private static final int MAX_MASK = 65535;
    static final int DEFAULT_MASK = 15;
    private volatile long mask = 15L;
    private long invocationCounter = 0L;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;
    private long minDelayThreshold;
    private long maxDelayThreshold;
    long lowerLimitForMaskMatch;
    long upperLimitForNoMaskMatch;

    public DefaultInvocationGate() {
        this(100L, 800L, System.currentTimeMillis());
    }

    public DefaultInvocationGate(long l2, long l3, long l4) {
        this.minDelayThreshold = l2;
        this.maxDelayThreshold = l3;
        this.lowerLimitForMaskMatch = l4 + l2;
        this.upperLimitForNoMaskMatch = l4 + l3;
    }

    @Override
    public final boolean isTooSoon(long l2) {
        boolean bl2;
        if (bl2 = (this.invocationCounter++ & this.mask) == this.mask) {
            if (l2 < this.lowerLimitForMaskMatch) {
                this.increaseMask();
            }
            this.updateLimits(l2);
        } else if (l2 > this.upperLimitForNoMaskMatch) {
            this.decreaseMask();
            this.updateLimits(l2);
            return false;
        }
        return !bl2;
    }

    private void updateLimits(long l2) {
        this.lowerLimitForMaskMatch = l2 + this.minDelayThreshold;
        this.upperLimitForNoMaskMatch = l2 + this.maxDelayThreshold;
    }

    long getMask() {
        return this.mask;
    }

    private void increaseMask() {
        if (this.mask >= 65535L) {
            return;
        }
        this.mask = this.mask << 1 | 1L;
    }

    private void decreaseMask() {
        this.mask >>>= 2;
    }

    public long getInvocationCounter() {
        return this.invocationCounter;
    }
}

