/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final String DOUBLE_PART = "([0-9]*(.[0-9]+)?)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|milli(second)?|second(e)?|minute|hour|day)s?";
    private static final int UNIT_GROUP = 3;
    private static final Pattern DURATION_PATTERN = Pattern.compile("([0-9]*(.[0-9]+)?)\\s*(|milli(second)?|second(e)?|minute|hour|day)s?", 2);
    static final long SECONDS_COEFFICIENT = 1000L;
    static final long MINUTES_COEFFICIENT = 60000L;
    static final long HOURS_COEFFICIENT = 3600000L;
    static final long DAYS_COEFFICIENT = 86400000L;
    final long millis;

    public Duration(long l2) {
        this.millis = l2;
    }

    public static Duration buildByMilliseconds(double d2) {
        return new Duration((long)d2);
    }

    public static Duration buildBySeconds(double d2) {
        return new Duration((long)(d2 * 1000.0));
    }

    public static Duration buildByMinutes(double d2) {
        return new Duration((long)(d2 * 60000.0));
    }

    public static Duration buildByHours(double d2) {
        return new Duration((long)(d2 * 3600000.0));
    }

    public static Duration buildByDays(double d2) {
        return new Duration((long)(d2 * 8.64E7));
    }

    public static Duration buildUnbounded() {
        return new Duration(Long.MAX_VALUE);
    }

    public long getMilliseconds() {
        return this.millis;
    }

    public static Duration valueOf(String string) {
        Object object = DURATION_PATTERN.matcher(string);
        if (((Matcher)object).matches()) {
            string = ((Matcher)object).group(1);
            object = ((Matcher)object).group(3);
            double d2 = Double.valueOf(string);
            if (((String)object).equalsIgnoreCase("milli") || ((String)object).equalsIgnoreCase("millisecond") || ((String)object).length() == 0) {
                return Duration.buildByMilliseconds(d2);
            }
            if (((String)object).equalsIgnoreCase("second") || ((String)object).equalsIgnoreCase("seconde")) {
                return Duration.buildBySeconds(d2);
            }
            if (((String)object).equalsIgnoreCase("minute")) {
                return Duration.buildByMinutes(d2);
            }
            if (((String)object).equalsIgnoreCase("hour")) {
                return Duration.buildByHours(d2);
            }
            if (((String)object).equalsIgnoreCase("day")) {
                return Duration.buildByDays(d2);
            }
            throw new IllegalStateException("Unexpected " + (String)object);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }

    public String toString() {
        if (this.millis < 1000L) {
            return this.millis + " milliseconds";
        }
        if (this.millis < 60000L) {
            return this.millis / 1000L + " seconds";
        }
        if (this.millis < 3600000L) {
            return this.millis / 60000L + " minutes";
        }
        return this.millis / 3600000L + " hours";
    }
}

