/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.ErrorReportConfiguration$Builder;
import java.io.Serializable;

public class ErrorReportConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_ERROR_TOKEN_LENGTH = 256;
    public static final int DEFAULT_MAX_RAW_CONTENT_LENGTH = 500;
    protected final int _maxErrorTokenLength;
    protected final int _maxRawContentLength;
    private static ErrorReportConfiguration DEFAULT = new ErrorReportConfiguration(256, 500);

    public static void overrideDefaultErrorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        if (errorReportConfiguration == null) {
            DEFAULT = new ErrorReportConfiguration(256, 500);
            return;
        }
        DEFAULT = errorReportConfiguration;
    }

    protected ErrorReportConfiguration(int n2, int n3) {
        this._maxErrorTokenLength = n2;
        this._maxRawContentLength = n3;
    }

    public static ErrorReportConfiguration$Builder builder() {
        return new ErrorReportConfiguration$Builder();
    }

    public static ErrorReportConfiguration defaults() {
        return DEFAULT;
    }

    public ErrorReportConfiguration$Builder rebuild() {
        return new ErrorReportConfiguration$Builder(this);
    }

    public int getMaxErrorTokenLength() {
        return this._maxErrorTokenLength;
    }

    public int getMaxRawContentLength() {
        return this._maxRawContentLength;
    }

    static void validateMaxErrorTokenLength(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("Value of maxErrorTokenLength (%d) cannot be negative", n2));
        }
    }

    static void validateMaxRawContentLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("Value of maxRawContentLength (%d) cannot be negative", n2));
        }
    }
}

