/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier$MutableComplex;

final class FftMultiplier$ComplexVector {
    private static final int COMPLEX_SIZE_SHIFT = 1;
    static final int IMAG = 1;
    static final int REAL = 0;
    private final double[] a;
    private final int length;
    private final int offset;

    FftMultiplier$ComplexVector(int n2) {
        this.a = new double[n2 << 1];
        this.length = n2;
        this.offset = 0;
    }

    FftMultiplier$ComplexVector(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n2, int n3) {
        this.length = n3 - n2;
        this.a = fftMultiplier$ComplexVector.a;
        this.offset = n2 << 1;
    }

    final void add(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        int n3 = this.realIdx(n2);
        this.a[n3] = this.a[n3] + fftMultiplier$MutableComplex.real;
        int n4 = this.imagIdx(n2);
        this.a[n4] = this.a[n4] + fftMultiplier$MutableComplex.imag;
    }

    final void addInto(int n2, FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n3, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        fftMultiplier$MutableComplex.real = this.a[this.realIdx(n2)] + fftMultiplier$ComplexVector.real(n3);
        fftMultiplier$MutableComplex.imag = this.a[this.imagIdx(n2)] + fftMultiplier$ComplexVector.imag(n3);
    }

    final void addTimesIInto(int n2, FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n3, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        fftMultiplier$MutableComplex.real = this.a[this.realIdx(n2)] - fftMultiplier$ComplexVector.imag(n3);
        fftMultiplier$MutableComplex.imag = this.a[this.imagIdx(n2)] + fftMultiplier$ComplexVector.real(n3);
    }

    final void applyInverseWeights(FftMultiplier$ComplexVector object) {
        int n2 = ((FftMultiplier$ComplexVector)object).offset;
        object = ((FftMultiplier$ComplexVector)object).a;
        int n3 = this.offset + this.length << 1;
        for (int i2 = this.offset; i2 < n3; i2 += 2) {
            double d2 = this.a[i2];
            double d3 = this.a[i2 + 1];
            this.a[i2] = FastDoubleSwar.fma(d2, (double)object[n2], d3 * object[n2 + 1]);
            this.a[i2 + 1] = FastDoubleSwar.fma(-d2, (double)object[n2 + 1], d3 * object[n2]);
            n2 += 2;
        }
    }

    final void applyWeights(FftMultiplier$ComplexVector object) {
        int n2 = ((FftMultiplier$ComplexVector)object).offset;
        object = ((FftMultiplier$ComplexVector)object).a;
        int n3 = this.offset + this.length << 1;
        for (int i2 = this.offset; i2 < n3; i2 += 2) {
            double d2 = this.a[i2];
            this.a[i2] = d2 * object[n2];
            this.a[i2 + 1] = d2 * object[n2 + 1];
            n2 += 2;
        }
    }

    final void copyInto(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        fftMultiplier$MutableComplex.real = this.a[this.realIdx(n2)];
        fftMultiplier$MutableComplex.imag = this.a[this.imagIdx(n2)];
    }

    final double imag(int n2) {
        return this.a[(n2 << 1) + this.offset + 1];
    }

    final void imag(int n2, double d2) {
        this.a[(n2 << 1) + this.offset + 1] = d2;
    }

    private int imagIdx(int n2) {
        return (n2 << 1) + this.offset + 1;
    }

    final void multiply(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        int n3 = this.realIdx(n2);
        n2 = this.imagIdx(n2);
        double d2 = this.a[n3];
        double d3 = this.a[n2];
        this.a[n3] = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.real, -d3 * fftMultiplier$MutableComplex.imag);
        this.a[n2] = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.imag, d3 * fftMultiplier$MutableComplex.real);
    }

    final void multiplyByIAnd(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        int n3 = this.realIdx(n2);
        n2 = this.imagIdx(n2);
        double d2 = this.a[n3];
        double d3 = this.a[n2];
        this.a[n3] = FastDoubleSwar.fma(-d2, fftMultiplier$MutableComplex.imag, -d3 * fftMultiplier$MutableComplex.real);
        this.a[n2] = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.real, -d3 * fftMultiplier$MutableComplex.imag);
    }

    final void multiplyConjugate(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        int n3 = this.realIdx(n2);
        n2 = this.imagIdx(n2);
        double d2 = this.a[n3];
        double d3 = this.a[n2];
        this.a[n3] = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.real, d3 * fftMultiplier$MutableComplex.imag);
        this.a[n2] = FastDoubleSwar.fma(-d2, fftMultiplier$MutableComplex.imag, d3 * fftMultiplier$MutableComplex.real);
    }

    final void multiplyConjugateInto(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex, FftMultiplier$MutableComplex fftMultiplier$MutableComplex2) {
        double d2 = this.a[this.realIdx(n2)];
        double d3 = this.a[this.imagIdx(n2)];
        fftMultiplier$MutableComplex2.real = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.real, d3 * fftMultiplier$MutableComplex.imag);
        fftMultiplier$MutableComplex2.imag = FastDoubleSwar.fma(-d2, fftMultiplier$MutableComplex.imag, d3 * fftMultiplier$MutableComplex.real);
    }

    final void multiplyConjugateTimesI(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        int n3 = this.realIdx(n2);
        n2 = this.imagIdx(n2);
        double d2 = this.a[n3];
        double d3 = this.a[n2];
        this.a[n3] = FastDoubleSwar.fma(-d2, fftMultiplier$MutableComplex.imag, d3 * fftMultiplier$MutableComplex.real);
        this.a[n2] = FastDoubleSwar.fma(-d2, fftMultiplier$MutableComplex.real, -d3 * fftMultiplier$MutableComplex.imag);
    }

    final void multiplyInto(int n2, FftMultiplier$MutableComplex fftMultiplier$MutableComplex, FftMultiplier$MutableComplex fftMultiplier$MutableComplex2) {
        double d2 = this.a[this.realIdx(n2)];
        double d3 = this.a[this.imagIdx(n2)];
        fftMultiplier$MutableComplex2.real = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.real, -d3 * fftMultiplier$MutableComplex.imag);
        fftMultiplier$MutableComplex2.imag = FastDoubleSwar.fma(d2, fftMultiplier$MutableComplex.imag, d3 * fftMultiplier$MutableComplex.real);
    }

    final void multiplyPointwise(FftMultiplier$ComplexVector object) {
        int n2 = ((FftMultiplier$ComplexVector)object).offset;
        object = ((FftMultiplier$ComplexVector)object).a;
        int n3 = this.offset + this.length << 1;
        for (int i2 = this.offset; i2 < n3; i2 += 2) {
            double d2 = this.a[i2];
            double d3 = this.a[i2 + 1];
            Object object2 = object[n2];
            Object object3 = object[n2 + 1];
            this.a[i2] = FastDoubleSwar.fma(d2, (double)object2, -d3 * object3);
            this.a[i2 + 1] = FastDoubleSwar.fma(d2, (double)object3, d3 * object2);
            n2 += 2;
        }
    }

    final double part(int n2, int n3) {
        return this.a[(n2 << 1) + n3];
    }

    final double real(int n2) {
        return this.a[(n2 << 1) + this.offset];
    }

    final void real(int n2, double d2) {
        this.a[(n2 << 1) + this.offset] = d2;
    }

    private int realIdx(int n2) {
        return (n2 << 1) + this.offset;
    }

    final void set(int n2, double d2, double d3) {
        n2 = this.realIdx(n2);
        this.a[n2] = d2;
        this.a[n2 + 1] = d3;
    }

    final void squarePointwise() {
        int n2 = this.offset + this.length << 1;
        for (int i2 = this.offset; i2 < n2; i2 += 2) {
            double d2 = this.a[i2];
            double d3 = this.a[i2 + 1];
            double d4 = d2;
            this.a[i2] = FastDoubleSwar.fma(d4, d4, -d3 * d3);
            this.a[i2 + 1] = d2 * 2.0 * d3;
        }
    }

    final void subtractInto(int n2, FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n3, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        fftMultiplier$MutableComplex.real = this.a[this.realIdx(n2)] - fftMultiplier$ComplexVector.real(n3);
        fftMultiplier$MutableComplex.imag = this.a[this.imagIdx(n2)] - fftMultiplier$ComplexVector.imag(n3);
    }

    final void subtractTimesIInto(int n2, FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n3, FftMultiplier$MutableComplex fftMultiplier$MutableComplex) {
        fftMultiplier$MutableComplex.real = this.a[this.realIdx(n2)] + fftMultiplier$ComplexVector.imag(n3);
        fftMultiplier$MutableComplex.imag = this.a[this.imagIdx(n2)] - fftMultiplier$ComplexVector.real(n3);
    }

    final void timesTwoToThe(int n2, int n3) {
        int n4 = this.realIdx(n2);
        n2 = this.imagIdx(n2);
        double d2 = this.a[n4];
        double d3 = this.a[n2];
        this.a[n4] = FastDoubleMath.fastScalb(d2, n3);
        this.a[n2] = FastDoubleMath.fastScalb(d3, n3);
    }

    static /* synthetic */ int access$000(FftMultiplier$ComplexVector fftMultiplier$ComplexVector) {
        return fftMultiplier$ComplexVector.length;
    }
}

