/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractJavaFloatingPointBitsFromByteArray;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleMath;
import java.nio.charset.StandardCharsets;

final class JavaDoubleBitsFromByteArray
extends AbstractJavaFloatingPointBitsFromByteArray {
    @Override
    final long nan() {
        return Double.doubleToRawLongBits(Double.NaN);
    }

    @Override
    final long negativeInfinity() {
        return Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY);
    }

    @Override
    final long positiveInfinity() {
        return Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    }

    @Override
    final long valueOfFloatLiteral(byte[] byArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        double d2 = FastDoubleMath.tryDecFloatToDoubleTruncated(bl2, l2, n4, bl3, n5);
        return Double.doubleToRawLongBits(Double.isNaN(d2) ? Double.parseDouble(new String(byArray, n2, n3 - n2, StandardCharsets.ISO_8859_1)) : d2);
    }

    @Override
    final long valueOfHexLiteral(byte[] byArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        double d2 = FastDoubleMath.tryHexFloatToDoubleTruncated(bl2, l2, n4, bl3, n5);
        return Double.doubleToRawLongBits(Double.isNaN(d2) ? Double.parseDouble(new String(byArray, n2, n3 - n2, StandardCharsets.ISO_8859_1)) : d2);
    }
}

