/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.BigSignificand;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier;
import java.math.BigInteger;
import java.util.Map;

class ParseDigitsTaskCharSequence {
    private ParseDigitsTaskCharSequence() {
    }

    static BigInteger parseDigitsIterative(CharSequence charSequence, int n2, int n3) {
        assert (charSequence != null) : "str==null";
        int n4 = n3 - n2;
        BigSignificand bigSignificand = new BigSignificand(FastIntegerMath.estimateNumBits(n4));
        boolean bl2 = (n2 = FastDoubleSwar.tryToParseUpTo7Digits(charSequence, n2, n4 = n2 + (n4 & 7))) >= 0;
        bigSignificand.add(n2);
        for (n2 = n4; n2 < n3; n2 += 8) {
            n4 = FastDoubleSwar.tryToParseEightDigits(charSequence, n2);
            bl2 &= n4 >= 0;
            bigSignificand.fma(100000000, n4);
        }
        if (!bl2) {
            throw new NumberFormatException("illegal syntax");
        }
        return bigSignificand.toBigInteger();
    }

    static BigInteger parseDigitsRecursive(CharSequence object, int n2, int n3, Map<Integer, BigInteger> map, int n4) {
        assert (object != null) : "str==null";
        assert (map != null) : "powersOfTen==null";
        int n5 = n3 - n2;
        if (n5 <= n4) {
            return ParseDigitsTaskCharSequence.parseDigitsIterative((CharSequence)object, n2, n3);
        }
        n5 = FastIntegerMath.splitFloor16(n2, n3);
        BigInteger bigInteger = ParseDigitsTaskCharSequence.parseDigitsRecursive((CharSequence)object, n2, n5, map, n4);
        object = ParseDigitsTaskCharSequence.parseDigitsRecursive((CharSequence)object, n5, n3, map, n4);
        bigInteger = FftMultiplier.multiply(bigInteger, map.get(n3 - n5));
        return ((BigInteger)object).add(bigInteger);
    }
}

