/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS_UPPER = CharTypes.copyHexChars(true);
    protected static final char[] HEX_CHARS_LOWER = CharTypes.copyHexChars(false);
    protected final Writer _writer;
    protected char _quoteChar;
    protected char[] _outputBuffer;
    protected int _outputHead;
    protected int _outputTail;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;
    protected char[] _copyBuffer;

    private char[] getHexChars() {
        if (this._cfgWriteHexUppercase) {
            return HEX_CHARS_UPPER;
        }
        return HEX_CHARS_LOWER;
    }

    @Deprecated
    public WriterBasedJsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, Writer writer) {
        this(iOContext, n2, objectCodec, writer, '\"');
    }

    public WriterBasedJsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, Writer writer, char c2) {
        super(iOContext, n2, objectCodec);
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._quoteChar = c2;
        boolean bl2 = ((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_FORWARD_SLASHES.mappedFeature());
        if (c2 != '\"' || bl2) {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2, bl2);
        }
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        int n2 = this._outputTail - this._outputHead;
        return Math.max(0, n2);
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public void writeFieldName(String string) throws IOException {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string, n2 == 1);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n2 == 1);
    }

    protected void _writeFieldName(String string, boolean bl2) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl2);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl2) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected void _writeFieldName(SerializableString serializableString, boolean n2) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, n2 != 0);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (n2) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            char[] cArray = serializableString.asQuotedChars();
            ((JsonGenerator)this).writeRaw(cArray, 0, cArray.length);
            return;
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        n2 = serializableString.appendQuoted(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeFieldNameTail(serializableString);
            return;
        }
        this._outputTail += n2;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected void _writeFieldNameTail(SerializableString object) throws IOException {
        object = object.asQuotedChars();
        ((JsonGenerator)this).writeRaw((char[])object, 0, ((Object)object).length);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeStartArray(Object object) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeStartArray(Object object, int n2) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            this._cfgPrettyPrinter.writeEndArray(writerBasedJsonGenerator, writerBasedJsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object) throws IOException {
        this._verifyValueWrite("start an object");
        object = this._writeContext.createChildObjectContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        this._writeContext = object;
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object, int n2) throws IOException {
        ((JsonGenerator)this).writeStartObject(object);
    }

    @Override
    public void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            this._cfgPrettyPrinter.writeEndObject(writerBasedJsonGenerator, writerBasedJsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    protected void _writePPFieldName(String string, boolean bl2) throws IOException {
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected void _writePPFieldName(SerializableString object, boolean bl2) throws IOException {
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        object = object.asQuotedChars();
        if (this._cfgUnqNames) {
            ((JsonGenerator)this).writeRaw((char[])object, 0, ((Object)object).length);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw((char[])object, 0, ((Object)object).length);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(String string) throws IOException {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n2) throws IOException {
        int n3;
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n4 = n3 = n2 >= 0 ? n2 : Integer.MAX_VALUE;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        char[] cArray = this._allocateCopyBuffer();
        while (n3 > 0) {
            int n5 = Math.min(n3, cArray.length);
            if ((n5 = reader.read(cArray, 0, n5)) <= 0) break;
            this._writeString(cArray, 0, n5);
            n3 -= n5;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 > 0 && n2 >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(cArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n2 = serializableString.appendQuoted(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeString2(serializableString);
            return;
        }
        this._outputTail += n2;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private void _writeString2(SerializableString object) throws IOException {
        char[] cArray = object.asQuotedChars();
        object = cArray;
        int n2 = cArray.length;
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(object, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            this._writer.write((char[])object, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) throws IOException {
        int n2 = string.length();
        int n3 = this._outputEnd - this._outputTail;
        if (n3 == 0) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(0, n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
            return;
        }
        this.writeRawLong(string);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        this._checkRangeBoundsForString(string, n2, n3);
        int n4 = this._outputEnd - this._outputTail;
        if (n4 < n3) {
            this._flushBuffer();
            n4 = this._outputEnd - this._outputTail;
        }
        if (n4 >= n3) {
            int n5 = n2;
            string.getChars(n5, n5 + n3, this._outputBuffer, this._outputTail);
            this._outputTail += n3;
            return;
        }
        int n6 = n2;
        this.writeRawLong(string.substring(n6, n6 + n3));
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException {
        int n2 = serializableString.appendUnquoted(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            ((JsonGenerator)this).writeRaw(serializableString.getValue());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        this._checkRangeBoundsForCharArray(cArray, n2, n3);
        if (n3 < 32) {
            int n4 = this._outputEnd - this._outputTail;
            if (n3 > n4) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n2, n3);
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c2;
    }

    private void writeRawLong(String string) throws IOException {
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n3 = string.length() - n3; n3 > this._outputEnd; n3 -= n2) {
            n2 = this._outputEnd;
            int n5 = n4;
            string.getChars(n5, n5 + n2, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        int n6 = n4;
        string.getChars(n6, n6 + n3, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n3;
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n4 = n2;
        this._writeBinary(base64Variant, byArray, n4, n4 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException, JsonGenerationException {
        int n3;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n2 < 0) {
                n3 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
                }
                n3 = n2;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return n3;
    }

    @Override
    public void writeNumber(short s2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s2);
            return;
        }
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedShort(short s2) throws IOException {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(int n2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedInt(int n2) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(long l2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedLong(long l2) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
            return;
        }
        ((JsonGenerator)this).writeRaw(bigInteger.toString());
    }

    @Override
    public void writeNumber(double d2) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(d2) && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(float f2) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(f2) && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._writeQuotedRaw(writerBasedJsonGenerator._asString(bigDecimal));
            return;
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        ((JsonGenerator)writerBasedJsonGenerator).writeRaw(writerBasedJsonGenerator._asString(bigDecimal));
    }

    @Override
    public void writeNumber(String string) throws IOException {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
            return;
        }
        ((JsonGenerator)this).writeRaw(string);
    }

    @Override
    public void writeNumber(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(cArray, n2, n3);
            return;
        }
        ((JsonGenerator)this).writeRaw(cArray, n2, n3);
    }

    private void _writeQuotedRaw(String string) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private void _writeQuotedRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw(cArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl2) {
            cArray[n2] = 116;
            cArray[++n2] = 114;
            cArray[++n2] = 117;
            cArray[++n2] = 101;
        } else {
            cArray[n2] = 102;
            cArray[++n2] = 97;
            cArray[++n2] = 108;
            cArray[++n2] = 115;
            cArray[++n2] = 101;
        }
        this._outputTail = n2 + 1;
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected void _verifyValueWrite(String string) throws IOException {
        int n2;
        int n3 = this._writeContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite(string, n3);
            return;
        }
        switch (n3) {
            default: {
                return;
            }
            case 1: {
                n2 = 44;
                break;
            }
            case 2: {
                n2 = 58;
                break;
            }
            case 3: {
                if (this._rootValueSeparator != null) {
                    WriterBasedJsonGenerator writerBasedJsonGenerator = this;
                    ((JsonGenerator)writerBasedJsonGenerator).writeRaw(writerBasedJsonGenerator._rootValueSeparator.getValue());
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName(string);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = n2;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._writer != null && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        Object object;
        super.close();
        IOException iOException = null;
        try {
            if (this._outputBuffer != null && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
                while (true) {
                    if (((JsonStreamContext)(object = ((JsonGenerator)this).getOutputContext())).inArray()) {
                        ((JsonGenerator)this).writeEndArray();
                        continue;
                    }
                    if (!((JsonStreamContext)object).inObject()) break;
                    ((JsonGenerator)this).writeEndObject();
                }
            }
            this._flushBuffer();
        }
        catch (IOException iOException2) {
            object = iOException2;
            iOException = iOException2;
        }
        this._outputHead = 0;
        this._outputTail = 0;
        if (this._writer != null) {
            try {
                if (this._ioContext.isResourceManaged() || ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                    this._writer.close();
                } else if (((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                    this._writer.flush();
                }
            }
            catch (IOException | RuntimeException exception) {
                if (iOException != null) {
                    exception.addSuppressed(iOException);
                }
                throw exception;
            }
        }
        this._releaseBuffers();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (this._outputBuffer != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
        cArray = this._copyBuffer;
        if (this._copyBuffer != null) {
            this._copyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    private void _writeString(String string) throws IOException {
        int n2 = string.length();
        if (n2 > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n2, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n2, this._maximumNonEscapedChar);
            return;
        }
        this._writeString2(n2);
    }

    private void _writeString2(int n2) throws IOException {
        n2 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n3 = this._outputEscapes.length;
        block0: while (this._outputTail < n2) {
            char c2;
            while ((c2 = this._outputBuffer[this._outputTail]) >= n3 || nArray[c2] == 0) {
                if (++this._outputTail >= n2) break block0;
            }
            c2 = this._outputTail - this._outputHead;
            if (c2 > '\u0000') {
                this._writer.write(this._outputBuffer, this._outputHead, (int)c2);
            }
            c2 = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeLongString(String string) throws IOException {
        int n2;
        this._flushBuffer();
        int n3 = string.length();
        int n4 = 0;
        do {
            n2 = n4 + (n2 = this._outputEnd) > n3 ? n3 - n4 : n2;
            int n5 = n4;
            string.getChars(n5, n5 + n2, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n2);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n2, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n2);
        } while ((n4 += n2) < n3);
    }

    private void _writeSegment(int n2) throws IOException {
        int[] nArray = this._outputEscapes;
        int n3 = this._outputEscapes.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            char c2;
            while (((c2 = this._outputBuffer[n4]) >= n3 || nArray[c2] == 0) && ++n4 < n2) {
            }
            int n6 = n4 - n5;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, n5, n6);
                if (n4 >= n2) break;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            n5 = writerBasedJsonGenerator._prependOrWriteCharacterEscape(writerBasedJsonGenerator._outputBuffer, ++n4, n2, c2, nArray[c2]);
        }
    }

    private void _writeString(char[] cArray, int n2, int n3) throws IOException {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n2, n3);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n2, n3, this._maximumNonEscapedChar);
            return;
        }
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n4 = this._outputEscapes.length;
        while (n2 < n3) {
            int n5;
            char c2 = n2;
            while (((n5 = cArray[n2]) >= n4 || nArray[n5] == 0) && ++n2 < n3) {
            }
            n5 = n2 - c2;
            if (n5 < 32) {
                if (this._outputTail + n5 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n5 > 0) {
                    System.arraycopy(cArray, c2, this._outputBuffer, this._outputTail, n5);
                    this._outputTail += n5;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, (int)c2, n5);
            }
            if (n2 >= n3) break;
            c2 = cArray[n2++];
            this._appendCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeStringASCII(int n2, int n3) throws IOException, JsonGenerationException {
        n2 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(this._outputEscapes.length, n3 + 1);
        while (this._outputTail < n2) {
            int n5;
            char c2;
            block5: {
                do {
                    if ((c2 = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[c2];
                        if (n5 == 0) continue;
                    } else {
                        if (c2 <= n3) continue;
                        n5 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n2);
                return;
            }
            int n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c2, n5);
        }
    }

    private void _writeSegmentASCII(int n2, int n3) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(this._outputEscapes.length, n3 + 1);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n2) {
            char c2;
            do {
                if ((c2 = this._outputBuffer[n5]) < n4) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n3) continue;
                n6 = -1;
                break;
            } while (++n5 < n2);
            int n8 = n5 - n7;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n7, n8);
                if (n5 >= n2) break;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            n7 = writerBasedJsonGenerator._prependOrWriteCharacterEscape(writerBasedJsonGenerator._outputBuffer, ++n5, n2, c2, n6);
        }
    }

    private void _writeStringASCII(char[] cArray, int n2, int n3, int n4) throws IOException, JsonGenerationException {
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(this._outputEscapes.length, n4 + 1);
        int n6 = 0;
        while (n2 < n3) {
            char c2;
            int n7 = n2;
            do {
                if ((c2 = cArray[n2]) < n5) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n4) continue;
                n6 = -1;
                break;
            } while (++n2 < n3);
            int n8 = n2 - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n2 >= n3) break;
            ++n2;
            this._appendCharacterEscape(c2, n6);
        }
    }

    private void _writeStringCustom(int n2) throws IOException, JsonGenerationException {
        n2 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n2) {
            int n5;
            int n6;
            block7: {
                do {
                    if ((n6 = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[n6];
                        if (n5 == 0) continue;
                    } else if (n6 > n3) {
                        n5 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n6);
                        if (this._currentEscape == null) continue;
                        n5 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n2);
                return;
            }
            int n7 = this._outputTail - this._outputHead;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n7);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n6, n5);
        }
    }

    private void _writeSegmentCustom(int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n2) {
            int n8;
            do {
                if ((n8 = this._outputBuffer[n5]) < n4) {
                    n6 = nArray[n8];
                    if (n6 == 0) continue;
                    break;
                }
                if (n8 > n3) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n8);
                if (this._currentEscape == null) continue;
                n6 = -2;
                break;
            } while (++n5 < n2);
            int n9 = n5 - n7;
            if (n9 > 0) {
                this._writer.write(this._outputBuffer, n7, n9);
                if (n5 >= n2) break;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            n7 = writerBasedJsonGenerator._prependOrWriteCharacterEscape(writerBasedJsonGenerator._outputBuffer, ++n5, n2, (char)n8, n6);
        }
    }

    private void _writeStringCustom(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n5 = Math.min(nArray.length, n4 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n6 = 0;
        while (n2 < n3) {
            int n7;
            int n8 = n2;
            do {
                if ((n7 = cArray[n2]) < n5) {
                    n6 = nArray[n7];
                    if (n6 == 0) continue;
                    break;
                }
                if (n7 > n4) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n6 = -2;
                break;
            } while (++n2 < n3);
            int n9 = n2 - n8;
            if (n9 < 32) {
                if (this._outputTail + n9 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n9 > 0) {
                    System.arraycopy(cArray, n8, this._outputBuffer, this._outputTail, n9);
                    this._outputTail += n9;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n8, n9);
            }
            if (n2 >= n3) break;
            ++n2;
            this._appendCharacterEscape((char)n7, n6);
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4;
        int n5 = n3 - 3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n5) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n4 = byArray[n2++] << 8;
            n4 |= byArray[n2++] & 0xFF;
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n4, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        n4 = n3 - n2;
        if (n4 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n3 = byArray[n2++] << 16;
            if (n4 == 2) {
                n3 |= (byArray[n2] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n4, this._outputBuffer, this._outputTail);
        }
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = -3;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            if (n4 > n6) {
                n5 = this._readMore(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 3) break;
                n6 = n5 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[n4++] << 8;
            n3 |= byArray[n4++] & 0xFF;
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0 && (n5 = this._readMore(inputStream, byArray, n4, n5, n2)) > 0) {
            int n9;
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[0] << 16;
            if (1 < n5) {
                n3 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            } else {
                n9 = 1;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n9, this._outputBuffer, this._outputTail);
            n2 -= n9;
        }
        return n2;
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) throws IOException, JsonGenerationException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = 0;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, byArray.length);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n6 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n4 > 0) {
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[0] << 16;
            int n9 = 1;
            if (1 < n4) {
                n2 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            }
            n6 += n9;
            this._outputTail = base64Variant.encodeBase64Partial(n2, n9, this._outputBuffer, this._outputTail);
        }
        return n6;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5 = 0;
        while (n2 < n3) {
            byArray[n5++] = byArray[n2++];
        }
        n3 = n5;
        n4 = Math.min(n4, byArray.length);
        while ((n2 = n4 - n3) != 0) {
            if ((n2 = inputStream.read(byArray, n3, n2)) < 0) {
                return n3;
            }
            if ((n3 += n2) < 3) continue;
        }
        return n3;
    }

    private final void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        char[] cArray = this._outputBuffer;
        this._outputBuffer[n2] = 110;
        cArray[++n2] = 117;
        cArray[++n2] = 108;
        cArray[++n2] = 108;
        this._outputTail = n2 + 1;
    }

    private void _prependOrWriteCharacterEscape(char c2, int n2) throws IOException, JsonGenerationException {
        String string;
        if (n2 >= 0) {
            if (this._outputTail >= 2) {
                int n3;
                this._outputHead = n3 = this._outputTail - 2;
                this._outputBuffer[n3++] = 92;
                this._outputBuffer[n3] = (char)n2;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (this._entityBuffer == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n2;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n2 != -2) {
            char[] cArray = this.getHexChars();
            if (this._outputTail >= 6) {
                int n4;
                char[] cArray2 = this._outputBuffer;
                this._outputHead = n4 = this._outputTail - 6;
                cArray2[n4] = 92;
                cArray2[++n4] = 117;
                if (c2 > '\u00ff') {
                    int n5 = c2 >> 8 & 0xFF;
                    cArray2[++n4] = cArray[n5 >> 4];
                    cArray2[++n4] = cArray[n5 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray2[++n4] = 48;
                    cArray2[++n4] = 48;
                }
                cArray2[++n4] = cArray[c2 >> 4];
                cArray2[++n4] = cArray[c2 & 0xF];
                return;
            }
            char[] cArray3 = this._entityBuffer;
            if (this._entityBuffer == null) {
                cArray3 = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c2 > '\u00ff') {
                int n6 = c2 >> 8 & 0xFF;
                int n7 = c2 & 0xFF;
                cArray3[10] = cArray[n6 >> 4];
                cArray3[11] = cArray[n6 & 0xF];
                cArray3[12] = cArray[n7 >> 4];
                cArray3[13] = cArray[n7 & 0xF];
                this._writer.write(cArray3, 8, 6);
                return;
            }
            cArray3[6] = cArray[c2 >> 4];
            cArray3[7] = cArray[c2 & 0xF];
            this._writer.write(cArray3, 2, 6);
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        n2 = string.length();
        if (this._outputTail >= n2) {
            int n8;
            this._outputHead = n8 = this._outputTail - n2;
            string.getChars(0, n2, this._outputBuffer, n8);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string);
    }

    private int _prependOrWriteCharacterEscape(char[] cArray, int n2, int n3, char c2, int n4) throws IOException, JsonGenerationException {
        String string;
        if (n4 >= 0) {
            if (n2 > 1 && n2 < n3) {
                cArray[n2 -= 2] = 92;
                cArray[n2 + 1] = (char)n4;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n4;
                this._writer.write(cArray2, 0, 2);
            }
            return n2;
        }
        if (n4 != -2) {
            char[] cArray3 = this.getHexChars();
            if (n2 > 5 && n2 < n3) {
                n2 -= 6;
                cArray[n2++] = 92;
                cArray[n2++] = 117;
                if (c2 > '\u00ff') {
                    n4 = c2 >> 8 & 0xFF;
                    cArray[n2++] = cArray3[n4 >> 4];
                    cArray[n2++] = cArray3[n4 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray[n2++] = 48;
                    cArray[n2++] = 48;
                }
                cArray[n2++] = cArray3[c2 >> 4];
                cArray[n2] = cArray3[c2 & 0xF];
                n2 -= 5;
            } else {
                char[] cArray4 = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray4 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c2 > '\u00ff') {
                    int n5 = c2 >> 8 & 0xFF;
                    n3 = c2 & 0xFF;
                    cArray4[10] = cArray3[n5 >> 4];
                    cArray4[11] = cArray3[n5 & 0xF];
                    cArray4[12] = cArray3[n3 >> 4];
                    cArray4[13] = cArray3[n3 & 0xF];
                    this._writer.write(cArray4, 8, 6);
                } else {
                    cArray4[6] = cArray3[c2 >> 4];
                    cArray4[7] = cArray3[c2 & 0xF];
                    this._writer.write(cArray4, 2, 6);
                }
            }
            return n2;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        n4 = string.length();
        if (n2 >= n4 && n2 < n3) {
            string.getChars(0, n4, cArray, n2 -= n4);
        } else {
            this._writer.write(string);
        }
        return n2;
    }

    private void _appendCharacterEscape(char c2, int n2) throws IOException, JsonGenerationException {
        String string;
        if (n2 >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n2;
            return;
        }
        if (n2 != -2) {
            if (this._outputTail + 5 >= this._outputEnd) {
                this._flushBuffer();
            }
            n2 = this._outputTail;
            char[] cArray = this._outputBuffer;
            char[] cArray2 = this.getHexChars();
            cArray[n2++] = 92;
            cArray[n2++] = 117;
            if (c2 > '\u00ff') {
                int n3 = c2 >> 8 & 0xFF;
                cArray[n2++] = cArray2[n3 >> 4];
                cArray[n2++] = cArray2[n3 & 0xF];
                c2 = (char)(c2 & 0xFF);
            } else {
                cArray[n2++] = 48;
                cArray[n2++] = 48;
            }
            cArray[n2++] = cArray2[c2 >> 4];
            cArray[n2++] = cArray2[c2 & 0xF];
            this._outputTail = n2;
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n4 = string.length();
        if (this._outputTail + n4 > this._outputEnd) {
            this._flushBuffer();
            if (n4 > this._outputEnd) {
                this._writer.write(string);
                return;
            }
        }
        string.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail += n4;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        char[] cArray2 = cArray;
        cArray[0] = 92;
        cArray2[2] = 92;
        cArray2[3] = 117;
        cArray2[4] = 48;
        cArray2[5] = 48;
        cArray2[8] = 92;
        cArray2[9] = 117;
        this._entityBuffer = cArray2;
        return cArray2;
    }

    private char[] _allocateCopyBuffer() {
        if (this._copyBuffer == null) {
            this._copyBuffer = this._ioContext.allocNameCopyBuffer(2000);
        }
        return this._copyBuffer;
    }

    protected void _flushBuffer() throws IOException {
        int n2 = this._outputTail - this._outputHead;
        if (n2 > 0) {
            int n3 = this._outputHead;
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._outputHead = 0;
            writerBasedJsonGenerator._outputTail = 0;
            this._writer.write(this._outputBuffer, n3, n2);
        }
    }
}

