/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json.async;

import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import java.io.IOException;
import java.io.OutputStream;

public class NonBlockingJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteArrayFeeder {
    private byte[] _inputBuffer = NO_BYTES;

    public NonBlockingJsonParser(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    @Override
    public ByteArrayFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(byte[] byArray, int n2, int n3) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        if (n3 < n2) {
            this._reportError("Input end (%d) may not be before start (%d)", n3, n2);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
        this._currInputRowStart = n2 - (this._inputEnd - this._currInputRowStart);
        this._currBufferStart = n2;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._origBufferLen = n3 - n2;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0) {
            outputStream.write(this._inputBuffer, this._inputPtr, n2);
        }
        return n2;
    }

    @Override
    protected byte getNextSignedByteFromBuffer() {
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected int getNextUnsignedByteFromBuffer() {
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    @Override
    protected byte getByteFromBuffer(int n2) {
        return this._inputBuffer[n2];
    }
}

