/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JsonRecyclerPools$BoundedPool;
import com.fasterxml.jackson.core.util.JsonRecyclerPools$ConcurrentDequePool;
import com.fasterxml.jackson.core.util.JsonRecyclerPools$LockFreePool;
import com.fasterxml.jackson.core.util.JsonRecyclerPools$NonRecyclingPool;
import com.fasterxml.jackson.core.util.JsonRecyclerPools$ThreadLocalPool;
import com.fasterxml.jackson.core.util.RecyclerPool;

public final class JsonRecyclerPools {
    public static RecyclerPool<BufferRecycler> defaultPool() {
        return JsonRecyclerPools.threadLocalPool();
    }

    public static RecyclerPool<BufferRecycler> threadLocalPool() {
        return JsonRecyclerPools$ThreadLocalPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> nonRecyclingPool() {
        return JsonRecyclerPools$NonRecyclingPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> sharedConcurrentDequePool() {
        return JsonRecyclerPools$ConcurrentDequePool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> newConcurrentDequePool() {
        return JsonRecyclerPools$ConcurrentDequePool.construct();
    }

    @Deprecated
    public static RecyclerPool<BufferRecycler> sharedLockFreePool() {
        return JsonRecyclerPools$LockFreePool.GLOBAL;
    }

    @Deprecated
    public static RecyclerPool<BufferRecycler> newLockFreePool() {
        return JsonRecyclerPools$LockFreePool.construct();
    }

    public static RecyclerPool<BufferRecycler> sharedBoundedPool() {
        return JsonRecyclerPools$BoundedPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> newBoundedPool(int n2) {
        return JsonRecyclerPools$BoundedPool.construct(n2);
    }
}

