/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LinkedNode;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final JacksonFeatureSet<StreamReadCapability> _readCapabilities;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    protected DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        this._factory = Objects.requireNonNull(deserializerFactory);
        if (deserializerCache == null) {
            deserializerCache = new DeserializerCache();
        }
        this._cache = deserializerCache;
        this._featureFlags = 0;
        this._readCapabilities = null;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerCache deserializerCache) {
        this._cache = deserializerCache;
        this._factory = deserializationContext._factory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._readCapabilities = jsonParser == null ? null : jsonParser.getReadCapabilities();
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = ((MapperConfig)deserializationConfig).getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
        this._attributes = ((MapperConfig)deserializationConfig).getAttributes();
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._readCapabilities = null;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = null;
        this._parser = null;
        this._injectableValues = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext) {
        this._cache = deserializationContext._cache.emptyCopy();
        this._factory = deserializationContext._factory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        this._view = deserializationContext._view;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = null;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return ((MapperConfig)this._config).isEnabled(datatypeFeature);
    }

    @Override
    public final DatatypeFeatures getDatatypeFeatures() {
        return ((MapperConfig)this._config).getDatatypeFeatures();
    }

    @Override
    public final JsonFormat$Value getDefaultPropertyFormat(Class<?> clazz) {
        return ((MapperConfig)this._config).getDefaultPropertyFormat(clazz);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) throws IllegalArgumentException {
        if (((ResolvedType)javaType).hasRawClass(clazz)) {
            return javaType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(javaType, clazz, false);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public DeserializationContext setAttribute(Object object, Object object2) {
        this._attributes = this._attributes.withPerCallAttribute(object, object2);
        return this;
    }

    public JavaType getContextualType() {
        if (this._currentType == null) {
            return null;
        }
        return this._currentType.value();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadCapability streamReadCapability) {
        return this._readCapabilities.isEnabled(streamReadCapability);
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._featureFlags & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._featureFlags & n2) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) throws JsonMappingException {
        if (this._injectableValues == null) {
            return this.reportBadDefinition(ClassUtil.classOf(object), String.format("No 'injectableValues' configured, cannot inject value with id [%s]", object));
        }
        return this._injectableValues.findInjectableValue(object, this, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public CoercionAction findCoercionAction(LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        return this._config.findCoercionAction(logicalType, clazz, coercionInputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        return this._config.findCoercionFromBlankString(logicalType, clazz, coercionAction);
    }

    public TokenBuffer bufferForInputBuffering(JsonParser jsonParser) {
        return new TokenBuffer(jsonParser, this);
    }

    public final TokenBuffer bufferForInputBuffering() {
        DeserializationContext deserializationContext = this;
        return deserializationContext.bufferForInputBuffering(deserializationContext.getParser());
    }

    public TokenBuffer bufferAsCopyOfValue(JsonParser jsonParser) throws IOException {
        TokenBuffer tokenBuffer = this.bufferForInputBuffering(jsonParser);
        ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    public boolean hasValueDeserializerFor(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        try {
            DeserializationContext deserializationContext = this;
            return this._cache.hasValueDeserializerFor(deserializationContext, deserializationContext._factory, javaType);
        }
        catch (DatabindException databindException) {
            if (atomicReference != null) {
                atomicReference.set(databindException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        DeserializationContext deserializationContext = this;
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, javaType);
        if (jsonDeserializer != null) {
            jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType javaType) throws JsonMappingException {
        DeserializationContext deserializationContext = this;
        return this._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, javaType);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType object) throws JsonMappingException {
        DeserializationContext deserializationContext = this;
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, (JavaType)object);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, null, (JavaType)object);
        if ((object = this._factory.findTypeDeserializer(this._config, (JavaType)object)) != null) {
            object = ((TypeDeserializer)object).forProperty(null);
            return new TypeWrappedDeserializer((TypeDeserializer)object, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer;
        try {
            DeserializationContext deserializationContext = this;
            keyDeserializer = this._cache.findKeyDeserializer(deserializationContext, deserializationContext._factory, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((DatabindContext)this).reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            keyDeserializer = null;
        }
        if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(this, beanProperty);
        }
        return keyDeserializer;
    }

    public void flushCachedDeserializers() {
        this._cache.flushCachedDeserializers();
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        return ((DatabindContext)this).getTypeFactory().findClass(string);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            objectBuffer = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            DateFormat dateFormat = this._getDateFormat();
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", string, ClassUtil.exceptionMessage(parseException)));
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(((DatabindContext)this).getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public String extractScalarFromObject(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Class<?> clazz) throws IOException {
        return (String)this.handleUnexpectedToken(clazz, jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.readValue(jsonParser, ((DatabindContext)this).getTypeFactory().constructType(clazz));
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return ((DatabindContext)this).reportBadDefinition(javaType, "Could not find JsonDeserializer for type " + ClassUtil.getTypeDescription(javaType));
        }
        return (T)this._readValue(jsonParser, jsonDeserializer);
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, Class<T> clazz) throws IOException {
        return this.readPropertyValue(jsonParser, beanProperty, ((DatabindContext)this).getTypeFactory().constructType(clazz));
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findContextualValueDeserializer(javaType, beanProperty);
        if (jsonDeserializer == null) {
            return ((DatabindContext)this).reportBadDefinition(javaType, String.format("Could not find JsonDeserializer for type %s (via property %s)", ClassUtil.getTypeDescription(javaType), ClassUtil.nameOf(beanProperty)));
        }
        return (T)this._readValue(jsonParser, jsonDeserializer);
    }

    public JsonNode readTree(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            return this.getNodeFactory().missingNode();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return this.getNodeFactory().nullNode();
        }
        DeserializationContext deserializationContext = this;
        return (JsonNode)deserializationContext.findRootValueDeserializer(deserializationContext._config.constructType(JsonNode.class)).deserialize(jsonParser, this);
    }

    public <T> T readTreeAsValue(JsonNode object, Class<T> serializable) throws IOException {
        block10: {
            if (object == null || ((JsonNode)object).isMissingNode()) {
                return null;
            }
            object = this._treeAsTokens((JsonNode)object);
            Throwable throwable = null;
            try {
                serializable = this.readValue((JsonParser)object, (Class<T>)serializable);
                if (object == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((JsonParser)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((JsonParser)object).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((JsonParser)object).close();
        }
        return (T)serializable;
    }

    public <T> T readTreeAsValue(JsonNode object, JavaType serializable) throws IOException {
        block10: {
            if (object == null || ((JsonNode)object).isMissingNode()) {
                return null;
            }
            object = this._treeAsTokens((JsonNode)object);
            Throwable throwable = null;
            try {
                serializable = this.readValue((JsonParser)object, (JavaType)serializable);
                if (object == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((JsonParser)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((JsonParser)object).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((JsonParser)object).close();
        }
        return (T)serializable;
    }

    private TreeTraversingParser _treeAsTokens(JsonNode object) throws IOException {
        ObjectCodec objectCodec = this._parser == null ? null : this._parser.getCodec();
        object = new TreeTraversingParser((JsonNode)object, objectCodec);
        ((JsonParser)object).nextToken();
        return object;
    }

    private Object _readValue(JsonParser jsonParser, JsonDeserializer<Object> jsonDeserializer) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return jsonDeserializer.getNullValue(this);
        }
        return jsonDeserializer.deserialize(jsonParser, this);
    }

    public boolean handleUnknownProperty(JsonParser object, JsonDeserializer<?> jsonDeserializer, Object object2, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            if (!linkedNode.value().handleUnknownProperty(this, (JsonParser)object, jsonDeserializer, object2, string)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ((JsonParser)object).skipChildren();
            return true;
        }
        object = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object2, string, (Collection<Object>)object);
    }

    public Object handleWeirdKey(Class<?> clazz, String string, String string2, Object ... object) throws IOException {
        string2 = this._format(string2, (Object[])object);
        for (object = this._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdKey(this, clazz, string, string2);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 == null || clazz.isInstance(object2)) {
                return object2;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdKey() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object2)));
        }
        throw this.weirdKeyException(clazz, string, string2);
    }

    public Object handleWeirdStringValue(Class<?> clazz, String string, String string2, Object ... object) throws IOException {
        string2 = this._format(string2, (Object[])object);
        for (object = this._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdStringValue(this, clazz, string, string2);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object2)));
        }
        throw this.weirdStringException(string, clazz, string2);
    }

    public Object handleWeirdNumberValue(Class<?> clazz, Number number, String string, Object ... object) throws IOException {
        string = this._format(string, (Object[])object);
        for (object = this._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdNumberValue(this, clazz, number, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            throw this.weirdNumberException(number, clazz, this._format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object2)));
        }
        throw this.weirdNumberException(number, clazz, string);
    }

    public Object handleWeirdNativeValue(JavaType javaType, Object object, JsonParser jsonParser) throws IOException {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleWeirdNativeValue(this, javaType, object, jsonParser);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 == null || clazz.isInstance(object2)) {
                return object2;
            }
            throw JsonMappingException.from(jsonParser, this._format("DeserializationProblemHandler.handleWeirdNativeValue() for type %s returned value of type %s", ClassUtil.getClassDescription(javaType), ClassUtil.getClassDescription(object2)));
        }
        throw this.weirdNativeValueException(object, clazz);
    }

    public Object handleMissingInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator, JsonParser jsonParser, String string, Object ... object) throws IOException {
        if (jsonParser == null) {
            jsonParser = this.getParser();
        }
        string = this._format(string, (Object[])object);
        for (object = this._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleMissingInstantiator(this, clazz, valueInstantiator, jsonParser, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            DeserializationContext deserializationContext = this;
            ((DatabindContext)deserializationContext).reportBadDefinition(deserializationContext.constructType(clazz), String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object2)));
        }
        if (valueInstantiator == null) {
            string = String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(clazz), string);
            return this.reportBadDefinition(clazz, string);
        }
        if (!valueInstantiator.canInstantiate()) {
            string = String.format("Cannot construct instance of %s (no Creators, like default constructor, exist): %s", ClassUtil.nameOf(clazz), string);
            return this.reportBadDefinition(clazz, string);
        }
        string = String.format("Cannot construct instance of %s (although at least one Creator exists): %s", ClassUtil.nameOf(clazz), string);
        return this.reportInputMismatch(clazz, string, new Object[0]);
    }

    public Object handleInstantiationProblem(Class<?> clazz, Object object, Throwable throwable) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleInstantiationProblem(this, clazz, object, throwable);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            DeserializationContext deserializationContext = this;
            ((DatabindContext)deserializationContext).reportBadDefinition(deserializationContext.constructType(clazz), String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.classNameOf(object2)));
        }
        ClassUtil.throwIfIOE(throwable);
        if (!this.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw this.instantiationException(clazz, throwable);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonParser jsonParser) throws IOException {
        DeserializationContext deserializationContext = this;
        return deserializationContext.handleUnexpectedToken(deserializationContext.constructType(clazz), jsonParser.currentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        DeserializationContext deserializationContext = this;
        return deserializationContext.handleUnexpectedToken(deserializationContext.constructType(clazz), jsonToken, jsonParser, string, objectArray);
    }

    public Object handleUnexpectedToken(JavaType javaType, JsonParser jsonParser) throws IOException {
        return this.handleUnexpectedToken(javaType, jsonParser.currentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(JavaType javaType, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... object) throws IOException {
        Object object2;
        string = this._format(string, (Object[])object);
        for (object = this._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleUnexpectedToken(this, javaType, jsonToken, jsonParser, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(((ResolvedType)javaType).getRawClass(), object2)) {
                return object2;
            }
            ((DatabindContext)this).reportBadDefinition(javaType, String.format("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", ClassUtil.getTypeDescription(javaType), ClassUtil.classNameOf(object2)));
        }
        if (string == null) {
            object2 = ClassUtil.getTypeDescription(javaType);
            string = jsonToken == null ? String.format("Unexpected end-of-input when trying read value of type %s", object2) : String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`)", new Object[]{object2, this._shapeForToken(jsonToken), jsonToken});
        }
        if (jsonToken != null && jsonToken.isScalarValue()) {
            jsonParser.getText();
        }
        this.reportInputMismatch(javaType, string, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType javaType, String string, TypeIdResolver typeIdResolver, String string2) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleUnknownTypeId(this, javaType, string, typeIdResolver, string2);
            if (javaType2 == null) continue;
            if (((ResolvedType)javaType2).hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(((ResolvedType)javaType).getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, string, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.invalidTypeIdException(javaType, string, string2);
    }

    public JavaType handleMissingTypeId(JavaType javaType, TypeIdResolver typeIdResolver, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleMissingTypeId(this, javaType, typeIdResolver, string);
            if (javaType2 == null) continue;
            if (((ResolvedType)javaType2).hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(((ResolvedType)javaType).getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, null, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        throw this.missingTypeIdException(javaType, string);
    }

    public void handleBadMerge(JsonDeserializer<?> object) throws JsonMappingException {
        if (!((DatabindContext)this).isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            object = this.constructType(((JsonDeserializer)object).handledType());
            String string = String.format("Invalid configuration: values of type %s cannot be merged", ClassUtil.getTypeDescription((JavaType)object));
            throw InvalidDefinitionException.from(this.getParser(), string, (JavaType)object);
        }
    }

    protected boolean _isCompatible(Class<?> clazz, Object object) {
        if (object == null || clazz.isInstance(object)) {
            return true;
        }
        return clazz.isPrimitive() && ClassUtil.wrapperType(clazz).isInstance(object);
    }

    public void reportWrongTokenException(JsonDeserializer<?> jsonDeserializer, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        DeserializationContext deserializationContext = this;
        throw deserializationContext.wrongTokenException(deserializationContext.getParser(), jsonDeserializer.handledType(), jsonToken, string);
    }

    public void reportWrongTokenException(JavaType javaType, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        DeserializationContext deserializationContext = this;
        throw deserializationContext.wrongTokenException(deserializationContext.getParser(), javaType, jsonToken, string);
    }

    public void reportWrongTokenException(Class<?> clazz, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        DeserializationContext deserializationContext = this;
        throw deserializationContext.wrongTokenException(deserializationContext.getParser(), clazz, jsonToken, string);
    }

    public <T> T reportUnresolvedObjectId(ObjectIdReader objectIdReader, Object object) throws JsonMappingException {
        object = String.format("No Object Id found for an instance of %s, to assign to property '%s'", ClassUtil.classNameOf(object), objectIdReader.propertyName);
        return this.reportInputMismatch(objectIdReader.idProperty, (String)object, new Object[0]);
    }

    public <T> T reportInputMismatch(JsonDeserializer<?> jsonDeserializer, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), jsonDeserializer.handledType(), string);
    }

    public <T> T reportInputMismatch(Class<?> clazz, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), clazz, string);
    }

    public <T> T reportInputMismatch(JavaType javaType, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), javaType, string);
    }

    public <T> T reportInputMismatch(BeanProperty beanProperty, String object, Object ... object2) throws JsonMappingException {
        object = this._format((String)object, (Object[])object2);
        object2 = beanProperty == null ? null : beanProperty.getType();
        object = MismatchedInputException.from(this.getParser(), (JavaType)object2, (String)object);
        if (beanProperty != null && (object2 = beanProperty.getMember()) != null) {
            ((DatabindException)object).prependPath(((AnnotatedMember)object2).getDeclaringClass(), beanProperty.getName());
        }
        throw object;
    }

    public <T> T reportPropertyInputMismatch(Class<?> clazz, String string, String object, Object ... objectArray) throws JsonMappingException {
        object = this._format((String)object, objectArray);
        object = MismatchedInputException.from(this.getParser(), clazz, (String)object);
        if (string != null) {
            ((DatabindException)object).prependPath(clazz, string);
        }
        throw object;
    }

    public <T> T reportPropertyInputMismatch(JavaType javaType, String string, String string2, Object ... objectArray) throws JsonMappingException {
        return this.reportPropertyInputMismatch(((ResolvedType)javaType).getRawClass(), string, string2, objectArray);
    }

    public <T> T reportBadCoercion(JsonDeserializer<?> object, Class<?> clazz, Object object2, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        object = InvalidFormatException.from(this.getParser(), string, object2, clazz);
        throw object;
    }

    public <T> T reportTrailingTokens(Class<?> clazz, JsonParser jsonParser, JsonToken jsonToken) throws JsonMappingException {
        throw MismatchedInputException.from(jsonParser, clazz, String.format("Trailing token (of type %s) found after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS`", new Object[]{jsonToken, ClassUtil.nameOf(clazz)}));
    }

    @Override
    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) throws JsonMappingException {
        String string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid type definition for type %s: %s", string2, this._format(string, objectArray));
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... object) throws JsonMappingException {
        string = this._format(string, object);
        object = ClassUtil.nameOf(beanPropertyDefinition);
        String string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid definition for property %s (of type %s): %s", object, string2, string);
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) throws JsonMappingException {
        throw InvalidDefinitionException.from(this._parser, string, javaType);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JavaType javaType, JsonToken object, String string) {
        object = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.currentToken(), object});
        object = this._colonConcat((String)object, string);
        return MismatchedInputException.from(jsonParser, javaType, (String)object);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, Class<?> clazz, JsonToken object, String string) {
        object = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.currentToken(), object});
        object = this._colonConcat((String)object, string);
        return MismatchedInputException.from(jsonParser, clazz, (String)object);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize Map key of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        string2 = String.format("Cannot deserialize value of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2);
        return InvalidFormatException.from(this._parser, string2, string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from number %s: %s", ClassUtil.nameOf(clazz), String.valueOf(number), string), number, clazz);
    }

    public JsonMappingException weirdNativeValueException(Object object, Class<?> clazz) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from native value (`JsonToken.VALUE_EMBEDDED_OBJECT`) of type %s: incompatible types", ClassUtil.nameOf(clazz), ClassUtil.classNameOf(object)), object, clazz);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        String string;
        if (throwable == null) {
            string = "N/A";
        } else {
            string = ClassUtil.exceptionMessage(throwable);
            if (string == null) {
                string = ClassUtil.nameOf(throwable.getClass());
            }
        }
        string = String.format("Cannot construct instance of %s, problem: %s", ClassUtil.nameOf(clazz), string);
        return ValueInstantiationException.from(this._parser, string, this.constructType(clazz), throwable);
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        return ValueInstantiationException.from(this._parser, String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(clazz), string), this.constructType(clazz));
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' as a subtype of %s", string, ClassUtil.getTypeDescription(javaType));
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string3, string2), javaType, string);
    }

    public JsonMappingException missingTypeIdException(JavaType javaType, String string) {
        String string2 = String.format("Could not resolve subtype of %s", javaType);
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string2, string), javaType, null);
    }

    protected DateFormat _getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }

    protected String _shapeForToken(JsonToken jsonToken) {
        return JsonToken.valueDescFor(jsonToken);
    }
}

