/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTyping;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;

public class ObjectMapper$DefaultTypeResolverBuilder
extends StdTypeResolverBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ObjectMapper$DefaultTyping _appliesFor;
    protected final PolymorphicTypeValidator _subtypeValidator;

    @Deprecated
    public ObjectMapper$DefaultTypeResolverBuilder(ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        this(objectMapper$DefaultTyping, LaissezFaireSubTypeValidator.instance);
    }

    public ObjectMapper$DefaultTypeResolverBuilder(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
        this._appliesFor = ObjectMapper$DefaultTypeResolverBuilder._requireNonNull(objectMapper$DefaultTyping, "Can not pass `null` DefaultTyping");
        this._subtypeValidator = ObjectMapper$DefaultTypeResolverBuilder._requireNonNull(polymorphicTypeValidator, "Can not pass `null` PolymorphicTypeValidator");
    }

    protected ObjectMapper$DefaultTypeResolverBuilder(ObjectMapper$DefaultTypeResolverBuilder objectMapper$DefaultTypeResolverBuilder, Class<?> clazz) {
        super(objectMapper$DefaultTypeResolverBuilder, clazz);
        this._appliesFor = objectMapper$DefaultTypeResolverBuilder._appliesFor;
        this._subtypeValidator = objectMapper$DefaultTypeResolverBuilder._subtypeValidator;
    }

    private static <T> T _requireNonNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException(string);
        }
        return t2;
    }

    public static ObjectMapper$DefaultTypeResolverBuilder construct(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ObjectMapper$DefaultTypeResolverBuilder(objectMapper$DefaultTyping, polymorphicTypeValidator);
    }

    @Override
    public ObjectMapper$DefaultTypeResolverBuilder withDefaultImpl(Class<?> clazz) {
        if (this._defaultImpl == clazz) {
            return this;
        }
        ClassUtil.verifyMustOverride(ObjectMapper$DefaultTypeResolverBuilder.class, this, "withDefaultImpl");
        return new ObjectMapper$DefaultTypeResolverBuilder(this, clazz);
    }

    @Override
    public PolymorphicTypeValidator subTypeValidator(MapperConfig<?> mapperConfig) {
        return this._subtypeValidator;
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
        if (this.useForType(javaType)) {
            return super.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        return null;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig serializationConfig, JavaType javaType, Collection<NamedType> collection) {
        if (this.useForType(javaType)) {
            return super.buildTypeSerializer(serializationConfig, javaType, collection);
        }
        return null;
    }

    public boolean useForType(JavaType javaType) {
        if (((ResolvedType)javaType).isPrimitive()) {
            return false;
        }
        switch (this._appliesFor) {
            case NON_CONCRETE_AND_ARRAYS: {
                while (((ResolvedType)javaType).isArrayType()) {
                    javaType = javaType.getContentType();
                }
            }
            case OBJECT_AND_NON_CONCRETE: {
                while (javaType.isReferenceType()) {
                    javaType = javaType.getReferencedType();
                }
                return javaType.isJavaLangObject() || !((ResolvedType)javaType).isConcrete() && !TreeNode.class.isAssignableFrom(((ResolvedType)javaType).getRawClass());
            }
            case NON_FINAL: {
                while (((ResolvedType)javaType).isArrayType()) {
                    javaType = javaType.getContentType();
                }
                while (javaType.isReferenceType()) {
                    javaType = javaType.getReferencedType();
                }
                return !((ResolvedType)javaType).isFinal() && !TreeNode.class.isAssignableFrom(((ResolvedType)javaType).getRawClass());
            }
            case NON_FINAL_AND_ENUMS: {
                while (((ResolvedType)javaType).isArrayType()) {
                    javaType = javaType.getContentType();
                }
                while (javaType.isReferenceType()) {
                    javaType = javaType.getReferencedType();
                }
                return !((ResolvedType)javaType).isFinal() && !TreeNode.class.isAssignableFrom(((ResolvedType)javaType).getRawClass()) || ((ResolvedType)javaType).isEnumType();
            }
            case EVERYTHING: {
                return true;
            }
        }
        return javaType.isJavaLangObject();
    }
}

