/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures$DefaultHolder;
import java.io.Serializable;

public class DatatypeFeatures
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int FEATURE_INDEX_ENUM = 0;
    protected static final int FEATURE_INDEX_JSON_NODE = 1;
    private final int _enabledFor1;
    private final int _enabledFor2;
    private final int _explicitFor1;
    private final int _explicitFor2;

    protected DatatypeFeatures(int n2, int n3, int n4, int n5) {
        this._enabledFor1 = n2;
        this._explicitFor1 = n3;
        this._enabledFor2 = n4;
        this._explicitFor2 = n5;
    }

    public static DatatypeFeatures defaultFeatures() {
        return DatatypeFeatures$DefaultHolder.getDefault();
    }

    private DatatypeFeatures _with(int n2, int n3, int n4, int n5) {
        if (this._enabledFor1 == n2 && this._explicitFor1 == n3 && this._enabledFor2 == n4 && this._explicitFor2 == n5) {
            return this;
        }
        return new DatatypeFeatures(n2, n3, n4, n5);
    }

    public DatatypeFeatures with(DatatypeFeature datatypeFeature) {
        int n2 = datatypeFeature.getMask();
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1 | n2, this._explicitFor1 | n2, this._enabledFor2, this._explicitFor2);
            }
            case 1: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1, this._explicitFor1, this._enabledFor2 | n2, this._explicitFor2 | n2);
            }
        }
        VersionUtil.throwInternal();
        return this;
    }

    public DatatypeFeatures withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = DatatypeFeatures._calcMask(datatypeFeatureArray);
        if (n2 == 0) {
            return this;
        }
        switch (datatypeFeatureArray[0].featureIndex()) {
            case 0: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1 | n2, this._explicitFor1 | n2, this._enabledFor2, this._explicitFor2);
            }
            case 1: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1, this._explicitFor1, this._enabledFor2 | n2, this._explicitFor2 | n2);
            }
        }
        VersionUtil.throwInternal();
        return this;
    }

    public DatatypeFeatures without(DatatypeFeature datatypeFeature) {
        int n2 = datatypeFeature.getMask();
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1 & ~n2, this._explicitFor1 | n2, this._enabledFor2, this._explicitFor2);
            }
            case 1: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1, this._explicitFor1, this._enabledFor2 & ~n2, this._explicitFor2 | n2);
            }
        }
        VersionUtil.throwInternal();
        return this;
    }

    public DatatypeFeatures withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = DatatypeFeatures._calcMask(datatypeFeatureArray);
        if (n2 == 0) {
            return this;
        }
        switch (datatypeFeatureArray[0].featureIndex()) {
            case 0: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1 & ~n2, this._explicitFor1 | n2, this._enabledFor2, this._explicitFor2);
            }
            case 1: {
                DatatypeFeatures datatypeFeatures = this;
                return datatypeFeatures._with(datatypeFeatures._enabledFor1, this._explicitFor1, this._enabledFor2 & ~n2, this._explicitFor2 | n2);
            }
        }
        VersionUtil.throwInternal();
        return this;
    }

    private static final int _calcMask(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = 0;
        for (DatatypeFeature datatypeFeature : datatypeFeatureArray) {
            n2 |= datatypeFeature.getMask();
        }
        return n2;
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._enabledFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._enabledFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public boolean isExplicitlySet(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._explicitFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._explicitFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public boolean isExplicitlyEnabled(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._explicitFor1 & this._enabledFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._explicitFor2 & this._enabledFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public boolean isExplicitlyDisabled(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._explicitFor1 & ~this._enabledFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._explicitFor2 & ~this._enabledFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public Boolean getExplicitState(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                if (datatypeFeature.enabledIn(this._explicitFor1)) {
                    return datatypeFeature.enabledIn(this._enabledFor1);
                }
                return null;
            }
            case 1: {
                if (datatypeFeature.enabledIn(this._explicitFor2)) {
                    return datatypeFeature.enabledIn(this._enabledFor2);
                }
                return null;
            }
        }
        VersionUtil.throwInternal();
        return null;
    }
}

