/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import java.io.Serializable;

public class DeserializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Deserializers[] NO_DESERIALIZERS = new Deserializers[0];
    protected static final BeanDeserializerModifier[] NO_MODIFIERS = new BeanDeserializerModifier[0];
    protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
    protected static final ValueInstantiators[] NO_VALUE_INSTANTIATORS = new ValueInstantiators[0];
    protected static final KeyDeserializers[] DEFAULT_KEY_DESERIALIZERS = new KeyDeserializers[]{new StdKeyDeserializers()};
    protected final Deserializers[] _additionalDeserializers;
    protected final KeyDeserializers[] _additionalKeyDeserializers;
    protected final BeanDeserializerModifier[] _modifiers;
    protected final AbstractTypeResolver[] _abstractTypeResolvers;
    protected final ValueInstantiators[] _valueInstantiators;

    public DeserializerFactoryConfig() {
        this(null, null, null, null, null);
    }

    protected DeserializerFactoryConfig(Deserializers[] deserializersArray, KeyDeserializers[] keyDeserializersArray, BeanDeserializerModifier[] beanDeserializerModifierArray, AbstractTypeResolver[] abstractTypeResolverArray, ValueInstantiators[] valueInstantiatorsArray) {
        this._additionalDeserializers = deserializersArray == null ? NO_DESERIALIZERS : deserializersArray;
        this._additionalKeyDeserializers = keyDeserializersArray == null ? DEFAULT_KEY_DESERIALIZERS : keyDeserializersArray;
        this._modifiers = beanDeserializerModifierArray == null ? NO_MODIFIERS : beanDeserializerModifierArray;
        this._abstractTypeResolvers = abstractTypeResolverArray == null ? NO_ABSTRACT_TYPE_RESOLVERS : abstractTypeResolverArray;
        this._valueInstantiators = valueInstantiatorsArray == null ? NO_VALUE_INSTANTIATORS : valueInstantiatorsArray;
    }

    public DeserializerFactoryConfig withAdditionalDeserializers(Deserializers deserializersArray) {
        if (deserializersArray == null) {
            throw new IllegalArgumentException("Cannot pass null Deserializers");
        }
        deserializersArray = ArrayBuilders.insertInListNoDup(this._additionalDeserializers, deserializersArray);
        return new DeserializerFactoryConfig(deserializersArray, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withAdditionalKeyDeserializers(KeyDeserializers keyDeserializersArray) {
        if (keyDeserializersArray == null) {
            throw new IllegalArgumentException("Cannot pass null KeyDeserializers");
        }
        keyDeserializersArray = ArrayBuilders.insertInListNoDup(this._additionalKeyDeserializers, keyDeserializersArray);
        return new DeserializerFactoryConfig(this._additionalDeserializers, keyDeserializersArray, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifierArray) {
        if (beanDeserializerModifierArray == null) {
            throw new IllegalArgumentException("Cannot pass null modifier");
        }
        beanDeserializerModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, beanDeserializerModifierArray);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, beanDeserializerModifierArray, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolverArray) {
        if (abstractTypeResolverArray == null) {
            throw new IllegalArgumentException("Cannot pass null resolver");
        }
        abstractTypeResolverArray = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, abstractTypeResolverArray);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, abstractTypeResolverArray, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withValueInstantiators(ValueInstantiators valueInstantiatorsArray) {
        if (valueInstantiatorsArray == null) {
            throw new IllegalArgumentException("Cannot pass null resolver");
        }
        valueInstantiatorsArray = ArrayBuilders.insertInListNoDup(this._valueInstantiators, valueInstantiatorsArray);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, valueInstantiatorsArray);
    }

    public boolean hasDeserializers() {
        return this._additionalDeserializers.length > 0;
    }

    public boolean hasKeyDeserializers() {
        return this._additionalKeyDeserializers.length > 0;
    }

    public boolean hasDeserializerModifiers() {
        return this._modifiers.length > 0;
    }

    public boolean hasAbstractTypeResolvers() {
        return this._abstractTypeResolvers.length > 0;
    }

    public boolean hasValueInstantiators() {
        return this._valueInstantiators.length > 0;
    }

    public Iterable<Deserializers> deserializers() {
        return new ArrayIterator<Deserializers>(this._additionalDeserializers);
    }

    public Iterable<KeyDeserializers> keyDeserializers() {
        return new ArrayIterator<KeyDeserializers>(this._additionalKeyDeserializers);
    }

    public Iterable<BeanDeserializerModifier> deserializerModifiers() {
        return new ArrayIterator<BeanDeserializerModifier>(this._modifiers);
    }

    public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
        return new ArrayIterator<AbstractTypeResolver>(this._abstractTypeResolvers);
    }

    public Iterable<ValueInstantiators> valueInstantiators() {
        return new ArrayIterator<ValueInstantiators>(this._valueInstantiators);
    }
}

