/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator$Base;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected transient Map<String, SettableBeanProperty> _properties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder object, BeanDescription beanDescription, Map<String, SettableBeanProperty> map, Map<String, SettableBeanProperty> map2) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = ((BeanDeserializerBuilder)object).getObjectIdReader();
        this._backRefProperties = map;
        this._properties = map2;
        object = ((ResolvedType)this._baseType).getRawClass();
        this._acceptString = ((Class)object).isAssignableFrom(String.class);
        this._acceptBoolean = object == Boolean.TYPE || ((Class)object).isAssignableFrom(Boolean.class);
        this._acceptInt = object == Integer.TYPE || ((Class)object).isAssignableFrom(Integer.class);
        this._acceptDouble = object == Double.TYPE || ((Class)object).isAssignableFrom(Double.class);
    }

    @Deprecated
    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map) {
        this(beanDeserializerBuilder, beanDescription, map, null);
    }

    protected AbstractDeserializer(BeanDescription object) {
        this._baseType = ((BeanDescription)object).getType();
        this._objectIdReader = null;
        this._backRefProperties = null;
        object = ((ResolvedType)this._baseType).getRawClass();
        this._acceptString = ((Class)object).isAssignableFrom(String.class);
        this._acceptBoolean = object == Boolean.TYPE || ((Class)object).isAssignableFrom(Boolean.class);
        this._acceptInt = object == Integer.TYPE || ((Class)object).isAssignableFrom(Integer.class);
        this._acceptDouble = object == Double.TYPE || ((Class)object).isAssignableFrom(Double.class);
    }

    protected AbstractDeserializer(AbstractDeserializer abstractDeserializer, ObjectIdReader objectIdReader, Map<String, SettableBeanProperty> map) {
        this._baseType = abstractDeserializer._baseType;
        this._backRefProperties = abstractDeserializer._backRefProperties;
        this._acceptString = abstractDeserializer._acceptString;
        this._acceptBoolean = abstractDeserializer._acceptBoolean;
        this._acceptInt = abstractDeserializer._acceptInt;
        this._acceptDouble = abstractDeserializer._acceptDouble;
        this._objectIdReader = objectIdReader;
        this._properties = map;
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDescription) {
        return new AbstractDeserializer(beanDescription);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty objectIdGenerator) throws JsonMappingException {
        ObjectIdInfo objectIdInfo;
        Serializable serializable2 = ((DatabindContext)((Object)serializable)).getAnnotationIntrospector();
        if (objectIdGenerator != null && serializable2 != null && (objectIdGenerator = objectIdGenerator.getMember()) != null && (objectIdInfo = serializable2.findObjectIdInfo((Annotated)((Object)objectIdGenerator))) != null) {
            Object object;
            SettableBeanProperty settableBeanProperty = null;
            ObjectIdResolver objectIdResolver = serializable.objectIdResolverInstance((Annotated)((Object)objectIdGenerator), objectIdInfo);
            if ((serializable2 = (objectIdInfo = serializable2.findObjectReferenceInfo((Annotated)((Object)objectIdGenerator), objectIdInfo)).getGeneratorType()) == ObjectIdGenerators$PropertyGenerator.class) {
                object = objectIdInfo.getPropertyName();
                settableBeanProperty = this._properties == null ? null : this._properties.get(((PropertyName)object).getSimpleName());
                if (settableBeanProperty == null) {
                    ((DatabindContext)((Object)serializable)).reportBadDefinition(this._baseType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.nameOf(((JsonDeserializer)this).handledType()), ClassUtil.name((PropertyName)object)));
                }
                serializable2 = settableBeanProperty.getType();
                objectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
            } else {
                objectIdResolver = serializable.objectIdResolverInstance((Annotated)((Object)objectIdGenerator), objectIdInfo);
                object = serializable.constructType((Class<?>)serializable2);
                serializable2 = ((DatabindContext)((Object)serializable)).getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
                objectIdGenerator = serializable.objectIdGeneratorInstance((Annotated)((Object)objectIdGenerator), objectIdInfo);
            }
            object = serializable.findRootValueDeserializer((JavaType)serializable2);
            serializable = ObjectIdReader.construct((JavaType)serializable2, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty, objectIdResolver);
            return new AbstractDeserializer(this, (ObjectIdReader)serializable, null);
        }
        if (this._properties == null) {
            return this;
        }
        AbstractDeserializer abstractDeserializer = this;
        return new AbstractDeserializer(abstractDeserializer, abstractDeserializer._objectIdReader, null);
    }

    @Override
    public Class<?> handledType() {
        return ((ResolvedType)this._baseType).getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        if (this._backRefProperties == null) {
            return null;
        }
        return this._backRefProperties.get(string);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        Object object;
        if (this._objectIdReader != null && (object = jsonParser.currentToken()) != null) {
            if (object.isScalarValue()) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
            if (object == JsonToken.START_OBJECT) {
                object = jsonParser.nextToken();
            }
            if (object == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(jsonParser.currentName(), jsonParser)) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
        }
        if ((object = this._deserializeIfNatural(jsonParser, deserializationContext)) != null) {
            return object;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ValueInstantiator$Base valueInstantiator$Base = new ValueInstantiator$Base(this._baseType);
        return deserializationContext.handleMissingInstantiator(((ResolvedType)this._baseType).getRawClass(), valueInstantiator$Base, jsonParser, "abstract types either need to be mapped to concrete types, have custom deserializer, or contain additional type information", new Object[0]);
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 6: {
                if (!this._acceptString) break;
                return jsonParser.getText();
            }
            case 7: {
                if (!this._acceptInt) break;
                return jsonParser.getIntValue();
            }
            case 8: {
                if (!this._acceptDouble) break;
                return jsonParser.getDoubleValue();
            }
            case 9: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case 10: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext object) throws IOException {
        Object object2 = this._objectIdReader.readObjectReference(jsonParser, (DeserializationContext)object);
        Object object3 = ((ReadableObjectId)(object = ((DeserializationContext)object).findObjectId(object2, this._objectIdReader.generator, this._objectIdReader.resolver))).resolve();
        if (object3 == null) {
            throw new UnresolvedForwardReference(jsonParser, "Could not resolve Object Id [" + object2 + "] -- unresolved forward-reference?", jsonParser.currentLocation(), (ReadableObjectId)object);
        }
        return object3;
    }
}

