/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject$Value;
import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties$Value;
import com.fasterxml.jackson.annotation.JsonIncludeProperties$Value;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.BeanProperty$Std;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory$ContainerDefaultMappings;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCandidate;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.EnumNamingStrategyFactory;
import com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.fasterxml.jackson.databind.introspect.PotentialCreators;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_SEQUENCE = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    private static final Class<?> CLASS_SERIALIZABLE = Serializable.class;
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class<?> clazz;
            Class<?> clazz2 = ((ResolvedType)javaType).getRawClass();
            if (clazz2 == (clazz = ((ResolvedType)javaType2).getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType object = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (object == null || ((ResolvedType)object).hasRawClass(clazz)) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object2 = deserializationConfig.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object2 != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object2);
        }
        if (valueInstantiator == null && (valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationConfig, beanDescription.getBeanClass())) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                ((DatabindContext)deserializationContext).reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", valueInstantiators.getClass().getName());
            }
        }
        if (valueInstantiator != null) {
            valueInstantiator = valueInstantiator.createContextual(deserializationContext, beanDescription);
        }
        return valueInstantiator;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        boolean bl2;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        PotentialCreators potentialCreators = beanDescription.getPotentialCreators();
        ConstructorDetector constructorDetector = ((MapperConfig)deserializationConfig).getConstructorDetector();
        VisibilityChecker<?> visibilityChecker = ((MapperConfig)deserializationConfig).getDefaultVisibilityChecker(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        CreatorCollector creatorCollector = new CreatorCollector(beanDescription, deserializationConfig);
        if (potentialCreators.hasPropertiesBased()) {
            PotentialCreator potentialCreator = potentialCreators.propertiesBased;
            if (potentialCreator.paramCount() == 0) {
                creatorCollector.setDefaultCreator(potentialCreator.creator());
            } else {
                this._addSelectedPropertiesBasedCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(deserializationConfig.getAnnotationIntrospector(), potentialCreator.creator(), potentialCreator.propertyDefs()));
            }
        }
        boolean bl3 = this._addExplicitDelegatingCreators(deserializationContext, beanDescription, creatorCollector, potentialCreators.getExplicitDelegating());
        if (((ResolvedType)beanDescription.getType()).isConcrete() && !(bl2 = beanDescription.isNonStaticInnerClass())) {
            boolean bl4;
            AnnotatedConstructor annotatedConstructor;
            if (!creatorCollector.hasDefaultCreator() && (annotatedConstructor = beanDescription.findDefaultConstructor()) != null) {
                creatorCollector.setDefaultCreator(annotatedConstructor);
            }
            if (bl4 = constructorDetector.shouldIntrospectorImplicitConstructors(beanDescription.getBeanClass())) {
                this._addImplicitDelegatingConstructors(deserializationContext, beanDescription, visibilityChecker, creatorCollector, potentialCreators.getImplicitDelegatingConstructors());
            }
        }
        if (!bl3) {
            this._addImplicitDelegatingFactories(deserializationContext, visibilityChecker, creatorCollector, potentialCreators.getImplicitDelegatingFactories());
        }
        return creatorCollector.constructValueInstantiator(deserializationContext);
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated object, Object object2) throws JsonMappingException {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof ValueInstantiator) {
            return (ValueInstantiator)object2;
        }
        if (!(object2 instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object2.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        if (ClassUtil.isBogusClass(object2 = (Class)object2)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom((Class<?>)object2)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + ((Class)object2).getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, (Annotated)object, (Class<?>)object2)) != null) {
            return object;
        }
        return (ValueInstantiator)ClassUtil.createInstance(object2, deserializationConfig.canOverrideAccessModifiers());
    }

    private boolean _addExplicitDelegatingCreators(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, List<PotentialCreator> object) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            PotentialCreator potentialCreator = (PotentialCreator)object.next();
            bl2 |= this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, potentialCreator.creator(), null));
        }
        return bl2;
    }

    private void _addImplicitDelegatingConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, CreatorCollector creatorCollector, List<PotentialCreator> object) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PotentialCreator)object.next();
            int n2 = ((PotentialCreator)object2).paramCount();
            object2 = ((PotentialCreator)object2).creator();
            if (n2 == 1) {
                this._handleSingleArgumentCreator(creatorCollector, (AnnotatedWithParams)object2, false, visibilityChecker.isCreatorVisible((AnnotatedMember)object2));
                continue;
            }
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter = ((AnnotatedWithParams)object2).getParameter(i2);
                Object object3 = annotationIntrospector.findInjectableValue(annotatedParameter);
                if (object3 != null) {
                    ++n3;
                    settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i2, annotatedParameter, (JacksonInject$Value)object3);
                    continue;
                }
                object3 = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter);
                if (object3 == null) continue;
                settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, UnwrappedPropertyHandler.creatorParamName(i2), i2, annotatedParameter, null);
            }
            if (n3 + 1 != n2) continue;
            creatorCollector.addDelegatingCreator((AnnotatedWithParams)object2, false, settableBeanPropertyArray, 0);
        }
    }

    private void _addImplicitDelegatingFactories(DeserializationContext object, VisibilityChecker<?> visibilityChecker, CreatorCollector creatorCollector, List<PotentialCreator> object2) throws JsonMappingException {
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (PotentialCreator)object.next();
            int n2 = ((PotentialCreator)object2).paramCount();
            object2 = ((PotentialCreator)object2).creator();
            if (n2 != 1) continue;
            this._handleSingleArgumentCreator(creatorCollector, (AnnotatedWithParams)object2, false, visibilityChecker.isCreatorVisible((AnnotatedMember)object2));
        }
    }

    private boolean _addExplicitDelegatingCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n2 = -1;
        int n3 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
        if (n3 == 0) {
            creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return true;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(i2);
            if (jacksonInject$Value != null) {
                settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i2, annotatedParameter, jacksonInject$Value);
                continue;
            }
            if (n2 < 0) {
                n2 = i2;
                continue;
            }
            ((DatabindContext)deserializationContext).reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", n2, i2, creatorCandidate);
        }
        if (n2 < 0) {
            ((DatabindContext)deserializationContext).reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", creatorCandidate);
        }
        if (n3 == 1) {
            return this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n2);
        return true;
    }

    private void _addSelectedPropertiesBasedCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(i2);
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            PropertyName propertyName = creatorCandidate.paramName(i2);
            boolean bl2 = Boolean.TRUE.equals(((DatabindContext)deserializationContext).getAnnotationIntrospector().hasAnySetter(annotatedParameter));
            if (bl2) {
                if (n3 >= 0) {
                    ((DatabindContext)deserializationContext).reportBadTypeDefinition(beanDescription, "More than one 'any-setter' specified (parameter #%d vs #%d)", n3, i2);
                } else {
                    n3 = i2;
                }
            } else if (propertyName == null) {
                NameTransformer nameTransformer = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter);
                if (nameTransformer != null) {
                    settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, UnwrappedPropertyHandler.creatorParamName(i2), i2, annotatedParameter, null);
                }
                if (propertyName == null && jacksonInject$Value == null) {
                    ((DatabindContext)deserializationContext).reportBadTypeDefinition(beanDescription, "Argument #%d of Creator %s has no property name (and is not Injectable): can not use as property-based Creator", i2, creatorCandidate);
                }
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, i2, annotatedParameter, jacksonInject$Value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    private boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl2, boolean bl3) {
        Class<?> clazz = annotatedWithParams.getRawParameterType(0);
        if (clazz == String.class || clazz == CLASS_CHAR_SEQUENCE) {
            if (bl2 || bl3) {
                creatorCollector.addStringCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl2 || bl3) {
                creatorCollector.addIntCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl2 || bl3) {
                creatorCollector.addLongCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl2 || bl3) {
                creatorCollector.addDoubleCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl2 || bl3) {
                creatorCollector.addBooleanCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == BigInteger.class && (bl2 || bl3)) {
            creatorCollector.addBigIntegerCreator(annotatedWithParams, bl2);
        }
        if (clazz == BigDecimal.class && (bl2 || bl3)) {
            creatorCollector.addBigDecimalCreator(annotatedWithParams, bl2);
        }
        if (bl2) {
            creatorCollector.addDelegatingCreator(annotatedWithParams, bl2, null, 0);
            return true;
        }
        return false;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription jsonDeserializer, PropertyName propertyName, int n2, AnnotatedParameter annotatedParameter, JacksonInject$Value jacksonInject$Value) throws JsonMappingException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Serializable serializable2 = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (serializable2 == null) {
            object3 = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            serializable2 = null;
        } else {
            serializable = serializable2.hasRequiredMarker(annotatedParameter);
            object2 = serializable2.findPropertyDescription(annotatedParameter);
            object = serializable2.findPropertyIndex(annotatedParameter);
            object3 = serializable2.findPropertyDefaultValue(annotatedParameter);
            object3 = PropertyMetadata.construct((Boolean)serializable, (String)object2, (Integer)object, (String)object3);
            serializable2 = serializable2.findWrapperName(annotatedParameter);
        }
        AnnotatedParameter annotatedParameter2 = annotatedParameter;
        serializable = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter2, ((Annotated)annotatedParameter2).getType());
        object2 = new BeanProperty$Std(propertyName, (JavaType)serializable, (PropertyName)serializable2, annotatedParameter, (PropertyMetadata)object3);
        object = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
        if (object == null) {
            object = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable);
        }
        object3 = this._getSetterInfo(deserializationConfig, (BeanProperty)object2, (PropertyMetadata)object3);
        object3 = CreatorProperty.construct(propertyName, (JavaType)serializable, ((BeanProperty$Std)object2).getWrapperName(), (TypeDeserializer)object, ((BeanDescription)((Object)jsonDeserializer)).getClassAnnotations(), annotatedParameter, n2, jacksonInject$Value, (PropertyMetadata)object3);
        jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)((JavaType)serializable).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)object3, (JavaType)serializable);
            object3 = ((SettableBeanProperty)object3).withValueDeserializer(jsonDeserializer);
        }
        return object3;
    }

    private PropertyMetadata _getSetterInfo(MapperConfig<?> mapperConfig, BeanProperty object, PropertyMetadata propertyMetadata) {
        Object object2 = mapperConfig.getAnnotationIntrospector();
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = object.getMember();
        if (annotatedMember != null) {
            if (object2 != null && (object2 = ((AnnotationIntrospector)object2).findSetterInfo(annotatedMember)) != null) {
                nulls = ((JsonSetter$Value)object2).nonDefaultValueNulls();
                nulls2 = ((JsonSetter$Value)object2).nonDefaultContentNulls();
            }
            if ((object = ((ConfigOverride)(object2 = mapperConfig.getConfigOverride(((ResolvedType)object.getType()).getRawClass()))).getSetterInfo()) != null) {
                if (nulls == null) {
                    nulls = ((JsonSetter$Value)object).nonDefaultValueNulls();
                }
                if (nulls2 == null) {
                    nulls2 = ((JsonSetter$Value)object).nonDefaultContentNulls();
                }
            }
        }
        object2 = mapperConfig.getDefaultSetterInfo();
        if (nulls == null) {
            nulls = ((JsonSetter$Value)object2).nonDefaultValueNulls();
        }
        if (nulls2 == null) {
            nulls2 = ((JsonSetter$Value)object2).nonDefaultContentNulls();
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext serializable, ArrayType arrayType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        serializable = ((DeserializationContext)serializable).getConfig();
        JavaType javaType = ((JavaType)arrayType).getContentType();
        JsonDeserializer object2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, (DeserializationConfig)serializable, beanDescription, typeDeserializer, object2)) == null) {
            if (object2 == null) {
                if (((ResolvedType)javaType).isPrimitive()) {
                    jsonDeserializer = PrimitiveArrayDeserializers.forType(((ResolvedType)javaType).getRawClass());
                } else if (((ResolvedType)javaType).hasRawClass(String.class)) {
                    jsonDeserializer = StringArrayDeserializer.instance;
                }
            }
            if (jsonDeserializer == null) {
                jsonDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, object2, typeDeserializer);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer((DeserializationConfig)serializable, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext serializable2, CollectionType object, BeanDescription beanDescription) throws JsonMappingException {
        Object object2;
        BeanDescription beanDescription2;
        JsonDeserializer jsonDeserializer;
        Object object3;
        JavaType javaType = ((JavaType)object3).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable2).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object3, deserializationConfig, beanDescription2, typeDeserializer, jsonDeserializer2)) == null) {
            object2 = ((ResolvedType)object3).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (jsonDeserializer == null) {
            if ((((ResolvedType)object3).isInterface() || ((ResolvedType)object3).isAbstract()) && (object2 = this._mapAbstractCollectionType((JavaType)object3, deserializationConfig)) != null) {
                object3 = object2;
                beanDescription2 = deserializationConfig.introspectForCreation((JavaType)object3);
            }
            if (jsonDeserializer == null) {
                object2 = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable2, beanDescription2);
                if (!((ValueInstantiator)object2).canCreateUsingDefault()) {
                    if (((ResolvedType)object3).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
                    }
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection((DeserializationContext)serializable2, (JavaType)object3);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                jsonDeserializer = ((ResolvedType)javaType).hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)object3, jsonDeserializer2, (ValueInstantiator)object2) : new CollectionDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object3, beanDescription2, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = BasicDeserializerFactory$ContainerDefaultMappings.findCollectionFallback(javaType);
        if (clazz != null) {
            return (CollectionType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext serializable, CollectionLikeType collectionLikeType, BeanDescription beanDescription) throws JsonMappingException {
        void var6_8;
        JsonDeserializer<?> jsonDeserializer = ((JavaType)collectionLikeType).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        serializable = ((DeserializationContext)serializable).getConfig();
        TypeDeserializer object2 = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (object2 == null) {
            TypeDeserializer typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, (DeserializationConfig)serializable, beanDescription, (TypeDeserializer)var6_8, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer((DeserializationConfig)serializable, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext serializable, MapType object, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable).getConfig();
        Object object2 = ((JavaType)object).getKeyType();
        Serializable serializable2 = ((JavaType)object).getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)((JavaType)serializable2).getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)((JavaType)object2).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)serializable2).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable2);
        }
        if ((serializable2 = this._findCustomMapDeserializer((MapType)object, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) == null) {
            Class<?> clazz = ((ResolvedType)object).getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz)) {
                void var11_13;
                if (clazz == EnumMap.class) {
                    Object object3 = null;
                } else {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                }
                if (!((JavaType)object2).isEnumImplType()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                serializable2 = new EnumMapDeserializer((JavaType)object, (ValueInstantiator)var11_13, null, jsonDeserializer, typeDeserializer, null);
            }
            if (serializable2 == null) {
                if (((ResolvedType)object).isInterface() || ((ResolvedType)object).isAbstract()) {
                    MapType mapType = this._mapAbstractMapType((JavaType)object, deserializationConfig);
                    if (mapType != null) {
                        object = mapType;
                        ((ResolvedType)object).getRawClass();
                        beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                    }
                } else {
                    serializable2 = JavaUtilCollectionsDeserializers.findForMap((DeserializationContext)serializable, (JavaType)object);
                    if (serializable2 != null) {
                        return serializable2;
                    }
                }
                if (serializable2 == null) {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                    serializable = new MapDeserializer((JavaType)object, valueInstantiator, keyDeserializer, jsonDeserializer, typeDeserializer);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIgnoreProperties$Value)object2).findIgnoredForDeserialization();
                    ((MapDeserializer)serializable).setIgnorableProperties((Set<String>)object2);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyInclusions(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIncludeProperties$Value)object2).getIncluded();
                    ((MapDeserializer)serializable).setIncludableProperties((Set<String>)object2);
                    serializable2 = serializable;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                serializable2 = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, (MapType)object, beanDescription, (JsonDeserializer<?>)((Object)serializable2));
            }
        }
        return serializable2;
    }

    protected MapType _mapAbstractMapType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = BasicDeserializerFactory$ContainerDefaultMappings.findMapFallback(javaType);
        if (clazz != null) {
            return (MapType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext serializable, MapLikeType mapLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer = ((JavaType)mapLikeType).getKeyType();
        JavaType javaType = ((JavaType)mapLikeType).getContentType();
        serializable = ((DeserializationContext)serializable).getConfig();
        JsonDeserializer object2 = (JsonDeserializer)javaType.getValueHandler();
        jsonDeserializer = (KeyDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, javaType);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, (DeserializationConfig)serializable, beanDescription, (KeyDeserializer)((Object)jsonDeserializer), typeDeserializer, object2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer((DeserializationConfig)serializable, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        Object object = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (object == null) {
            if (clazz == Enum.class) {
                return AbstractDeserializer.constructForNonPOJO(beanDescription);
            }
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] settableBeanPropertyArray = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(deserializationConfig, annotatedMethod)) continue;
                if (((AnnotatedWithParams)annotatedMethod).getParameterCount() == 0) {
                    object = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                object = annotatedMethod.getRawReturnType();
                if (!((Class)object).isAssignableFrom(clazz)) {
                    ((DatabindContext)deserializationContext).reportBadDefinition(javaType, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", ((Annotated)annotatedMethod).toString()));
                }
                object = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, settableBeanPropertyArray, this.constructEnumResolver(clazz, deserializationConfig, beanDescription));
                break;
            }
            if (object == null) {
                object = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription), deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS), this.constructEnumNamingStrategyResolver(deserializationConfig, beanDescription.getClassInfo()), EnumResolver.constructUsingToString(deserializationConfig, beanDescription.getClassInfo()));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, (JsonDeserializer<?>)object);
            }
        }
        return object;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig jsonDeserializer, JavaType type, BeanDescription beanDescription) throws JsonMappingException {
        jsonDeserializer = this._findCustomTreeNodeDeserializer((Class<? extends JsonNode>)(type = ((ResolvedType)((Object)type)).getRawClass()), (DeserializationConfig)((Object)jsonDeserializer), beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext object2, ReferenceType referenceType, BeanDescription beanDescription) throws JsonMappingException {
        void var3_8;
        void var2_7;
        JsonDeserializer<?> jsonDeserializer = var2_7.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)object2).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer((ReferenceType)var2_7, deserializationConfig, (BeanDescription)var3_8, typeDeserializer, jsonDeserializer2)) == null && var2_7.isTypeOrSubTypeOf(AtomicReference.class)) {
            void var1_4;
            Class<?> clazz = var2_7.getRawClass();
            if (clazz == AtomicReference.class) {
                Object var1_2 = null;
            } else {
                ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)object2, (BeanDescription)var3_8);
            }
            return new AtomicReferenceDeserializer((JavaType)var2_7, (ValueInstantiator)var1_4, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, (ReferenceType)var2_7, (BeanDescription)var3_8, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        Collection<NamedType> collection = deserializationConfig.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
        collection = ((BeanDescription)((Object)collection)).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector();
        if ((typeResolverBuilder = ((AnnotationIntrospector)((Object)typeResolverBuilder)).findTypeResolver(deserializationConfig, (AnnotatedClass)((Object)collection), javaType)) == null && (typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType)) == null) {
            return null;
        }
        collection = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedClass)((Object)collection));
        if (typeResolverBuilder.getDefaultImpl() == null && ((ResolvedType)javaType).isAbstract() && (javaType2 = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, javaType)) != null && !((ResolvedType)javaType2).hasRawClass(((ResolvedType)javaType).getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.withDefaultImpl(((ResolvedType)javaType2).getRawClass());
        }
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType);
        KeyDeserializer keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (keyDeserializer == null && this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers object;
            Iterator<Object> iterator = this._factoryConfig.keyDeserializers().iterator();
            while (iterator.hasNext() && (keyDeserializer = (object = iterator.next()).findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            keyDeserializer = ((ResolvedType)javaType).isEnumType() ? this._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
        }
        if (keyDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                keyDeserializer = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType serializable) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((ResolvedType)((Object)serializable)).getRawClass();
        BeanDescription beanDescription = deserializationConfig.introspect((JavaType)serializable);
        JsonDeserializer<?> jsonDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, serializable, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, serializable, jsonDeserializer2);
        }
        jsonDeserializer = this.constructEnumResolver(clazz, deserializationConfig, beanDescription);
        jsonDeserializer2 = this.constructEnumNamingStrategyResolver(deserializationConfig, beanDescription.getClassInfo());
        serializable = EnumResolver.constructUsingToString(deserializationConfig, beanDescription.getClassInfo());
        EnumResolver enumResolver = EnumResolver.constructUsingIndex(deserializationConfig, beanDescription.getClassInfo());
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            Class<?> clazz2;
            if (!this._hasCreatorAnnotation(deserializationConfig, annotatedMethod)) continue;
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (n2 == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (((AnnotatedWithParams)annotatedMethod).getRawParameterType(0) != String.class) continue;
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), ((DatabindContext)deserializationContext).isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod, (EnumResolver)((Object)jsonDeserializer2), (EnumResolver)serializable, enumResolver);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), (EnumResolver)((Object)jsonDeserializer2), (EnumResolver)serializable, enumResolver);
    }

    @Override
    public boolean hasExplicitDeserializerFor(DeserializationConfig object, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        object = clazz.getName();
        if (((String)object).startsWith("java.")) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return NumberDeserializers.find(clazz, (String)object) != null;
            }
            if (JdkDeserializers.hasDeserializerFor(clazz) || clazz == CLASS_STRING || clazz == Boolean.class || clazz == EnumMap.class || clazz == AtomicReference.class) {
                return true;
            }
            return DateDeserializers.hasDeserializerFor(clazz);
        }
        if (((String)object).startsWith("com.fasterxml.")) {
            return JsonNode.class.isAssignableFrom(clazz) || clazz == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(clazz);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) throws JsonMappingException {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        if ((object2 = ((AnnotationIntrospector)object2).findPropertyTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType)) == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        try {
            return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) throws JsonMappingException {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        object2 = ((AnnotationIntrospector)object2).findPropertyContentTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType);
        javaType = javaType.getContentType();
        if (object2 == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext object, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Object object2 = ((ResolvedType)javaType).getRawClass();
        if (object2 == CLASS_OBJECT || object2 == CLASS_SERIALIZABLE) {
            JavaType javaType2;
            DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType2 = this._findRemappedType(deserializationConfig, List.class);
                object2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                object2 = null;
                javaType2 = null;
            }
            return new UntypedObjectDeserializer(javaType2, (JavaType)object2);
        }
        if (object2 == CLASS_STRING || object2 == CLASS_CHAR_SEQUENCE) {
            return StringDeserializer.instance;
        }
        if (object2 == CLASS_ITERABLE) {
            TypeFactory typeFactory = ((DatabindContext)object).getTypeFactory();
            Object object3 = typeFactory.findTypeParameters(javaType, CLASS_ITERABLE);
            object2 = object3 == null || ((JavaType[])object3).length != 1 ? TypeFactory.unknownType() : object3[0];
            object3 = typeFactory.constructCollectionType(Collection.class, (JavaType)object2);
            return ((DeserializerFactory)this).createCollectionDeserializer((DeserializationContext)object, (CollectionType)object3, beanDescription);
        }
        if (object2 == CLASS_MAP_ENTRY) {
            JavaType javaType3 = javaType.containedTypeOrUnknown(0);
            Object object4 = javaType.containedTypeOrUnknown(1);
            object2 = (TypeDeserializer)((JavaType)object4).getTypeHandler();
            if (object2 == null) {
                object2 = ((DeserializerFactory)this).findTypeDeserializer(((DeserializationContext)object).getConfig(), (JavaType)object4);
            }
            object4 = (JsonDeserializer)((JavaType)object4).getValueHandler();
            object = (KeyDeserializer)javaType3.getValueHandler();
            return new MapEntryDeserializer(javaType, (KeyDeserializer)object, (JsonDeserializer<Object>)object4, (TypeDeserializer)object2);
        }
        String string = ((Class)object2).getName();
        if (((Class)object2).isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(object2, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(object2, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (object2 == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer((DeserializationContext)object, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find((DeserializationContext)object, object2, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig serializable, Class<?> clazz) throws JsonMappingException {
        DeserializationConfig deserializationConfig = serializable;
        serializable = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        if (serializable == null || ((ResolvedType)((Object)serializable)).hasRawClass(clazz)) {
            return null;
        }
        return serializable;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> object = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (((ResolvedType)javaType).isMapLikeType() && (object = javaType.getKeyType()) != null) {
            object = annotationIntrospector.findKeyDeserializer(annotatedMember);
            if ((object = deserializationContext.keyDeserializerInstance(annotatedMember, object)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
                javaType.getKeyType();
            }
        }
        if (javaType.hasContentType()) {
            object = annotationIntrospector.findContentDeserializer(annotatedMember);
            if ((object = deserializationContext.deserializerInstance(annotatedMember, object)) != null) {
                javaType = javaType.withContentValueHandler(object);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> serializable, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        serializable = beanDescription.findJsonValueAccessor();
        if (serializable != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(((AnnotatedMember)serializable).getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(deserializationConfig, beanDescription.getClassInfo(), (AnnotatedMember)serializable);
        }
        return EnumResolver.constructFor(deserializationConfig, beanDescription.getClassInfo());
    }

    protected EnumResolver constructEnumNamingStrategyResolver(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        Object object = deserializationConfig.getAnnotationIntrospector().findEnumNamingStrategy(deserializationConfig, annotatedClass);
        if ((object = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(object, deserializationConfig.canOverrideAccessModifiers(), deserializationConfig.getEnumNamingStrategy())) == null) {
            return null;
        }
        return EnumResolver.constructUsingEnumNamingStrategy(deserializationConfig, annotatedClass, (EnumNamingStrategy)object);
    }

    @Deprecated
    protected EnumResolver constructEnumNamingStrategyResolver(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedClass object) {
        object = deserializationConfig.getAnnotationIntrospector().findEnumNamingStrategy(deserializationConfig, (AnnotatedClass)object);
        if ((object = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(object, deserializationConfig.canOverrideAccessModifiers(), deserializationConfig.getEnumNamingStrategy())) == null) {
            return null;
        }
        return EnumResolver.constructUsingEnumNamingStrategy(deserializationConfig, clazz, (EnumNamingStrategy)object);
    }

    protected boolean _hasCreatorAnnotation(MapperConfig<?> object, Annotated annotated) {
        AnnotationIntrospector annotationIntrospector = object.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            return (object = annotationIntrospector.findCreatorAnnotation((MapperConfig<?>)object, annotated)) != null && object != JsonCreator$Mode.DISABLED;
        }
        return false;
    }
}

