/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer$1;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayBuilderDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;

    public BuilderBasedDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, JavaType javaType, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, boolean bl3) {
        this(beanDeserializerBuilder, beanDescription, javaType, beanPropertyMap, map, set, bl2, null, bl3);
    }

    public BuilderBasedDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, JavaType javaType, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, Set<String> set2, boolean bl3) {
        super(beanDeserializerBuilder, beanDescription, beanPropertyMap, map, set, bl2, set2, bl3);
        this._targetType = javaType;
        this._buildMethod = beanDeserializerBuilder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Cannot use Object Id with Builder-based deserialization (type " + beanDescription.getType() + ")");
        }
    }

    @Deprecated
    public BuilderBasedDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, boolean bl3) {
        BeanDescription beanDescription2 = beanDescription;
        this(beanDeserializerBuilder, beanDescription2, beanDescription2.getType(), beanPropertyMap, map, set, bl2, bl3);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer) {
        BuilderBasedDeserializer builderBasedDeserializer2 = builderBasedDeserializer;
        this(builderBasedDeserializer2, builderBasedDeserializer2._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, boolean bl2) {
        super((BeanDeserializerBase)builderBasedDeserializer, bl2);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)builderBasedDeserializer, nameTransformer);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, ObjectIdReader objectIdReader) {
        super((BeanDeserializerBase)builderBasedDeserializer, objectIdReader);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, Set<String> set) {
        this(builderBasedDeserializer, set, builderBasedDeserializer._includableProps);
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, Set<String> set, Set<String> set2) {
        super(builderBasedDeserializer, set, set2);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, BeanPropertyMap beanPropertyMap) {
        super((BeanDeserializerBase)builderBasedDeserializer, beanPropertyMap);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return new BuilderBasedDeserializer(this, nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BuilderBasedDeserializer(this, objectIdReader);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> set, Set<String> set2) {
        return new BuilderBasedDeserializer(this, set, set2);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean bl2) {
        return new BuilderBasedDeserializer(this, bl2);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BuilderBasedDeserializer(this, beanPropertyMap);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] settableBeanPropertyArray = this._beanProperties.getPropertiesInInsertionOrder();
        BuilderBasedDeserializer builderBasedDeserializer = this;
        return new BeanAsArrayBuilderDeserializer(builderBasedDeserializer, builderBasedDeserializer._targetType, settableBeanPropertyArray, this._buildMethod);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    protected Object finishBuild(DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._buildMethod == null) {
            return object;
        }
        try {
            return this._buildMethod.getMember().invoke(object, null);
        }
        catch (Exception exception) {
            return this.wrapInstantiationProblem(exception, deserializationContext);
        }
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.isExpectedStartObjectToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (this._vanillaProcessing) {
                return this.finishBuild(deserializationContext, this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken));
            }
            return this.finishBuild(deserializationContext, ((BeanDeserializerBase)this).deserializeFromObject(jsonParser, deserializationContext));
        }
        switch (jsonParser.currentTokenId()) {
            case 6: {
                return this.finishBuild(deserializationContext, this.deserializeFromString(jsonParser, deserializationContext));
            }
            case 7: {
                return this.finishBuild(deserializationContext, this.deserializeFromNumber(jsonParser, deserializationContext));
            }
            case 8: {
                return this.finishBuild(deserializationContext, this.deserializeFromDouble(jsonParser, deserializationContext));
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 9: 
            case 10: {
                return this.finishBuild(deserializationContext, this.deserializeFromBoolean(jsonParser, deserializationContext));
            }
            case 3: {
                return this._deserializeFromArray(jsonParser, deserializationContext);
            }
            case 2: 
            case 5: {
                return this.finishBuild(deserializationContext, ((BeanDeserializerBase)this).deserializeFromObject(jsonParser, deserializationContext));
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public Object deserialize(JsonParser object, DeserializationContext deserializationContext, Object clazz) throws IOException {
        object = this._targetType;
        Class<?> clazz2 = ((JsonDeserializer)this).handledType();
        if (clazz2.isAssignableFrom(clazz = clazz.getClass())) {
            return ((DatabindContext)deserializationContext).reportBadDefinition((JavaType)object, String.format("Deserialization of %s by passing existing Builder (%s) instance not supported", object, clazz2.getName()));
        }
        return ((DatabindContext)deserializationContext).reportBadDefinition((JavaType)object, String.format("Deserialization of %s by passing existing instance (of %s) not supported", object, clazz.getName()));
    }

    private final Object vanillaDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken object) throws IOException {
        object = this._valueInstantiator.createUsingDefault(deserializationContext);
        while (jsonParser.currentToken() == JsonToken.FIELD_NAME) {
            String string = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, string, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            }
            jsonParser.nextToken();
        }
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object2 = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object2);
        }
        if (this._needViewProcesing && (object = ((DatabindContext)deserializationContext).getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object2, (Class<?>)object);
        }
        while (jsonParser.currentToken() == JsonToken.FIELD_NAME) {
            object = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object);
            if (settableBeanProperty != null) {
                try {
                    object2 = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object2);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object2, (String)object, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object2, (String)object);
            }
            jsonParser.nextToken();
        }
        return object2;
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        Class<?> clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        JsonGenerator jsonGenerator = null;
        Object object = jsonParser.currentToken();
        while (object == JsonToken.FIELD_NAME) {
            block22: {
                object = jsonParser.currentName();
                jsonParser.nextToken();
                Object object2 = propertyBasedCreator.findCreatorProperty((String)object);
                if (!propertyValueBuffer.readIdProperty((String)object) || object2 != null) {
                    if (object2 != null) {
                        if (clazz != null && !((SettableBeanProperty)object2).visibleInView(clazz)) {
                            jsonParser.skipChildren();
                        } else {
                            SettableBeanProperty settableBeanProperty = object2;
                            if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                                jsonParser.nextToken();
                                try {
                                    object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                                }
                                catch (Exception exception) {
                                    this.wrapAndThrow(exception, ((ResolvedType)this._beanType).getRawClass(), (String)object, deserializationContext);
                                    break block22;
                                }
                                if (object2.getClass() != ((ResolvedType)this._beanType).getRawClass()) {
                                    return this.handlePolymorphic(jsonParser, deserializationContext, jsonParser.streamReadConstraints(), object2, (TokenBuffer)jsonGenerator);
                                }
                                if (jsonGenerator != null) {
                                    object2 = this.handleUnknownProperties(deserializationContext, object2, (TokenBuffer)jsonGenerator);
                                }
                                return this._deserialize(jsonParser, deserializationContext, object2);
                            }
                        }
                    } else {
                        object2 = this._beanProperties.find((String)object);
                        if (object2 != null) {
                            SettableBeanProperty settableBeanProperty = object2;
                            propertyValueBuffer.bufferProperty(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext));
                        } else if (IgnorePropertiesUtil.shouldIgnore(object, this._ignorableProps, this._includableProps)) {
                            this.handleIgnoredProperty(jsonParser, deserializationContext, ((JsonDeserializer)this).handledType(), (String)object);
                        } else if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                        } else {
                            if (jsonGenerator == null) {
                                jsonGenerator = deserializationContext.bufferForInputBuffering(jsonParser);
                            }
                            jsonGenerator.writeFieldName((String)object);
                            jsonGenerator.copyCurrentStructure(jsonParser);
                        }
                    }
                }
            }
            object = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            object = this.wrapInstantiationProblem(exception, deserializationContext);
        }
        if (jsonGenerator != null) {
            if (((Object)object).getClass() != ((ResolvedType)this._beanType).getRawClass()) {
                return this.handlePolymorphic(null, deserializationContext, jsonParser.streamReadConstraints(), object, (TokenBuffer)jsonGenerator);
            }
            return this.handleUnknownProperties(deserializationContext, object, (TokenBuffer)jsonGenerator);
        }
        return object;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Object object2;
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            if (jsonParser.hasToken(JsonToken.START_OBJECT)) {
                jsonParser.nextToken();
            }
            TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
            ((JsonGenerator)tokenBuffer).writeStartObject();
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        if (this._needViewProcesing && (object2 = ((DatabindContext)deserializationContext).getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object, (Class<?>)object2);
        }
        object2 = jsonParser.currentToken();
        if (object2 == JsonToken.START_OBJECT) {
            object2 = jsonParser.nextToken();
        }
        while (object2 == JsonToken.FIELD_NAME) {
            object2 = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object2);
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, (String)object2, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, (String)object2);
            }
            object2 = jsonParser.nextToken();
        }
        return object;
    }

    @Override
    protected Object _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object = this._arrayDelegateDeserializer;
        if (object != null || (object = this._delegateDeserializer) != null) {
            object = this._valueInstantiator.createUsingArrayDelegate(deserializationContext, object.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return this.finishBuild(deserializationContext, object);
        }
        object = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl2 = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (bl2 || object != CoercionAction.Fail) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                switch (BuilderBasedDeserializer$1.$SwitchMap$com$fasterxml$jackson$databind$cfg$CoercionAction[((Enum)object).ordinal()]) {
                    case 1: {
                        return ((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                    case 2: 
                    case 3: {
                        return this.getNullValue(deserializationContext);
                    }
                }
                return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
            }
            if (bl2) {
                object = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return object;
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    protected final Object deserializeWithView(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Class<?> clazz) throws IOException {
        Object object2 = jsonParser.currentToken();
        while (object2 == JsonToken.FIELD_NAME) {
            object2 = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object2);
            if (settableBeanProperty != null) {
                if (!settableBeanProperty.visibleInView(clazz)) {
                    if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES)) {
                        deserializationContext.reportInputMismatch(((JsonDeserializer)this).handledType(), String.format("Input mismatch while deserializing %s. Property '%s' is not part of current active view '%s' (disable 'DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES' to allow)", ClassUtil.nameOf(((JsonDeserializer)this).handledType()), settableBeanProperty.getName(), clazz.getName()), new Object[0]);
                    }
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, (String)object2, deserializationContext);
                    }
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, (String)object2);
            }
            object2 = jsonParser.nextToken();
        }
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Class<?> clazz;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        ((JsonGenerator)tokenBuffer).writeStartObject();
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz2 = clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        while (jsonParser.currentToken() == JsonToken.FIELD_NAME) {
            String string = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else {
                ((JsonGenerator)tokenBuffer).writeFieldName(string);
                ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            }
            jsonParser.nextToken();
        }
        ((JsonGenerator)tokenBuffer).writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        ((JsonGenerator)tokenBuffer).writeStartObject();
        Object object = null;
        object = jsonParser.currentToken();
        while (object == JsonToken.FIELD_NAME) {
            block15: {
                String string = jsonParser.currentName();
                jsonParser.nextToken();
                object = propertyBasedCreator.findCreatorProperty(string);
                if (!propertyValueBuffer.readIdProperty(string) || object != null) {
                    if (object != null) {
                        Object object2 = object;
                        if (propertyValueBuffer.assignParameter((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext))) {
                            jsonParser.nextToken();
                            try {
                                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(exception, ((ResolvedType)this._beanType).getRawClass(), string, deserializationContext);
                                break block15;
                            }
                            if (object.getClass() != ((ResolvedType)this._beanType).getRawClass()) {
                                return this.handlePolymorphic(jsonParser, deserializationContext, jsonParser.streamReadConstraints(), object, tokenBuffer);
                            }
                            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
                        }
                    } else {
                        object = this._beanProperties.find(string);
                        if (object != null) {
                            Object object3 = object;
                            propertyValueBuffer.bufferProperty((SettableBeanProperty)object3, ((SettableBeanProperty)object3).deserialize(jsonParser, deserializationContext));
                        } else if (IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps)) {
                            this.handleIgnoredProperty(jsonParser, deserializationContext, ((JsonDeserializer)this).handledType(), string);
                        } else {
                            ((JsonGenerator)tokenBuffer).writeFieldName(string);
                            ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
                            if (this._anySetter != null) {
                                propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                            }
                        }
                    }
                }
            }
            object = jsonParser.nextToken();
        }
        ((JsonGenerator)tokenBuffer).writeEndObject();
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            return this.wrapInstantiationProblem(exception, deserializationContext);
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException {
        Class<?> clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        Object object2 = jsonParser.currentToken();
        while (object2 == JsonToken.FIELD_NAME) {
            object2 = jsonParser.currentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object2);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, (String)object2, deserializationContext);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(object2, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, (String)object2);
            } else {
                ((JsonGenerator)tokenBuffer).writeFieldName((String)object2);
                ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, (String)object2);
                }
            }
            object2 = jsonParser.nextToken();
        }
        ((JsonGenerator)tokenBuffer).writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jsonParser, deserializationContext);
        }
        return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Class<?> clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        JsonToken jsonToken = jsonParser.currentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.currentName();
            jsonToken = jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (jsonToken.isScalarValue()) {
                    externalTypeHandler.handleTypePropertyValue(jsonParser, deserializationContext, string, object);
                }
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, object)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        object = this._targetType;
        return ((DatabindContext)deserializationContext).reportBadDefinition((JavaType)object, String.format("Deserialization (of %s) with Builder, External type id, @JsonCreator not yet implemented", object));
    }
}

