/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.DataFormatReaders$AccessorForReader;
import com.fasterxml.jackson.databind.deser.DataFormatReaders$Match;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class DataFormatReaders {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final ObjectReader[] _readers;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatReaders(ObjectReader ... objectReaderArray) {
        this(objectReaderArray, MatchStrength.SOLID_MATCH, MatchStrength.WEAK_MATCH, 64);
    }

    public DataFormatReaders(Collection<ObjectReader> collection) {
        Collection<ObjectReader> collection2 = collection;
        this(collection2.toArray(new ObjectReader[collection2.size()]));
    }

    private DataFormatReaders(ObjectReader[] objectReaderArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n2) {
        this._readers = objectReaderArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n2;
    }

    public DataFormatReaders withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._optimalMatch) {
            return this;
        }
        return new DataFormatReaders(this._readers, matchStrength, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._minimalMatch) {
            return this;
        }
        return new DataFormatReaders(this._readers, this._optimalMatch, matchStrength, this._maxInputLookahead);
    }

    public DataFormatReaders with(ObjectReader[] objectReaderArray) {
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withMaxInputLookahead(int n2) {
        if (n2 == this._maxInputLookahead) {
            return this;
        }
        return new DataFormatReaders(this._readers, this._optimalMatch, this._minimalMatch, n2);
    }

    public DataFormatReaders with(DeserializationConfig deserializationConfig) {
        int n2 = this._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = this._readers[i2].with(deserializationConfig);
        }
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders withType(JavaType javaType) {
        int n2 = this._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = this._readers[i2].forType(javaType);
        }
        return new DataFormatReaders(objectReaderArray, this._optimalMatch, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatReaders$Match findFormat(InputStream inputStream) throws IOException {
        return this._findFormat(new DataFormatReaders$AccessorForReader(inputStream, new byte[this._maxInputLookahead]));
    }

    public DataFormatReaders$Match findFormat(byte[] byArray) throws IOException {
        return this._findFormat(new DataFormatReaders$AccessorForReader(byArray));
    }

    public DataFormatReaders$Match findFormat(byte[] byArray, int n2, int n3) throws IOException {
        return this._findFormat(new DataFormatReaders$AccessorForReader(byArray, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this._readers.length;
        if (n2 > 0) {
            stringBuilder.append(((TokenStreamFactory)((ObjectCodec)this._readers[0]).getFactory()).getFormatName());
            for (int i2 = 1; i2 < n2; ++i2) {
                stringBuilder.append(", ");
                stringBuilder.append(((TokenStreamFactory)((ObjectCodec)this._readers[i2]).getFactory()).getFormatName());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private DataFormatReaders$Match _findFormat(DataFormatReaders$AccessorForReader dataFormatReaders$AccessorForReader) throws IOException {
        ObjectReader objectReader = null;
        Enum enum_ = null;
        ObjectReader[] objectReaderArray = this._readers;
        int n2 = this._readers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectReader objectReader2 = objectReaderArray[i2];
            dataFormatReaders$AccessorForReader.reset();
            MatchStrength matchStrength = ((ObjectCodec)objectReader2).getFactory().hasFormat(dataFormatReaders$AccessorForReader);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || objectReader != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            objectReader = objectReader2;
            enum_ = matchStrength;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) break;
        }
        return dataFormatReaders$AccessorForReader.createMatcher(objectReader, (MatchStrength)enum_);
    }
}

