/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_BIG_INTEGER = 4;
    protected static final int C_DOUBLE = 5;
    protected static final int C_BIG_DECIMAL = 6;
    protected static final int C_BOOLEAN = 7;
    protected static final int C_DELEGATE = 8;
    protected static final int C_PROPS = 9;
    protected static final int C_ARRAY_DELEGATE = 10;
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-big-integer", "from-double", "from-big-decimal", "from-boolean", "delegate", "property-based", "array-delegate"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[11];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationContext serializable) throws JsonMappingException {
        Serializable serializable2 = serializable.getConfig();
        JavaType javaType = this._computeDelegateType((DeserializationContext)serializable, this._creators[8], this._delegateArgs);
        serializable = this._computeDelegateType((DeserializationContext)serializable, this._creators[10], this._arrayDelegateArgs);
        JavaType javaType2 = this._beanDesc.getType();
        serializable2 = new StdValueInstantiator((DeserializationConfig)serializable2, javaType2);
        ((StdValueInstantiator)serializable2).configureFromObjectSettings(this._creators[0], this._creators[8], javaType, this._delegateArgs, this._creators[9], this._propertyBasedArgs);
        ((StdValueInstantiator)serializable2).configureFromArraySettings(this._creators[10], (JavaType)serializable, this._arrayDelegateArgs);
        ((StdValueInstantiator)serializable2).configureFromStringCreator(this._creators[1]);
        ((StdValueInstantiator)serializable2).configureFromIntCreator(this._creators[2]);
        ((StdValueInstantiator)serializable2).configureFromLongCreator(this._creators[3]);
        ((StdValueInstantiator)serializable2).configureFromBigIntegerCreator(this._creators[4]);
        ((StdValueInstantiator)serializable2).configureFromDoubleCreator(this._creators[5]);
        ((StdValueInstantiator)serializable2).configureFromBigDecimalCreator(this._creators[6]);
        ((StdValueInstantiator)serializable2).configureFromBooleanCreator(this._creators[7]);
        return serializable2;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 1, bl2);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 2, bl2);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 3, bl2);
    }

    public void addBigIntegerCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 4, bl2);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 5, bl2);
    }

    public void addBigDecimalCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 6, bl2);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 7, bl2);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray, int n2) {
        if (((ResolvedType)annotatedWithParams.getParameterType(n2)).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 10, bl2)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
                return;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 8, bl2)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams serializable, boolean n2, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup((AnnotatedWithParams)serializable, 9, n2 != 0)) {
            if (settableBeanPropertyArray.length > 1) {
                serializable = new HashMap();
                int n3 = settableBeanPropertyArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Integer n4;
                    String string = settableBeanPropertyArray[n2].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[n2].getInjectableValueId() != null || (n4 = ((HashMap)serializable).put(string, n2)) == null) continue;
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d) for type %s ", string, n4, n2, ClassUtil.nameOf(this._beanDesc.getBeanClass())));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[8] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[9] != null;
    }

    private JavaType _computeDelegateType(DeserializationContext object, AnnotatedWithParams annotatedMember, SettableBeanProperty[] object2) throws JsonMappingException {
        if (!this._hasNonDefaultCreator || annotatedMember == null) {
            return null;
        }
        int n2 = 0;
        if (object2 != null) {
            int n3 = ((SettableBeanProperty[])object2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (object2[i2] != null) continue;
                n2 = i2;
                break;
            }
        }
        DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
        JavaType javaType = annotatedMember.getParameterType(n2);
        object2 = deserializationConfig.getAnnotationIntrospector();
        if (object2 != null) {
            Object object3 = ((AnnotationIntrospector)object2).findDeserializer(annotatedMember = annotatedMember.getParameter(n2));
            if (object3 != null) {
                object = ((DeserializationContext)object).deserializerInstance(annotatedMember, object3);
                javaType = javaType.withValueHandler(object);
            } else {
                javaType = ((AnnotationIntrospector)object2).refineDeserializationType(deserializationConfig, annotatedMember, javaType);
            }
        }
        return javaType;
    }

    private <T extends AnnotatedMember> T _fixAccess(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean verifyNonDup(AnnotatedWithParams var1_1, int var2_2, boolean var3_3) {
        block10: {
            block11: {
                var4_4 = 1 << var2_2;
                this._hasNonDefaultCreator = true;
                var5_5 = this._creators[var2_2];
                if (var5_5 == null) break block10;
                if ((this._explicitCreators & var4_4) != 0) {
                    if (!var3_3) {
                        return false;
                    }
                    v0 = true;
                } else {
                    v0 = var6_6 = var3_3 == false;
                }
                if (!v0 || var5_5.getClass() != var1_1.getClass()) break block10;
                var6_7 = var5_5.getRawParameterType(0);
                if (var6_7 != (var7_8 = var1_1.getRawParameterType(0))) break block11;
                if (this._isEnumValueOf(var1_1)) {
                    return false;
                }
                if (this._isEnumValueOf(var5_5)) break block10;
                ** GOTO lbl-1000
            }
            if (var7_8.isAssignableFrom(var6_7)) {
                return false;
            }
            if (!var6_7.isAssignableFrom(var7_8)) {
                ** if (var6_7.isPrimitive() == var7_8.isPrimitive()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (var6_7.isPrimitive()) {
                        return false;
                    } else {
                        ** GOTO lbl25
                    }
lbl25:
                    // 2 sources

                    ** GOTO lbl28
                }
            }
            break block10;
lbl-1000:
            // 2 sources

            {
                this._reportDuplicateCreator(var2_2, var3_3, var5_5, var1_1);
            }
        }
        if (var3_3) {
            this._explicitCreators |= var4_4;
        }
        this._creators[var2_2] = this._fixAccess(var1_1);
        return true;
    }

    protected void _reportDuplicateCreator(int n2, boolean bl2, AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2) {
        throw new IllegalArgumentException(String.format("Conflicting %s creators: already had %s creator %s, encountered another: %s", TYPE_DESCS[n2], bl2 ? "explicitly marked" : "implicitly discovered", annotatedWithParams, annotatedWithParams2));
    }

    protected boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return ClassUtil.isEnumType(annotatedWithParams.getDeclaringClass()) && "valueOf".equals(annotatedWithParams.getName());
    }
}

