/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JavaUtilCollectionsDeserializers {
    private static final int TYPE_SINGLETON_SET = 1;
    private static final int TYPE_SINGLETON_LIST = 2;
    private static final int TYPE_SINGLETON_MAP = 3;
    private static final int TYPE_UNMODIFIABLE_SET = 4;
    private static final int TYPE_UNMODIFIABLE_LIST = 5;
    private static final int TYPE_UNMODIFIABLE_MAP = 6;
    private static final int TYPE_SYNC_SET = 7;
    private static final int TYPE_SYNC_COLLECTION = 8;
    private static final int TYPE_SYNC_LIST = 9;
    private static final int TYPE_SYNC_MAP = 10;
    public static final int TYPE_AS_LIST = 11;
    private static final String PREFIX_JAVA_UTIL_COLLECTIONS = "java.util.Collections$";
    private static final String PREFIX_JAVA_UTIL_ARRAYS = "java.util.Arrays$";
    private static final String PREFIX_JAVA_UTIL_IMMUTABLE_COLL = "java.util.ImmutableCollections$";

    public static JsonDeserializer<?> findForCollection(DeserializationContext object, JavaType javaType) throws JsonMappingException {
        object = ((ResolvedType)javaType).getRawClass().getName();
        if (!((String)object).startsWith("java.util.")) {
            return null;
        }
        String string = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName((String)object);
        if (string != null) {
            object = null;
            String string2 = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string);
            if (string2 != null) {
                if (string2.endsWith("Set")) {
                    object = JavaUtilCollectionsDeserializers.converter(4, javaType, Set.class);
                } else if (string2.endsWith("List")) {
                    object = JavaUtilCollectionsDeserializers.converter(5, javaType, List.class);
                }
            } else {
                string2 = JavaUtilCollectionsDeserializers._findSingletonTypeName(string);
                if (string2 != null) {
                    if (string2.endsWith("Set")) {
                        object = JavaUtilCollectionsDeserializers.converter(1, javaType, Set.class);
                    } else if (string2.endsWith("List")) {
                        object = JavaUtilCollectionsDeserializers.converter(2, javaType, List.class);
                    }
                } else {
                    string2 = JavaUtilCollectionsDeserializers._findSyncTypeName(string);
                    if (string2 != null) {
                        if (string2.endsWith("Set")) {
                            object = JavaUtilCollectionsDeserializers.converter(7, javaType, Set.class);
                        } else if (string2.endsWith("List")) {
                            object = JavaUtilCollectionsDeserializers.converter(9, javaType, List.class);
                        } else if (string2.endsWith("Collection")) {
                            object = JavaUtilCollectionsDeserializers.converter(8, javaType, Collection.class);
                        }
                    }
                }
            }
            if (object == null) {
                return null;
            }
            return new StdDelegatingDeserializer(object);
        }
        string = JavaUtilCollectionsDeserializers._findUtilArrayTypeName((String)object);
        if (string != null) {
            if (string.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(11, javaType, List.class));
            }
            return null;
        }
        string = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName((String)object);
        if (string != null) {
            if (string.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(11, javaType, List.class));
            }
            if (string.contains("Set")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(4, javaType, Set.class));
            }
            return null;
        }
        return null;
    }

    public static JsonDeserializer<?> findForMap(DeserializationContext object, JavaType javaType) throws JsonMappingException {
        object = ((ResolvedType)javaType).getRawClass().getName();
        JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter = null;
        String string = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName((String)object);
        if (string != null) {
            object = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string);
            if (object != null) {
                if (((String)object).contains("Map")) {
                    javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
                }
            } else {
                object = JavaUtilCollectionsDeserializers._findSingletonTypeName(string);
                if (object != null) {
                    if (((String)object).contains("Map")) {
                        javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(3, javaType, Map.class);
                    }
                } else {
                    object = JavaUtilCollectionsDeserializers._findSyncTypeName(string);
                    if (object != null && ((String)object).contains("Map")) {
                        javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(10, javaType, Map.class);
                    }
                }
            }
        } else {
            string = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName((String)object);
            if (string != null && string.contains("Map")) {
                javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
            }
        }
        if (javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter == null) {
            return null;
        }
        return new StdDelegatingDeserializer(javaUtilCollectionsDeserializers$JavaUtilCollectionsConverter);
    }

    static JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter converter(int n2, JavaType javaType, Class<?> clazz) {
        return new JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter(n2, javaType.findSuperType(clazz));
    }

    private static String _findUtilArrayTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_ARRAYS)) {
            return string.substring(17);
        }
        return null;
    }

    private static String _findUtilCollectionsTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_COLLECTIONS)) {
            return string.substring(22);
        }
        return null;
    }

    private static String _findUtilCollectionsImmutableTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_IMMUTABLE_COLL)) {
            return string.substring(31);
        }
        return null;
    }

    private static String _findSingletonTypeName(String string) {
        if (string.startsWith("Singleton")) {
            return string.substring(9);
        }
        return null;
    }

    private static String _findSyncTypeName(String string) {
        if (string.startsWith("Synchronized")) {
            return string.substring(12);
        }
        return null;
    }

    private static String _findUnmodifiableTypeName(String string) {
        if (string.startsWith("Unmodifiable")) {
            return string.substring(12);
        }
        return null;
    }
}

