/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId$Referring;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer$CollectionReferringAccumulator;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = -1L;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, jsonDeserializer, typeDeserializer, valueInstantiator, null, null, null);
    }

    protected CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator, JsonDeserializer<Object> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        super(javaType, nullValueProvider, bl2);
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer2;
    }

    protected CollectionDeserializer(CollectionDeserializer collectionDeserializer) {
        super(collectionDeserializer);
        this._valueDeserializer = collectionDeserializer._valueDeserializer;
        this._valueTypeDeserializer = collectionDeserializer._valueTypeDeserializer;
        this._valueInstantiator = collectionDeserializer._valueInstantiator;
        this._delegateDeserializer = collectionDeserializer._delegateDeserializer;
    }

    protected CollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        return new CollectionDeserializer(this._containerType, jsonDeserializer2, typeDeserializer, this._valueInstantiator, jsonDeserializer, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    public CollectionDeserializer createContextual(DeserializationContext object, BeanProperty beanProperty) throws JsonMappingException {
        Serializable serializable;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null) {
            if (this._valueInstantiator.canCreateUsingDelegate()) {
                serializable = this._valueInstantiator.getDelegateType(((DeserializationContext)object).getConfig());
                if (serializable == null) {
                    ((DatabindContext)object).reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                jsonDeserializer = this.findDeserializer((DeserializationContext)object, (JavaType)serializable, beanProperty);
            } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
                serializable = this._valueInstantiator.getArrayDelegateType(((DeserializationContext)object).getConfig());
                if (serializable == null) {
                    ((DatabindContext)object).reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                jsonDeserializer = this.findDeserializer((DeserializationContext)object, (JavaType)serializable, beanProperty);
            }
        }
        serializable = this.findFormatFeature((DeserializationContext)object, beanProperty, Collection.class, JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> jsonDeserializer2 = this._valueDeserializer;
        jsonDeserializer2 = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer2);
        Object object2 = this._containerType.getContentType();
        jsonDeserializer2 = jsonDeserializer2 == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)object2, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer2, beanProperty, (JavaType)object2);
        object2 = this._valueTypeDeserializer;
        if (object2 != null) {
            object2 = ((TypeDeserializer)object2).forProperty(beanProperty);
        }
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer2);
        if (!Objects.equals(serializable, this._unwrapSingle) || object != this._nullProvider || jsonDeserializer != this._delegateDeserializer || jsonDeserializer2 != this._valueDeserializer || object2 != this._valueTypeDeserializer) {
            return this.withResolved(jsonDeserializer, jsonDeserializer2, (TypeDeserializer)object2, (NullValueProvider)object, (Boolean)serializable);
        }
        return this;
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    protected Collection<Object> createDefaultInstance(DeserializationContext deserializationContext) throws IOException {
        return (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, collection);
        }
        return this.handleNonArray(jsonParser, deserializationContext, collection);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    protected Collection<Object> _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext, String object) throws IOException {
        Class<?> clazz = ((JsonDeserializer)this).handledType();
        if (object.isEmpty()) {
            object = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), clazz, CoercionInputShape.EmptyString);
            if (object != null && object != CoercionAction.Fail) {
                return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "empty String (\"\")");
            }
        } else if (CollectionDeserializer._isBlank(object) && (object = deserializationContext.findCoercionFromBlankString(((JsonDeserializer)this).logicalType(), clazz, CoercionAction.Fail)) != CoercionAction.Fail) {
            return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "blank String (all whitespace)");
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    protected Collection<Object> _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        Object object;
        jsonParser.assignCurrentValue(collection);
        if (this._valueDeserializer.getObjectIdReader() != null) {
            return this._deserializeWithObjectId(jsonParser, deserializationContext, collection);
        }
        while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            try {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = null;
                } else {
                    object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                }
                if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null) {
                    this._tryToAddNull(jsonParser, deserializationContext, collection);
                    continue;
                }
                collection.add(object);
            }
            catch (Exception exception) {
                boolean bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!bl2) {
                    ClassUtil.throwIfRTE(exception);
                }
                Collection<Object> collection2 = collection;
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection2, collection2.size());
            }
        }
        return collection;
    }

    protected final Collection<Object> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        Object object;
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            return (Collection)deserializationContext.handleUnexpectedToken(this._containerType, jsonParser);
        }
        try {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                if (this._skipNullValues) {
                    return collection;
                }
                object = null;
            } else {
                object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
            }
            if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null) {
                this._tryToAddNull(jsonParser, deserializationContext, collection);
                return collection;
            }
        }
        catch (Exception exception) {
            boolean bl3 = deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
            if (!bl3) {
                ClassUtil.throwIfRTE(exception);
            }
            throw JsonMappingException.wrapWithPath((Throwable)exception, Object.class, collection.size());
        }
        collection.add(object);
        return collection;
    }

    protected Collection<Object> _deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        jsonParser.assignCurrentValue(collection);
        CollectionDeserializer$CollectionReferringAccumulator collectionDeserializer$CollectionReferringAccumulator = new CollectionDeserializer$CollectionReferringAccumulator(((ResolvedType)this._containerType.getContentType()).getRawClass(), collection);
        while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            try {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = null;
                } else {
                    object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                }
                if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                collectionDeserializer$CollectionReferringAccumulator.add(object);
            }
            catch (UnresolvedForwardReference unresolvedForwardReference) {
                ReadableObjectId$Referring readableObjectId$Referring = collectionDeserializer$CollectionReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference);
                unresolvedForwardReference.getRoid().appendReferring(readableObjectId$Referring);
            }
            catch (Exception exception) {
                boolean bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!bl2) {
                    ClassUtil.throwIfRTE(exception);
                }
                Collection<Object> collection2 = collection;
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection2, collection2.size());
            }
        }
        return collection;
    }

    protected Object _deserializeNoNullChecks(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._valueTypeDeserializer == null) {
            return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        }
        return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
    }

    protected void _tryToAddNull(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<?> collection) throws IOException {
        if (this._skipNullValues) {
            return;
        }
        try {
            collection.add(null);
            return;
        }
        catch (NullPointerException nullPointerException) {
            deserializationContext.handleUnexpectedToken(this._valueType, JsonToken.VALUE_NULL, jsonParser, "`java.util.Collection` of type %s does not accept `null` values", ClassUtil.getTypeDescription(this.getValueType(deserializationContext)));
            return;
        }
    }
}

