/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer$Std;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer$StringBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer$StringBuilderDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class, StringBuffer.class};
    }

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static FromStringDeserializer<?> findDeserializer(Class<?> clazz) {
        int n2;
        if (clazz == File.class) {
            n2 = 1;
        } else if (clazz == URL.class) {
            n2 = 2;
        } else if (clazz == URI.class) {
            n2 = 3;
        } else if (clazz == Class.class) {
            n2 = 4;
        } else if (clazz == JavaType.class) {
            n2 = 5;
        } else if (clazz == Currency.class) {
            n2 = 6;
        } else if (clazz == Pattern.class) {
            n2 = 7;
        } else if (clazz == Locale.class) {
            n2 = 8;
        } else if (clazz == Charset.class) {
            n2 = 9;
        } else if (clazz == TimeZone.class) {
            n2 = 10;
        } else if (clazz == InetAddress.class) {
            n2 = 11;
        } else if (clazz == InetSocketAddress.class) {
            n2 = 12;
        } else {
            if (clazz == StringBuilder.class) {
                return new FromStringDeserializer$StringBuilderDeserializer();
            }
            if (clazz == StringBuffer.class) {
                return new FromStringDeserializer$StringBufferDeserializer();
            }
            return null;
        }
        return new FromStringDeserializer$Std(clazz, n2);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        Object object2;
        String string = ((JsonParser)object).getValueAsString();
        if (string == null) {
            object2 = ((JsonParser)object).currentToken();
            if (object2 != JsonToken.START_OBJECT) {
                return (T)this._deserializeFromOther((JsonParser)object, deserializationContext, (JsonToken)((Object)object2));
            }
            FromStringDeserializer fromStringDeserializer = this;
            string = deserializationContext.extractScalarFromObject((JsonParser)object, fromStringDeserializer, fromStringDeserializer._valueClass);
        }
        if (string.isEmpty()) {
            return (T)this._deserializeFromEmptyString(deserializationContext);
        }
        if (this._shouldTrim()) {
            object2 = string;
            if ((string = string.trim()) != object2 && string.isEmpty()) {
                return (T)this._deserializeFromEmptyString(deserializationContext);
            }
        }
        try {
            return this._deserialize(string, deserializationContext);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            object = exception;
            object2 = exception;
            object = "not a valid textual representation";
            String string2 = ((Throwable)object2).getMessage();
            if (string2 != null) {
                object = (String)object + ", problem: " + string2;
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, (String)object).withCause((Throwable)object2);
        }
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException;

    protected boolean _shouldTrim() {
        return true;
    }

    protected Object _deserializeFromOther(JsonParser object, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        if (jsonToken == JsonToken.START_ARRAY) {
            return this._deserializeFromArray((JsonParser)object, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if ((object = ((JsonParser)object).getEmbeddedObject()) == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
    }

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", object.getClass().getName(), this._valueClass.getName());
        return null;
    }

    @Deprecated
    protected final T _deserializeFromEmptyString() throws IOException {
        return null;
    }

    protected Object _deserializeFromEmptyString(DeserializationContext deserializationContext) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), this._valueClass, CoercionInputShape.EmptyString);
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
        }
        if (coercionAction == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        return this._deserializeFromEmptyStringDefault(deserializationContext);
    }

    protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) throws IOException {
        return this.getNullValue(deserializationContext);
    }
}

