/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers$PrimitiveOrWrapperDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;

@JacksonStdImpl
public class NumberDeserializers$DoubleDeserializer
extends NumberDeserializers$PrimitiveOrWrapperDeserializer<Double> {
    private static final long serialVersionUID = 1L;
    static final NumberDeserializers$DoubleDeserializer primitiveInstance = new NumberDeserializers$DoubleDeserializer(Double.TYPE, 0.0);
    static final NumberDeserializers$DoubleDeserializer wrapperInstance = new NumberDeserializers$DoubleDeserializer(Double.class, null);

    public NumberDeserializers$DoubleDeserializer(Class<Double> clazz, Double d2) {
        super(clazz, LogicalType.Float, d2, 0.0);
    }

    @Override
    public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return jsonParser.getDoubleValue();
        }
        if (this._primitive) {
            return this._parseDoublePrimitive(jsonParser, deserializationContext);
        }
        return this._parseDouble(jsonParser, deserializationContext);
    }

    @Override
    public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return jsonParser.getDoubleValue();
        }
        if (this._primitive) {
            return this._parseDoublePrimitive(jsonParser, deserializationContext);
        }
        return this._parseDouble(jsonParser, deserializationContext);
    }

    protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 11: {
                return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Double)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
            }
            case 8: {
                return jsonParser.getDoubleValue();
            }
            case 1: {
                NumberDeserializers$DoubleDeserializer numberDeserializers$DoubleDeserializer = this;
                string = deserializationContext.extractScalarFromObject(jsonParser, numberDeserializers$DoubleDeserializer, numberDeserializers$DoubleDeserializer._valueClass);
                break;
            }
            case 3: {
                return (Double)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Double)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        Object object = this._checkDoubleSpecialValue(string);
        if (object != null) {
            return object;
        }
        object = this._checkFromStringCoercion(deserializationContext, string);
        if (object == CoercionAction.AsNull) {
            return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (object == CoercionAction.AsEmpty) {
            return (Double)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, string = string.trim())) {
            return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (NumberInput.looksLikeValidNumber(string)) {
            jsonParser.streamReadConstraints().validateFPLength(string.length());
            try {
                return NumberDeserializers$DoubleDeserializer._parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Double` value", new Object[0]);
    }
}

