/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers$PrimitiveOrWrapperDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;

@JacksonStdImpl
public class NumberDeserializers$FloatDeserializer
extends NumberDeserializers$PrimitiveOrWrapperDeserializer<Float> {
    private static final long serialVersionUID = 1L;
    static final NumberDeserializers$FloatDeserializer primitiveInstance = new NumberDeserializers$FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
    static final NumberDeserializers$FloatDeserializer wrapperInstance = new NumberDeserializers$FloatDeserializer(Float.class, null);

    public NumberDeserializers$FloatDeserializer(Class<Float> clazz, Float f2) {
        super(clazz, LogicalType.Float, f2, Float.valueOf(0.0f));
    }

    @Override
    public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        if (this._primitive) {
            return Float.valueOf(this._parseFloatPrimitive(jsonParser, deserializationContext));
        }
        return this._parseFloat(jsonParser, deserializationContext);
    }

    protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 11: {
                return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Float)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
            }
            case 8: {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            case 1: {
                NumberDeserializers$FloatDeserializer numberDeserializers$FloatDeserializer = this;
                string = deserializationContext.extractScalarFromObject(jsonParser, numberDeserializers$FloatDeserializer, numberDeserializers$FloatDeserializer._valueClass);
                break;
            }
            case 3: {
                return (Float)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (Float)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        Object object = this._checkFloatSpecialValue(string);
        if (object != null) {
            return object;
        }
        object = this._checkFromStringCoercion(deserializationContext, string);
        if (object == CoercionAction.AsNull) {
            return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (object == CoercionAction.AsEmpty) {
            return (Float)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, string = string.trim())) {
            return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (NumberInput.looksLikeValidNumber(string)) {
            jsonParser.streamReadConstraints().validateFPLength(string.length());
            try {
                return Float.valueOf(NumberInput.parseFloat(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Float` value", new Object[0]);
    }
}

