/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders$DoubleBuilder;
import java.io.IOException;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$DoubleDeser
extends PrimitiveArrayDeserializers<double[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$DoubleDeser() {
        super(double[].class);
    }

    protected PrimitiveArrayDeserializers$DoubleDeser(PrimitiveArrayDeserializers$DoubleDeser primitiveArrayDeserializers$DoubleDeser, NullValueProvider nullValueProvider, Boolean bl2) {
        super(primitiveArrayDeserializers$DoubleDeser, nullValueProvider, bl2);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
        return new PrimitiveArrayDeserializers$DoubleDeser(this, nullValueProvider, bl2);
    }

    @Override
    protected final double[] _constructEmpty() {
        return new double[0];
    }

    @Override
    public final double[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (double[])this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$DoubleBuilder arrayBuilders$DoubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
        double[] dArray = (double[])arrayBuilders$DoubleBuilder.resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                    this._nuller.getNullValue(deserializationContext);
                    continue;
                }
                double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                if (n2 >= dArray.length) {
                    dArray = arrayBuilders$DoubleBuilder.appendCompletedChunk(dArray, n2);
                    n2 = 0;
                }
                dArray[n2++] = d2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)dArray, arrayBuilders$DoubleBuilder.bufferedSize() + n2);
        }
        return arrayBuilders$DoubleBuilder.completeAndClearBuffer(dArray, n2);
    }

    @Override
    protected final double[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return new double[]{this._parseDoublePrimitive(jsonParser, deserializationContext)};
    }

    @Override
    protected final double[] _concat(double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        int n3 = dArray2.length;
        dArray = Arrays.copyOf(dArray, n2 + n3);
        System.arraycopy(dArray2, 0, dArray, n2, n3);
        return dArray;
    }
}

