/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$BooleanDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$ByteDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$CharDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$DoubleDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$FloatDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$IntDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$LongDeser;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$ShortDeser;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidNullException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Objects;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _unwrapSingle;
    private transient Object _emptyValue;
    protected final NullValueProvider _nuller;

    protected PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
        this._unwrapSingle = null;
        this._nuller = null;
    }

    protected PrimitiveArrayDeserializers(PrimitiveArrayDeserializers<?> primitiveArrayDeserializers, NullValueProvider nullValueProvider, Boolean bl2) {
        super(primitiveArrayDeserializers._valueClass);
        this._unwrapSingle = bl2;
        this._nuller = nullValueProvider;
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return PrimitiveArrayDeserializers$IntDeser.instance;
        }
        if (clazz == Long.TYPE) {
            return PrimitiveArrayDeserializers$LongDeser.instance;
        }
        if (clazz == Byte.TYPE) {
            return new PrimitiveArrayDeserializers$ByteDeser();
        }
        if (clazz == Short.TYPE) {
            return new PrimitiveArrayDeserializers$ShortDeser();
        }
        if (clazz == Float.TYPE) {
            return new PrimitiveArrayDeserializers$FloatDeser();
        }
        if (clazz == Double.TYPE) {
            return new PrimitiveArrayDeserializers$DoubleDeser();
        }
        if (clazz == Boolean.TYPE) {
            return new PrimitiveArrayDeserializers$BooleanDeser();
        }
        if (clazz == Character.TYPE) {
            return new PrimitiveArrayDeserializers$CharDeser();
        }
        throw new IllegalArgumentException("Unknown primitive array element type: " + clazz);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this._valueClass, JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = null;
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            nullValueProvider = NullsConstantProvider.skipper();
        } else if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                nullValueProvider = NullsFailProvider.constructForRootValue(deserializationContext.constructType(this._valueClass.getComponentType()));
            } else {
                BeanProperty beanProperty2 = beanProperty;
                nullValueProvider = NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType().getContentType());
            }
        }
        if (Objects.equals(bl2, this._unwrapSingle) && nullValueProvider == this._nuller) {
            return this;
        }
        return this.withResolved(nullValueProvider, bl2);
    }

    protected abstract T _concat(T var1, T var2);

    protected abstract T handleSingleElementUnwrapped(JsonParser var1, DeserializationContext var2) throws IOException;

    protected abstract PrimitiveArrayDeserializers<?> withResolved(NullValueProvider var1, Boolean var2);

    protected abstract T _constructEmpty();

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext object) throws JsonMappingException {
        object = this._emptyValue;
        if (object == null) {
            this._emptyValue = object = this._constructEmpty();
        }
        return object;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) throws IOException {
        jsonParser = this.deserialize(jsonParser, deserializationContext);
        if (t2 == null) {
            return (T)jsonParser;
        }
        int n2 = Array.getLength(t2);
        if (n2 == 0) {
            return (T)jsonParser;
        }
        return (T)this._concat(t2, jsonParser);
    }

    protected T handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (jsonParser.hasToken(JsonToken.VALUE_STRING) && (!bl2 || PrimitiveArrayDeserializers._isBlank(jsonParser.getText()))) {
            return this._deserializeFromString(jsonParser, deserializationContext);
        }
        if (bl2) {
            return this.handleSingleElementUnwrapped(jsonParser, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected void _failOnNull(DeserializationContext deserializationContext) throws IOException {
        throw InvalidNullException.from(deserializationContext, null, deserializationContext.constructType(this._valueClass));
    }
}

