/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    private static final String[] NO_STRINGS = new String[0];
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    private final JsonDeserializer<String> _elementDeserializer;
    private final NullValueProvider _nullProvider;
    private final Boolean _unwrapSingle;
    private final boolean _skipNullValues;

    public StringArrayDeserializer() {
        this(null, null, null);
    }

    private StringArrayDeserializer(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        super(String[].class);
        this._elementDeserializer = jsonDeserializer;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl2;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public final Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public final AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public final Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return NO_STRINGS;
    }

    @Override
    public final JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        Serializable serializable = ((DeserializationContext)object).constructType(String.class);
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)serializable, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)serializable);
        serializable = this.findFormatFeature((DeserializationContext)object, beanProperty, String[].class, JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer);
        if (jsonDeserializer != null && this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        if (this._elementDeserializer == jsonDeserializer && Objects.equals(this._unwrapSingle, serializable) && this._nullProvider == object) {
            return this;
        }
        return new StringArrayDeserializer(jsonDeserializer, (NullValueProvider)object, (Boolean)serializable);
    }

    @Override
    public final String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, null);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        try {
            while (true) {
                if ((object = jsonParser.nextTextValue()) == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken != JsonToken.END_ARRAY) {
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) {
                                continue;
                            }
                        } else {
                            object = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                        }
                        if (object == null && (object = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                    }
                    break;
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    private String[] _deserializeCustom(JsonParser jsonParser, DeserializationContext deserializationContext, String[] objectArray) throws IOException {
        Object object;
        int n2;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        if (objectArray == null) {
            n2 = 0;
            objectArray = objectBuffer.resetAndStart();
        } else {
            n2 = objectArray.length;
            objectArray = objectBuffer.resetAndStart(objectArray, n2);
        }
        JsonDeserializer<String> jsonDeserializer = this._elementDeserializer;
        try {
            while (true) {
                if (jsonParser.nextTextValue() == null) {
                    object = jsonParser.currentToken();
                    if (object == JsonToken.END_ARRAY) break;
                    if (object == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        object = null;
                    } else {
                        object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (object == null && (object = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, String.class, n2);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public final String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, String[] object) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            String[] stringArray = this.handleNonArray(jsonParser, deserializationContext);
            if (stringArray == null) {
                return object;
            }
            int n2 = ((String[])object).length;
            String[] stringArray2 = new String[n2 + stringArray.length];
            System.arraycopy(object, 0, stringArray2, 0, n2);
            System.arraycopy(stringArray, 0, stringArray2, n2, stringArray.length);
            return stringArray2;
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, (String[])object);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = ((String[])object).length;
        Object[] objectArray = objectBuffer.resetAndStart((Object[])object, n3);
        try {
            while (true) {
                if ((object = jsonParser.nextTextValue()) == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken != JsonToken.END_ARRAY) {
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) {
                                return NO_STRINGS;
                            }
                        } else {
                            object = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                        }
                        if (object == null && (object = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                    }
                    break;
                }
                if (n3 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n3 = 0;
                }
                objectArray[n3++] = object;
            }
        }
        catch (Exception exception) {
            object = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n3);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n3, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    private final String[] handleNonArray(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl2) {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
                object = (String)this._nullProvider.getNullValue(deserializationContext);
            } else {
                if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                    Object object2 = ((JsonParser)object).getText();
                    if (object2.isEmpty()) {
                        object2 = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.EmptyString);
                        if (object2 != CoercionAction.Fail) {
                            return (String[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "empty String (\"\")");
                        }
                    } else if (StringArrayDeserializer._isBlank(object2) && (object2 = deserializationContext.findCoercionFromBlankString(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                        return (String[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "blank String (all whitespace)");
                    }
                }
                object = this._parseString((JsonParser)object, deserializationContext, this._nullProvider);
            }
            return new String[]{object};
        }
        if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
            return (String[])this._deserializeFromString((JsonParser)object, deserializationContext);
        }
        return (String[])deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
    }
}

