/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private final JsonDeserializer<String> _valueDeserializer;
    private final ValueInstantiator _valueInstantiator;
    private final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, ValueInstantiator valueInstantiator) {
        JsonDeserializer<?> jsonDeserializer2 = jsonDeserializer;
        this(javaType, valueInstantiator, null, jsonDeserializer2, jsonDeserializer2, null);
    }

    private StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        super(javaType, nullValueProvider, bl2);
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
    }

    private StringCollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        if (Objects.equals(this._unwrapSingle, bl2) && this._nullProvider == nullValueProvider && this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._containerType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2, nullValueProvider, bl2);
    }

    @Override
    public final boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public final JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) throws JsonMappingException {
        Serializable serializable;
        Object object2;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null) {
            object2 = this._valueInstantiator.getArrayDelegateCreator();
            if (object2 != null) {
                serializable = this._valueInstantiator.getArrayDelegateType(((DeserializationContext)object).getConfig());
                jsonDeserializer = this.findDeserializer((DeserializationContext)object, (JavaType)serializable, beanProperty);
            } else if (this._valueInstantiator.getDelegateCreator() != null) {
                serializable = this._valueInstantiator.getDelegateType(((DeserializationContext)object).getConfig());
                jsonDeserializer = this.findDeserializer((DeserializationContext)object, (JavaType)serializable, beanProperty);
            }
        }
        object2 = this._valueDeserializer;
        serializable = this._containerType.getContentType();
        if (object2 == null) {
            if ((object2 = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, (JsonDeserializer<?>)object2)) == null) {
                object2 = ((DeserializationContext)object).findContextualValueDeserializer((JavaType)serializable, beanProperty);
            }
        } else {
            object2 = ((DeserializationContext)object).handleSecondaryContextualization((JsonDeserializer<?>)object2, beanProperty, (JavaType)serializable);
        }
        serializable = this.findFormatFeature((DeserializationContext)object, beanProperty, Collection.class, JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, (JsonDeserializer<?>)object2);
        if (this.isDefaultDeserializer((JsonDeserializer<?>)object2)) {
            object2 = null;
        }
        return this.withResolved(jsonDeserializer, (JsonDeserializer<?>)object2, (NullValueProvider)object, (Boolean)serializable);
    }

    @Override
    public final JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    @Override
    public final ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public final Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext)));
        }
        Collection<String> collection = StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDefault(deserializationContext));
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    @Override
    public final Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        try {
            while (true) {
                String string;
                if ((string = jsonParser.nextTextValue()) != null) {
                    collection.add(string);
                    continue;
                }
                JsonToken jsonToken = jsonParser.currentToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) {
                            continue;
                        }
                    } else {
                        string = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                    }
                    if (string == null && (string = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                    collection.add(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            Collection<String> collection2 = collection;
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection2, collection2.size());
        }
        return collection;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection, JsonDeserializer<String> jsonDeserializer) throws IOException {
        try {
            while (true) {
                Object object;
                if (jsonParser.nextTextValue() == null) {
                    object = jsonParser.currentToken();
                    if (object == JsonToken.END_ARRAY) break;
                    if (object == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        object = null;
                    } else {
                        object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (object == null && (object = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                collection.add((String)object);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            Collection<String> collection2 = collection;
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection2, collection2.size());
        }
        return collection;
    }

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection<String> handleNonArray(JsonParser object, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                return (Collection)this._deserializeFromString((JsonParser)object, deserializationContext);
            }
            return StringCollectionDeserializer.castToCollection(deserializationContext.handleUnexpectedToken(this._containerType, (JsonParser)object));
        }
        JsonDeserializer<String> jsonDeserializer = this._valueDeserializer;
        Object object2 = ((JsonParser)object).currentToken();
        if (object2 == JsonToken.VALUE_NULL) {
            if (this._skipNullValues) {
                return collection;
            }
            object = null;
        } else {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                object2 = ((JsonParser)object).getText();
                if (((String)object2).isEmpty()) {
                    object2 = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.EmptyString);
                    if (object2 != CoercionAction.Fail) {
                        return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "empty String (\"\")"));
                    }
                } else if (StringCollectionDeserializer._isBlank((String)object2) && (object2 = deserializationContext.findCoercionFromBlankString(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                    return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "blank String (all whitespace)"));
                }
            }
            try {
                object = jsonDeserializer == null ? this._parseString((JsonParser)object, deserializationContext, this._nullProvider) : jsonDeserializer.deserialize((JsonParser)object, deserializationContext);
            }
            catch (Exception exception) {
                object2 = exception;
                Collection<String> collection2 = collection;
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection2, collection2.size());
            }
        }
        if (object == null && (object = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) {
            return collection;
        }
        collection.add((String)object);
        return collection;
    }

    private static Collection<String> castToCollection(Object object) {
        if (object != null) {
            if (object.getClass() == ArrayList.class) {
                return (ArrayList)object;
            }
            if (object.getClass() == HashSet.class) {
                return (HashSet)object;
            }
        }
        return (Collection)object;
    }
}

