/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberTypeFP;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializerNR$Scope;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
final class UntypedObjectDeserializerNR
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    protected static final Object[] NO_OBJECTS = new Object[0];
    public static final UntypedObjectDeserializerNR std = new UntypedObjectDeserializerNR();
    protected final boolean _nonMerging;

    public UntypedObjectDeserializerNR() {
        this(false);
    }

    protected UntypedObjectDeserializerNR(boolean bl2) {
        super(Object.class);
        this._nonMerging = bl2;
    }

    public static UntypedObjectDeserializerNR instance(boolean bl2) {
        if (bl2) {
            return new UntypedObjectDeserializerNR(true);
        }
        return std;
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public final Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        if (this._nonMerging) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return this._deserializeNR(jsonParser, deserializationContext2, UntypedObjectDeserializerNR$Scope.rootObjectScope(deserializationContext2.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)));
            }
            case 2: {
                return UntypedObjectDeserializerNR$Scope.emptyMap();
            }
            case 5: {
                return this._deserializeObjectAtName(jsonParser, deserializationContext);
            }
            case 3: {
                return this._deserializeNR(jsonParser, deserializationContext, UntypedObjectDeserializerNR$Scope.rootArrayScope());
            }
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                return this._deserializeFP(jsonParser, deserializationContext);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
        }
        return this._deserializeAnyScalar(jsonParser, deserializationContext, jsonParser.currentTokenId());
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._nonMerging) {
            return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            case 2: 
            case 4: {
                return object;
            }
            case 1: {
                Object object2 = jsonParser.nextToken();
                if (object2 == JsonToken.END_OBJECT) {
                    return object;
                }
            }
            case 5: {
                if (!(object instanceof Map)) break;
                Object object2 = (Map)object;
                String string = jsonParser.currentName();
                do {
                    jsonParser.nextToken();
                    Object v2 = object2.get(string);
                    Object object3 = v2 != null ? ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext, v2) : ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                    if (object3 == v2) continue;
                    object2.put(string, object3);
                } while ((string = jsonParser.nextFieldName()) != null);
                return object;
            }
            case 3: {
                Object object4 = jsonParser.nextToken();
                if (object4 == JsonToken.END_ARRAY) {
                    return object;
                }
                if (!(object instanceof Collection)) break;
                object4 = (Collection)object;
                do {
                    object4.add(((JsonDeserializer)this).deserialize(jsonParser, deserializationContext));
                } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
        }
        return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
    }

    private Object _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        UntypedObjectDeserializerNR$Scope untypedObjectDeserializerNR$Scope = UntypedObjectDeserializerNR$Scope.rootObjectScope(deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES));
        String string = jsonParser.currentName();
        while (string != null) {
            Object object = jsonParser.nextToken();
            if (object == null) {
                object = JsonToken.NOT_AVAILABLE;
            }
            switch (object.id()) {
                case 1: {
                    object = this._deserializeNR(jsonParser, deserializationContext, untypedObjectDeserializerNR$Scope.childObject());
                    break;
                }
                case 2: {
                    return untypedObjectDeserializerNR$Scope.finishRootObject();
                }
                case 3: {
                    object = this._deserializeNR(jsonParser, deserializationContext, untypedObjectDeserializerNR$Scope.childArray());
                    break;
                }
                default: {
                    object = this._deserializeAnyScalar(jsonParser, deserializationContext, object.id());
                }
            }
            untypedObjectDeserializerNR$Scope.putValue(string, object);
            string = jsonParser.nextFieldName();
        }
        return untypedObjectDeserializerNR$Scope.finishRootObject();
    }

    private Object _deserializeNR(JsonParser jsonParser, DeserializationContext deserializationContext, UntypedObjectDeserializerNR$Scope untypedObjectDeserializerNR$Scope) throws IOException {
        boolean bl2 = deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS);
        boolean bl3 = deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
        UntypedObjectDeserializerNR$Scope untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope;
        block23: while (true) {
            Object object;
            Object object2;
            block30: {
                if (!untypedObjectDeserializerNR$Scope2.isObject()) break block30;
                object2 = jsonParser.nextFieldName();
                while (object2 != null) {
                    block31: {
                        object = jsonParser.nextToken();
                        if (object == null) {
                            object = JsonToken.NOT_AVAILABLE;
                        }
                        switch (object.id()) {
                            case 1: {
                                untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.childObject((String)object2);
                                break block31;
                            }
                            case 3: {
                                untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.childArray((String)object2);
                                continue block23;
                            }
                            case 6: {
                                object = jsonParser.getText();
                                break;
                            }
                            case 7: {
                                object = bl2 ? this._coerceIntegral(jsonParser, deserializationContext) : jsonParser.getNumberValue();
                                break;
                            }
                            case 8: {
                                object = this._deserializeFP(jsonParser, deserializationContext);
                                break;
                            }
                            case 9: {
                                object = Boolean.TRUE;
                                break;
                            }
                            case 10: {
                                object = Boolean.FALSE;
                                break;
                            }
                            case 11: {
                                object = null;
                                break;
                            }
                            case 12: {
                                object = jsonParser.getEmbeddedObject();
                                break;
                            }
                            default: {
                                return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                            }
                        }
                        untypedObjectDeserializerNR$Scope2.putValue((String)object2, object);
                    }
                    object2 = jsonParser.nextFieldName();
                }
                if (untypedObjectDeserializerNR$Scope2 == untypedObjectDeserializerNR$Scope) {
                    return untypedObjectDeserializerNR$Scope2.finishRootObject();
                }
                untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.finishBranchObject();
                continue;
            }
            while (true) {
                if ((object2 = jsonParser.nextToken()) == null) {
                    object2 = JsonToken.NOT_AVAILABLE;
                }
                switch (((JsonToken)((Object)object2)).id()) {
                    case 1: {
                        untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.childObject();
                        continue block23;
                    }
                    case 3: {
                        untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.childArray();
                        continue block23;
                    }
                    case 4: {
                        if (untypedObjectDeserializerNR$Scope2 == untypedObjectDeserializerNR$Scope) {
                            return untypedObjectDeserializerNR$Scope2.finishRootArray(bl3);
                        }
                        untypedObjectDeserializerNR$Scope2 = untypedObjectDeserializerNR$Scope2.finishBranchArray(bl3);
                        continue block23;
                    }
                    case 6: {
                        object = jsonParser.getText();
                        break;
                    }
                    case 7: {
                        object = bl2 ? this._coerceIntegral(jsonParser, deserializationContext) : jsonParser.getNumberValue();
                        break;
                    }
                    case 8: {
                        object = this._deserializeFP(jsonParser, deserializationContext);
                        break;
                    }
                    case 9: {
                        object = Boolean.TRUE;
                        break;
                    }
                    case 10: {
                        object = Boolean.FALSE;
                        break;
                    }
                    case 11: {
                        object = null;
                        break;
                    }
                    case 12: {
                        object = jsonParser.getEmbeddedObject();
                        break;
                    }
                    default: {
                        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                    }
                }
                untypedObjectDeserializerNR$Scope2.addValue(object);
            }
            break;
        }
    }

    private Object _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) throws IOException {
        switch (n2) {
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                return this._deserializeFP(jsonParser, deserializationContext);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    protected final Object _deserializeFP(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonParser$NumberTypeFP jsonParser$NumberTypeFP = jsonParser.getNumberTypeFP();
        if (jsonParser$NumberTypeFP == JsonParser$NumberTypeFP.BIG_DECIMAL) {
            return jsonParser.getDecimalValue();
        }
        if (!jsonParser.isNaN() && deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            return jsonParser.getDecimalValue();
        }
        if (jsonParser$NumberTypeFP == JsonParser$NumberTypeFP.FLOAT32) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        return jsonParser.getDoubleValue();
    }

    protected final Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) throws IOException {
        boolean bl2 = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (bl2) {
            this._squashDups(map, string, object, object2);
        }
        while (string2 != null) {
            jsonParser.nextToken();
            object2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            object = map.put(string2, object2);
            if (object != null && bl2) {
                this._squashDups(map, string2, object, object2);
            }
            string2 = jsonParser.nextFieldName();
        }
        return map;
    }

    private void _squashDups(Map<String, Object> map, String string, Object object, Object object2) {
        if (object instanceof List) {
            ((List)object).add(object2);
            map.put(string, object);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        map.put(string, arrayList);
    }
}

