/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.ext.CoreXMLDeserializers;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLDeserializers$Std
extends FromStringDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    protected final int _kind;

    public CoreXMLDeserializers$Std(Class<?> clazz, int n2) {
        super(clazz);
        this._kind = n2;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._kind == 2 && jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return this._gregorianFromDate(deserializationContext, this._parseDate(jsonParser, deserializationContext));
        }
        if (this._kind == 3 && jsonParser.hasToken(JsonToken.START_OBJECT)) {
            return this._parseQNameObject(jsonParser, deserializationContext);
        }
        return super.deserialize(jsonParser, deserializationContext);
    }

    private QName _parseQNameObject(JsonParser object, DeserializationContext object2) throws IOException {
        JsonNode jsonNode = ((JsonNode)(object = ((DeserializationContext)object2).readTree((JsonParser)object))).get("localPart");
        if (jsonNode == null) {
            ((DeserializationContext)object2).reportInputMismatch(this, "Object value for `QName` is missing required property 'localPart'", new Object[0]);
        }
        if (!jsonNode.isTextual()) {
            ((DeserializationContext)object2).reportInputMismatch(this, "Object value property 'localPart' for `QName` must be of type STRING, not %s", new Object[]{jsonNode.getNodeType()});
        }
        if ((object2 = ((JsonNode)object).get("namespaceURI")) != null) {
            if (((JsonNode)object).has("prefix")) {
                object = ((JsonNode)object).get("prefix");
                return new QName(((JsonNode)object2).asText(), jsonNode.asText(), ((JsonNode)object).asText());
            }
            return new QName(((JsonNode)object2).asText(), jsonNode.asText());
        }
        return new QName(jsonNode.asText());
    }

    @Override
    protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
        switch (this._kind) {
            case 1: {
                return CoreXMLDeserializers._dataTypeFactory.newDuration(string);
            }
            case 3: {
                return QName.valueOf(string);
            }
            case 2: {
                Date date;
                try {
                    date = this._parseDate(string, deserializationContext);
                }
                catch (JsonMappingException jsonMappingException) {
                    return CoreXMLDeserializers._dataTypeFactory.newXMLGregorianCalendar(string);
                }
                return this._gregorianFromDate(deserializationContext, date);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Object _deserializeFromEmptyString(DeserializationContext deserializationContext) throws IOException {
        if (this._kind == 3) {
            return CoreXMLDeserializers.EMPTY_QNAME;
        }
        return super._deserializeFromEmptyString(deserializationContext);
    }

    protected XMLGregorianCalendar _gregorianFromDate(DeserializationContext serializable, Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        serializable = ((DatabindContext)((Object)serializable)).getTimeZone();
        if (serializable != null) {
            gregorianCalendar.setTimeZone((TimeZone)serializable);
        }
        return CoreXMLDeserializers._dataTypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }
}

