/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import javax.xml.namespace.QName;

public class CoreXMLSerializers$QNameSerializer
extends StdSerializer<QName>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    public static final JsonSerializer<?> instance = new CoreXMLSerializers$QNameSerializer();

    public CoreXMLSerializers$QNameSerializer() {
        super(QName.class);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) throws JsonMappingException {
        if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType())) != null && (object = ((JsonFormat$Value)object).getShape()) == JsonFormat$Shape.OBJECT) {
            return this;
        }
        return ToStringSerializer.instance;
    }

    @Override
    public void serialize(QName qName, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(qName);
        this.serializeProperties(qName, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    @Override
    public final void serializeWithType(QName qName, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(qName, JsonToken.START_OBJECT));
        this.serializeProperties(qName, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    private void serializeProperties(QName qName, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStringField("localPart", qName.getLocalPart());
        if (!qName.getNamespaceURI().isEmpty()) {
            jsonGenerator.writeStringField("namespaceURI", qName.getNamespaceURI());
        }
        if (!qName.getPrefix().isEmpty()) {
            jsonGenerator.writeStringField("prefix", qName.getPrefix());
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectObjectFormat(javaType);
    }
}

