/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final TransformerFactory transformerFactory;

    public DOMSerializer() {
        super(Node.class);
        try {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DOMSerializer.setTransformerFactoryAttribute(this.transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            DOMSerializer.setTransformerFactoryAttribute(this.transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            return;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not instantiate `TransformerFactory`: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void serialize(Node node, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            StreamResult streamResult = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(node), streamResult);
            jsonGenerator.writeString(streamResult.getWriter().toString());
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Could not create XML Transformer for writing DOM `Node` value: " + transformerConfigurationException.getMessage(), transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            serializerProvider.reportMappingProblem(transformerException, "DOM `Node` value serialization failed: %s", transformerException.getMessage());
            return;
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper != null) {
            jsonFormatVisitorWrapper.expectAnyFormat(javaType);
        }
    }

    private static void setTransformerFactoryAttribute(TransformerFactory transformerFactory, String string, Object object) {
        try {
            transformerFactory.setAttribute(string, object);
            return;
        }
        catch (Exception exception) {
            System.err.println("[DOMSerializer] Failed to set TransformerFactory attribute: " + string);
            return;
        }
    }
}

