/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class NioPathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;
    private static final boolean areWindowsFilePathsSupported;

    public NioPathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        URI uRI;
        if (!((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
            return (Path)deserializationContext.handleUnexpectedToken(Path.class, (JsonParser)object);
        }
        if (((String)(object = ((JsonParser)object).getText())).indexOf(58) < 0) {
            return Paths.get((String)object, new String[0]);
        }
        if (areWindowsFilePathsSupported && ((String)object).length() >= 2 && Character.isLetter(((String)object).charAt(0)) && ((String)object).charAt(1) == ':') {
            return Paths.get((String)object, new String[0]);
        }
        try {
            uRI = new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            return (Path)deserializationContext.handleInstantiationProblem(((JsonDeserializer)this).handledType(), object, uRISyntaxException);
        }
        try {
            return Paths.get(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try {
                String string = uRI.getScheme();
                for (FileSystemProvider fileSystemProvider : ServiceLoader.load(FileSystemProvider.class)) {
                    if (!fileSystemProvider.getScheme().equalsIgnoreCase(string)) continue;
                    return fileSystemProvider.getPath(uRI);
                }
                return (Path)deserializationContext.handleInstantiationProblem(((JsonDeserializer)this).handledType(), object, fileSystemNotFoundException);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                ServiceConfigurationError serviceConfigurationError2 = serviceConfigurationError;
                serviceConfigurationError.addSuppressed(fileSystemNotFoundException);
                return (Path)deserializationContext.handleInstantiationProblem(((JsonDeserializer)this).handledType(), object, serviceConfigurationError2);
            }
        }
        catch (Exception exception) {
            return (Path)deserializationContext.handleInstantiationProblem(((JsonDeserializer)this).handledType(), object, exception);
        }
    }

    static {
        boolean bl2 = false;
        for (File file : File.listRoots()) {
            String object = file.getPath();
            if (object.length() < 2 || !Character.isLetter(object.charAt(0)) || object.charAt(1) != ':') continue;
            bl2 = true;
            break;
        }
        areWindowsFilePathsSupported = bl2;
    }
}

