/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ext.Java7Handlers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Java7Handlers _jdk7Helper;
    public static final OptionalHandlerFactory instance;
    private final Map<String, String> _sqlDeserializers = new HashMap<String, String>();
    private final Map<String, Object> _sqlSerializers;
    private static final String CLS_NAME_JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String CLS_NAME_JAVA_SQL_DATE = "java.sql.Date";
    private static final String CLS_NAME_JAVA_SQL_TIME = "java.sql.Time";
    private static final String CLS_NAME_JAVA_SQL_BLOB = "java.sql.Blob";
    private static final String CLS_NAME_JAVA_SQL_SERIALBLOB = "javax.sql.rowset.serial.SerialBlob";

    protected OptionalHandlerFactory() {
        this._sqlDeserializers.put(CLS_NAME_JAVA_SQL_DATE, "com.fasterxml.jackson.databind.deser.std.DateDeserializers$SqlDateDeserializer");
        this._sqlDeserializers.put(CLS_NAME_JAVA_SQL_TIMESTAMP, "com.fasterxml.jackson.databind.deser.std.DateDeserializers$TimestampDeserializer");
        this._sqlSerializers = new HashMap<String, Object>();
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_TIMESTAMP, DateSerializer.instance);
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_DATE, "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_TIME, "com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_BLOB, "com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_SERIALBLOB, "com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Object object;
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (this._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE, javaType);
        }
        if (_jdk7Helper != null && (object = _jdk7Helper.getSerializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        object = clazz.getName();
        Object object2 = this._sqlSerializers.get(object);
        if (object2 != null) {
            if (object2 instanceof JsonSerializer) {
                return (JsonSerializer)object2;
            }
            return (JsonSerializer)this.instantiate((String)object2, javaType);
        }
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        clazz = SERIALIZERS_FOR_JAVAX_XML;
        clazz = this.instantiate((String)((Object)clazz), javaType);
        if (clazz == null) {
            return null;
        }
        return ((Serializers)((Object)clazz)).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Object object;
        Object object2 = ((ResolvedType)javaType).getRawClass();
        if (_jdk7Helper != null && (object = _jdk7Helper.getDeserializerForJavaNioFilePath((Class<?>)object2)) != null) {
            return object;
        }
        if (this._IsXOfY((Class<?>)object2, CLASS_DOM_NODE)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE, javaType);
        }
        if (this._IsXOfY((Class<?>)object2, CLASS_DOM_DOCUMENT)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT, javaType);
        }
        object = ((Class)object2).getName();
        String string = this._sqlDeserializers.get(object);
        if (string != null) {
            return (JsonDeserializer)this.instantiate(string, javaType);
        }
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith((Class<?>)object2, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        object2 = DESERIALIZERS_FOR_JAVAX_XML;
        object2 = this.instantiate((String)object2, javaType);
        if (object2 == null) {
            return null;
        }
        return ((Deserializers)object2).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    public boolean hasDeserializerFor(Class<?> clazz) {
        if (this._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return true;
        }
        if (this._IsXOfY(clazz, CLASS_DOM_DOCUMENT)) {
            return true;
        }
        String string = clazz.getName();
        if (string.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return true;
        }
        return this._sqlDeserializers.containsKey(string);
    }

    private boolean _IsXOfY(Class<?> clazz, Class<?> clazz2) {
        return clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    private Object instantiate(String string, JavaType javaType) {
        try {
            return this.instantiate(Class.forName(string), javaType);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to find class `" + string + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable2.getClass().getName() + ") " + throwable2.getMessage());
        }
    }

    private Object instantiate(Class<?> clazz, JavaType javaType) {
        try {
            return ClassUtil.createInstance(clazz, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to create instance of `" + clazz.getName() + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable2.getClass().getName() + ") " + throwable2.getMessage());
        }
    }

    private boolean hasSuperClassStartingWith(Class<?> clazz, String string) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz == Object.class) {
                return false;
            }
            if (!clazz.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Object object = null;
        Object object2 = null;
        try {
            object2 = Node.class;
            object = Document.class;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        CLASS_DOM_NODE = object2;
        CLASS_DOM_DOCUMENT = object;
        object = null;
        try {
            object = Java7Handlers.instance();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        _jdk7Helper = object;
        instance = new OptionalHandlerFactory();
    }
}

