/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedFieldCollector$FieldBuilder;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext$Basic;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedFieldCollector
extends CollectorBase {
    private final TypeFactory _typeFactory;
    private final ClassIntrospector$MixInResolver _mixInResolver;
    private final boolean _collectAnnotations;

    AnnotatedFieldCollector(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, boolean bl2) {
        super(annotationIntrospector);
        this._typeFactory = typeFactory;
        this._mixInResolver = annotationIntrospector == null ? null : classIntrospector$MixInResolver;
        this._collectAnnotations = bl2;
    }

    public static List<AnnotatedField> collectFields(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, TypeFactory typeFactory, JavaType javaType, boolean bl2) {
        return new AnnotatedFieldCollector(annotationIntrospector, typeFactory, classIntrospector$MixInResolver, bl2).collect(typeResolutionContext, javaType);
    }

    List<AnnotatedField> collect(TypeResolutionContext iterator, JavaType serializable) {
        if ((iterator = this._findFields((TypeResolutionContext)((Object)iterator), (JavaType)serializable, null)) == null) {
            return Collections.emptyList();
        }
        serializable = new ArrayList(iterator.size());
        for (AnnotatedFieldCollector$FieldBuilder annotatedFieldCollector$FieldBuilder : iterator.values()) {
            serializable.add(annotatedFieldCollector$FieldBuilder.build());
        }
        return serializable;
    }

    private Map<String, AnnotatedFieldCollector$FieldBuilder> _findFields(TypeResolutionContext typeResolutionContext, JavaType type, Map<String, AnnotatedFieldCollector$FieldBuilder> map) {
        Object object = ((JavaType)type).getSuperClass();
        if (object == null) {
            return map;
        }
        type = ((ResolvedType)((Object)type)).getRawClass();
        map = this._findFields(new TypeResolutionContext$Basic(this._typeFactory, object.getBindings()), (JavaType)object, map);
        object = ((Class)type).getDeclaredFields();
        int n2 = ((Field[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = object[i2];
            if (!this._isIncludableField(field)) continue;
            if (map == null) {
                map = new LinkedHashMap<String, AnnotatedFieldCollector$FieldBuilder>();
            }
            AnnotatedFieldCollector$FieldBuilder annotatedFieldCollector$FieldBuilder = new AnnotatedFieldCollector$FieldBuilder(typeResolutionContext, field);
            if (this._collectAnnotations) {
                annotatedFieldCollector$FieldBuilder.annotations = this.collectAnnotations(annotatedFieldCollector$FieldBuilder.annotations, field.getDeclaredAnnotations());
            }
            map.put(field.getName(), annotatedFieldCollector$FieldBuilder);
        }
        if (map != null && this._mixInResolver != null && (object = this._mixInResolver.findMixInClassFor((Class<?>)type)) != null) {
            this._addFieldMixIns((Class<?>)object, (Class<?>)type, map);
        }
        return map;
    }

    private void _addFieldMixIns(Class<?> iterator, Class<?> fieldArray, Map<String, AnnotatedFieldCollector$FieldBuilder> map) {
        iterator = ClassUtil.findSuperClasses(iterator, fieldArray, true);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            fieldArray = iterator.next();
            for (Field field : fieldArray.getDeclaredFields()) {
                if (!this._isIncludableField(field)) continue;
                Object object = field.getName();
                if ((object = map.get(object)) == null) continue;
                ((AnnotatedFieldCollector$FieldBuilder)object).annotations = this.collectAnnotations(((AnnotatedFieldCollector$FieldBuilder)object).annotations, field.getDeclaredAnnotations());
            }
        }
    }

    private boolean _isIncludableField(Field field) {
        if (field.isEnumConstant()) {
            return true;
        }
        if (field.isSynthetic()) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }
}

