/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject$Value;
import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.fasterxml.jackson.databind.introspect.PotentialCreators;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final AccessorNamingStrategy _accessorNaming;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected final boolean _isRecordType;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected List<POJOPropertyBuilder> _creatorProperties;
    protected PotentialCreators _potentialCreators;
    protected Map<PropertyName, PropertyName> _fieldRenameMappings;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMember> _anyGetterField;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonKeyAccessors;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;
    protected JsonFormat$Value _formatOverrides;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl2, JavaType javaType, AnnotatedClass annotatedClass, AccessorNamingStrategy accessorNamingStrategy) {
        this._config = mapperConfig;
        this._forSerialization = bl2;
        this._type = javaType;
        this._classDef = annotatedClass;
        this._isRecordType = this._type.isRecordType();
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = this._config.getAnnotationIntrospector();
        } else {
            this._useAnnotations = false;
            this._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = this._config.getDefaultVisibilityChecker(((ResolvedType)javaType).getRawClass(), annotatedClass);
        this._accessorNaming = accessorNamingStrategy;
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public boolean isRecordType() {
        return this._isRecordType;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public PotentialCreators getPotentialCreators() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._potentialCreators;
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMember getJsonKeyAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonKeyAccessors != null) {
            if (this._jsonKeyAccessors.size() > 1) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                if (!pOJOPropertiesCollector._resolveFieldVsGetter(pOJOPropertiesCollector._jsonKeyAccessors)) {
                    this.reportProblem("Multiple 'as-key' properties defined (%s vs %s)", this._jsonKeyAccessors.get(0), this._jsonKeyAccessors.get(1));
                }
            }
            return this._jsonKeyAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueAccessors != null) {
            if (this._jsonValueAccessors.size() > 1) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                if (!pOJOPropertiesCollector._resolveFieldVsGetter(pOJOPropertiesCollector._jsonValueAccessors)) {
                    this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", this._jsonValueAccessors.get(0), this._jsonValueAccessors.get(1));
                }
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    @Deprecated
    public AnnotatedMember getAnyGetter() {
        return this.getAnyGetterMethod();
    }

    public AnnotatedMember getAnyGetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetterField != null) {
            if (this._anyGetterField.size() > 1) {
                this.reportProblem("Multiple 'any-getter' fields defined (%s vs %s)", this._anyGetterField.get(0), this._anyGetterField.get(1));
            }
            return this._anyGetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnyGetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getter' methods defined (%s vs %s)", this._anyGetters.get(0), this._anyGetters.get(1));
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", this._anySetterField.get(0), this._anySetterField.get(1));
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", this._anySetters.get(0), this._anySetters.get(1));
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    public JsonFormat$Value getFormatOverrides() {
        if (this._formatOverrides == null) {
            JsonFormat$Value jsonFormat$Value;
            JsonFormat$Value jsonFormat$Value2 = null;
            if (this._annotationIntrospector != null) {
                jsonFormat$Value2 = this._annotationIntrospector.findFormat(this._classDef);
            }
            if ((jsonFormat$Value = this._config.getDefaultPropertyFormat(((ResolvedType)this._type).getRawClass())) != null) {
                jsonFormat$Value2 = jsonFormat$Value2 == null ? jsonFormat$Value : jsonFormat$Value2.withOverrides(jsonFormat$Value);
            }
            this._formatOverrides = jsonFormat$Value2 == null ? JsonFormat$Value.empty() : jsonFormat$Value2;
        }
        return this._formatOverrides;
    }

    protected void collectAll() {
        this._potentialCreators = new PotentialCreators();
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        this._addFields(linkedHashMap);
        this._addMethods(linkedHashMap);
        if (!this._classDef.isNonStaticInnerClass()) {
            this._addCreators(linkedHashMap);
        }
        this._removeUnwantedProperties(linkedHashMap);
        this._removeUnwantedAccessors(linkedHashMap);
        this._renameProperties(linkedHashMap);
        this._addInjectables(linkedHashMap);
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.mergeAnnotations(this._forSerialization);
        }
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._isRecordType && !this._forSerialization) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
                pOJOPropertyBuilder.removeFields();
            }
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    private Map<String, POJOPropertyBuilder> _putAnyGettersInTheEnd(Map<String, POJOPropertyBuilder> object) {
        AnnotatedMember annotatedMember;
        if (this._anyGetters != null) {
            annotatedMember = this._anyGetters.getFirst();
        } else if (this._anyGetterField != null) {
            annotatedMember = this._anyGetterField.getFirst();
        } else {
            return object;
        }
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>(object.size() << 1);
        BeanPropertyDefinition beanPropertyDefinition = null;
        for (POJOPropertyBuilder pOJOPropertyBuilder : object.values()) {
            if (pOJOPropertyBuilder.hasFieldOrGetter(annotatedMember)) {
                beanPropertyDefinition = pOJOPropertyBuilder;
                continue;
            }
            linkedHashMap.put(((BeanPropertyDefinition)pOJOPropertyBuilder).getName(), pOJOPropertyBuilder);
        }
        if (beanPropertyDefinition != null) {
            linkedHashMap.put(beanPropertyDefinition.getName(), (POJOPropertyBuilder)beanPropertyDefinition);
        }
        return linkedHashMap;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl2 = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl3 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl4;
            String string;
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedField))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedField);
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            boolean bl5 = Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedField));
            boolean bl6 = Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedField));
            if (bl5 || bl6) {
                if (bl5) {
                    if (this._anyGetterField == null) {
                        this._anyGetterField = new LinkedList();
                    }
                    this._anyGetterField.add(annotatedField);
                }
                if (bl6) {
                    if (this._anySetterField == null) {
                        this._anySetterField = new LinkedList();
                    }
                    this._anySetterField.add(annotatedField);
                    continue;
                }
            }
            if ((string = annotationIntrospector.findImplicitPropertyName(annotatedField)) == null) {
                string = ((Annotated)annotatedField).getName();
            }
            if ((string = this._accessorNaming.modifyFieldName(annotatedField, string)) == null) continue;
            PropertyName propertyName = this._propNameFromSimple(string);
            PropertyName propertyName2 = annotationIntrospector.findRenameByField(this._config, annotatedField, propertyName);
            if (propertyName2 != null && !propertyName2.equals(propertyName)) {
                if (this._fieldRenameMappings == null) {
                    this._fieldRenameMappings = new HashMap<PropertyName, PropertyName>();
                }
                this._fieldRenameMappings.put(propertyName2, propertyName);
            }
            propertyName = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField);
            boolean bl7 = propertyName != null;
            boolean bl8 = bl7;
            if (bl7 && propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl8 = false;
            }
            if (!(bl4 = propertyName != null)) {
                bl4 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl9 = annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl7) {
                if (bl3) {
                    bl9 = true;
                } else if (!bl9) continue;
            }
            if (bl2 && propertyName == null && !bl9 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(map, string).addField(annotatedField, propertyName, bl8, bl4, bl9);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        Object object = this._potentialCreators;
        POJOPropertiesCollector pOJOPropertiesCollector = this;
        List<PotentialCreator> list = pOJOPropertiesCollector._collectCreators(pOJOPropertiesCollector._classDef.getConstructors());
        POJOPropertiesCollector pOJOPropertiesCollector2 = this;
        List<PotentialCreator> list2 = pOJOPropertiesCollector2._collectCreators(pOJOPropertiesCollector2._classDef.getFactoryMethods());
        Object object2 = this._isRecordType ? JDK14Util.findCanonicalRecordConstructor(this._config, this._classDef, list) : this._annotationIntrospector.findDefaultCreator(this._config, this._classDef, list, list2);
        this._removeDisabledCreators(list);
        this._removeDisabledCreators(list2);
        this._removeNonFactoryStaticMethods(list2, (PotentialCreator)object2);
        if (this._useAnnotations) {
            this._addExplicitlyAnnotatedCreators((PotentialCreators)object, list, map, false);
            this._addExplicitlyAnnotatedCreators((PotentialCreators)object, list2, map, ((PotentialCreators)object).hasPropertiesBased());
        }
        if (!((PotentialCreators)object).hasPropertiesBased()) {
            this._addCreatorsWithAnnotatedNames((PotentialCreators)object, list, (PotentialCreator)object2);
        }
        if (object2 != null && (list.remove(object2) || list2.remove(object2))) {
            if (this._isDelegatingConstructor((PotentialCreator)object2)) {
                if (!((PotentialCreators)object).hasDelegating()) {
                    ((PotentialCreators)object).addExplicitDelegating((PotentialCreator)object2);
                }
            } else if (!((PotentialCreators)object).hasPropertiesBased()) {
                ((PotentialCreators)object).setPropertiesBased(this._config, (PotentialCreator)object2, "Primary");
            }
        }
        object2 = this._config.getConstructorDetector();
        if (!(((PotentialCreators)object).hasPropertiesBasedOrDelegating() || ((ConstructorDetector)object2).requireCtorAnnotation() || this._classDef.getDefaultConstructor() != null && !((ConstructorDetector)object2).singleArgCreatorDefaultsToProperties())) {
            this._addImplicitConstructor((PotentialCreators)object, list, map);
        }
        this._removeNonVisibleCreators(list);
        this._removeNonVisibleCreators(list2);
        ((PotentialCreators)object).setImplicitDelegating(list, list2);
        object = ((PotentialCreators)object).propertiesBased;
        if (object == null) {
            this._creatorProperties = Collections.emptyList();
            return;
        }
        this._creatorProperties = new ArrayList<POJOPropertyBuilder>();
        this._addCreatorParams(map, (PotentialCreator)object, this._creatorProperties);
    }

    private boolean _isDelegatingConstructor(PotentialCreator potentialCreator) {
        switch (potentialCreator.creatorModeOrDefault()) {
            case DELEGATING: {
                return true;
            }
            case DISABLED: 
            case PROPERTIES: {
                return false;
            }
        }
        return potentialCreator.paramCount() == 1 && this._jsonValueAccessors != null && !this._jsonValueAccessors.isEmpty();
    }

    private List<PotentialCreator> _collectCreators(List<? extends AnnotatedWithParams> object) {
        if (object.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PotentialCreator> arrayList = new ArrayList<PotentialCreator>();
        object = object.iterator();
        while (object.hasNext()) {
            AnnotatedWithParams annotatedWithParams = (AnnotatedWithParams)object.next();
            JsonCreator$Mode jsonCreator$Mode = this._useAnnotations ? this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedWithParams) : null;
            arrayList.add(new PotentialCreator(annotatedWithParams, jsonCreator$Mode));
        }
        return arrayList;
    }

    private void _removeDisabledCreators(List<PotentialCreator> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (((PotentialCreator)object.next()).creatorMode() != JsonCreator$Mode.DISABLED) continue;
            object.remove();
        }
    }

    private void _removeNonVisibleCreators(List<PotentialCreator> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PotentialCreator potentialCreator = (PotentialCreator)object.next();
            if (this._visibilityChecker.isCreatorVisible(potentialCreator.creator())) continue;
            object.remove();
        }
    }

    private void _removeNonFactoryStaticMethods(List<PotentialCreator> object, PotentialCreator potentialCreator) {
        Class<?> clazz = ((ResolvedType)this._type).getRawClass();
        object = object.iterator();
        while (object.hasNext()) {
            AnnotatedWithParams annotatedWithParams;
            Object object2 = (PotentialCreator)object.next();
            if (((PotentialCreator)object2).isAnnotated() || potentialCreator == object2 || clazz.isAssignableFrom((annotatedWithParams = ((PotentialCreator)object2).creator()).getRawType()) && ((PotentialCreator)object2).paramCount() == 1 && ("valueOf".equals(object2 = annotatedWithParams.getName()) || "fromString".equals(object2) && ((object2 = annotatedWithParams.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom((Class<?>)object2)))) continue;
            object.remove();
        }
    }

    private void _addExplicitlyAnnotatedCreators(PotentialCreators potentialCreators, List<PotentialCreator> object, Map<String, POJOPropertyBuilder> map, boolean bl2) {
        ConstructorDetector constructorDetector = this._config.getConstructorDetector();
        object = object.iterator();
        while (object.hasNext()) {
            boolean bl3;
            PotentialCreator potentialCreator = (PotentialCreator)object.next();
            if (!potentialCreator.isAnnotated()) continue;
            object.remove();
            switch (potentialCreator.creatorMode()) {
                case DELEGATING: {
                    bl3 = false;
                    break;
                }
                case PROPERTIES: {
                    bl3 = true;
                    break;
                }
                default: {
                    bl3 = this._isExplicitlyAnnotatedCreatorPropsBased(potentialCreator, map, constructorDetector);
                }
            }
            if (bl3) {
                if (bl2) continue;
                potentialCreators.setPropertiesBased(this._config, potentialCreator, "explicit");
                continue;
            }
            potentialCreators.addExplicitDelegating(potentialCreator);
        }
    }

    private boolean _isExplicitlyAnnotatedCreatorPropsBased(PotentialCreator potentialCreator, Map<String, POJOPropertyBuilder> object, ConstructorDetector serializable) {
        if (potentialCreator.paramCount() == 1) {
            switch (((ConstructorDetector)serializable).singleArgMode()) {
                case DELEGATING: {
                    return false;
                }
                case PROPERTIES: {
                    return true;
                }
                case REQUIRE_MODE: {
                    throw new IllegalArgumentException(String.format("Single-argument constructor (%s) is annotated but no 'mode' defined; `ConstructorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", potentialCreator.creator()));
                }
            }
        }
        potentialCreator.introspectParamNames(this._config);
        if (potentialCreator.hasExplicitNames()) {
            return true;
        }
        if (this._jsonValueAccessors != null && !this._jsonValueAccessors.isEmpty()) {
            return false;
        }
        if (potentialCreator.paramCount() == 1) {
            serializable = potentialCreator.implicitName(0);
            if (serializable != null) {
                POJOPropertyBuilder pOJOPropertyBuilder2 = object.get(((PropertyName)serializable).getSimpleName());
                if (pOJOPropertyBuilder2 != null) {
                    if (pOJOPropertyBuilder2.anyVisible() && !pOJOPropertyBuilder2.anyIgnorals()) {
                        return true;
                    }
                } else {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : object.values()) {
                        if (!pOJOPropertyBuilder2.anyVisible() || pOJOPropertyBuilder2.anyIgnorals() || !pOJOPropertyBuilder2.hasExplicitName((PropertyName)serializable)) continue;
                        return true;
                    }
                }
            }
            return this._annotationIntrospector != null && this._annotationIntrospector.findInjectableValue(potentialCreator.param(0)) != null;
        }
        return potentialCreator.hasNameOrInjectForAllParams(this._config);
    }

    private void _addCreatorsWithAnnotatedNames(PotentialCreators potentialCreators, List<PotentialCreator> object, PotentialCreator potentialCreator) {
        object = this._findCreatorsWithAnnotatedNames((List<PotentialCreator>)object);
        if (potentialCreator != null && object.contains(potentialCreator)) {
            potentialCreators.setPropertiesBased(this._config, potentialCreator, "implicit");
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            potentialCreator = (PotentialCreator)object.next();
            potentialCreators.setPropertiesBased(this._config, potentialCreator, "implicit");
        }
    }

    private List<PotentialCreator> _findCreatorsWithAnnotatedNames(List<PotentialCreator> object) {
        ArrayList<PotentialCreator> arrayList = null;
        object = object.iterator();
        while (object.hasNext()) {
            PotentialCreator potentialCreator = (PotentialCreator)object.next();
            potentialCreator.introspectParamNames(this._config);
            if (!potentialCreator.hasExplicitNames()) continue;
            object.remove();
            if (arrayList == null) {
                arrayList = new ArrayList<PotentialCreator>(4);
            }
            arrayList.add(potentialCreator);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private boolean _addImplicitConstructor(PotentialCreators potentialCreators, List<PotentialCreator> list, Map<String, POJOPropertyBuilder> object) {
        if (list.size() != 1) {
            return false;
        }
        PotentialCreator potentialCreator = list.get(0);
        if (!this._visibilityChecker.isCreatorVisible(potentialCreator.creator())) {
            return false;
        }
        potentialCreator.introspectParamNames(this._config);
        if (potentialCreator.paramCount() != 1) {
            if (!potentialCreator.hasNameOrInjectForAllParams(this._config)) {
                return false;
            }
        } else if (this._annotationIntrospector == null || this._annotationIntrospector.findInjectableValue(potentialCreator.param(0)) == null) {
            ConstructorDetector constructorDetector = this._config.getConstructorDetector();
            if (constructorDetector.singleArgCreatorDefaultsToDelegating()) {
                return false;
            }
            String string = potentialCreator.implicitNameSimple(0);
            if (string == null) {
                return false;
            }
            if (!(constructorDetector.singleArgCreatorDefaultsToProperties() || (object = object.get(string)) != null && ((POJOPropertyBuilder)object).anyVisible() && !((POJOPropertyBuilder)object).anyIgnorals())) {
                return false;
            }
        }
        list.remove(0);
        potentialCreators.setPropertiesBased(this._config, potentialCreator, "implicit");
        return true;
    }

    private void _addCreatorParams(Map<String, POJOPropertyBuilder> map, PotentialCreator potentialCreator, List<POJOPropertyBuilder> list) {
        int n2 = potentialCreator.paramCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            POJOPropertyBuilder pOJOPropertyBuilder;
            AnnotatedParameter annotatedParameter = potentialCreator.param(i2);
            PropertyName propertyName = potentialCreator.explicitName(i2);
            Object object = potentialCreator.implicitName(i2);
            boolean bl2 = propertyName != null;
            if (!bl2 && object == null) {
                boolean bl3 = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter) != null;
                if (bl3) {
                    propertyName = UnwrappedPropertyHandler.creatorParamName(annotatedParameter.getIndex());
                    pOJOPropertyBuilder = this._property(map, propertyName);
                    pOJOPropertyBuilder.addCtor(annotatedParameter, propertyName, false, true, false);
                } else {
                    pOJOPropertyBuilder = null;
                }
            } else {
                if (object != null) {
                    object = this._checkRenameByField(((PropertyName)object).getSimpleName());
                    object = PropertyName.construct((String)object);
                }
                pOJOPropertyBuilder = object == null ? this._property(map, propertyName) : this._property(map, (PropertyName)object);
                pOJOPropertyBuilder.addCtor(annotatedParameter, (PropertyName)(bl2 ? propertyName : object), bl2, true, false);
            }
            list.add(pOJOPropertyBuilder);
        }
        potentialCreator.assignPropertyDefs(list);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (n2 == 0) {
                this._addGetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 == 1) {
                this._addSetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 != 2 || !Boolean.TRUE.equals(this._annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        Object object = annotatedMethod.getRawReturnType();
        if (object == Void.TYPE || object == Void.class && !this._config.isEnabled(MapperFeature.ALLOW_VOID_VALUED_PROPERTIES)) {
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
            if (this._anyGetters == null) {
                this._anyGetters = new LinkedList();
            }
            this._anyGetters.add(annotatedMethod);
        } else {
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedMethod))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedMethod);
                return;
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedMethod);
                return;
            }
        }
        PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl3 = propertyName != null;
        if (!bl3) {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                AnnotatedMethod annotatedMethod2 = annotatedMethod;
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod2, ((Annotated)annotatedMethod2).getName());
            }
            if (object == null) {
                AnnotatedMethod annotatedMethod3 = annotatedMethod;
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod3, ((Annotated)annotatedMethod3).getName());
                if (object == null) {
                    return;
                }
                bl2 = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl2 = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                AnnotatedMethod annotatedMethod4 = annotatedMethod;
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod4, ((Annotated)annotatedMethod4).getName());
                if (object == null) {
                    AnnotatedMethod annotatedMethod5 = annotatedMethod;
                    object = this._accessorNaming.findNameForIsGetter(annotatedMethod5, ((Annotated)annotatedMethod5).getName());
                }
            }
            if (object == null) {
                object = ((Annotated)annotatedMethod).getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple((String)object);
                bl3 = false;
            }
            bl2 = true;
        }
        object = this._checkRenameByField((String)object);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, (String)object).addGetter(annotatedMethod, propertyName, bl3, bl2, bl4);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        String string;
        PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl3 = propertyName != null;
        if (!bl3) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod2 = annotatedMethod;
                string = this._accessorNaming.findNameForMutator(annotatedMethod2, ((Annotated)annotatedMethod2).getName());
            }
            if (string == null) {
                return;
            }
            bl2 = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod3 = annotatedMethod;
                string = this._accessorNaming.findNameForMutator(annotatedMethod3, ((Annotated)annotatedMethod3).getName());
            }
            if (string == null) {
                string = ((Annotated)annotatedMethod).getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl3 = false;
            }
            bl2 = true;
        }
        string = this._checkRenameByField(string);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl3, bl2, bl4);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> iterator) {
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (((AnnotatedWithParams)annotatedMethod).getParameterCount() != 1) continue;
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(JacksonInject$Value object, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (object == null) {
            return;
        }
        object = ((JacksonInject$Value)object).getId();
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null && annotatedMember2.getClass() == annotatedMember.getClass()) {
            this.reportProblem("Duplicate injectable value with id '%s' (of type %s)", object, ClassUtil.classNameOf(object));
        }
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    private String _checkRenameByField(String string) {
        PropertyName propertyName;
        if (this._fieldRenameMappings != null && (propertyName = this._fieldRenameMappings.get(this._propNameFromSimple(string))) != null) {
            string = propertyName.getSimpleName();
            return string;
        }
        return string;
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> object) {
        object = object.values().iterator();
        while (object.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)object.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                object.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (this.isRecordType() && !this._forSerialization) {
                pOJOPropertyBuilder.removeIgnored();
                this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
                continue;
            }
            if (!pOJOPropertyBuilder.anyExplicitsWithoutIgnoral()) {
                object.remove();
                this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (((BeanPropertyDefinition)pOJOPropertyBuilder).couldDeserialize()) continue;
            this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
        }
    }

    protected void _removeUnwantedAccessors(Map<String, POJOPropertyBuilder> object) {
        boolean bl2 = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : object.values()) {
            pOJOPropertyBuilder.removeNonVisible(bl2, this._forSerialization ? null : this);
        }
    }

    protected void _collectIgnorals(String string) {
        if (!this._forSerialization && string != null) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            if (this._ignoredPropertyNames != null && this._ignoredPropertyNames.contains(((BeanPropertyDefinition)pOJOPropertyBuilder).getName()) || (object2 = pOJOPropertyBuilder.findExplicitNames()).isEmpty()) continue;
            iterator.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                if (!pOJOPropertiesCollector._replaceCreatorProperty(pOJOPropertiesCollector._creatorProperties, pOJOPropertyBuilder) || this._ignoredPropertyNames == null) continue;
                this._ignoredPropertyNames.remove(object2);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        if (((ResolvedType)this._type).isEnumType() && this.getFormatOverrides().getShape() != JsonFormat$Shape.OBJECT) {
            return;
        }
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            Object object = ((BeanPropertyDefinition)pOJOPropertyBuilder).getFullName();
            Object object2 = null;
            if (!((BeanPropertyDefinition)pOJOPropertyBuilder).isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasGetter()) {
                        object2 = propertyNamingStrategy.nameForGetterMethod(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getGetter(), ((PropertyName)object).getSimpleName());
                    } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasField()) {
                        object2 = propertyNamingStrategy.nameForField(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getField(), ((PropertyName)object).getSimpleName());
                    }
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasSetter()) {
                    object2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetterUnchecked(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasConstructorParameter()) {
                    object2 = propertyNamingStrategy.nameForConstructorParameter(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getConstructorParameter(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasField()) {
                    object2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getFieldUnchecked(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasGetter()) {
                    object2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetterUnchecked(), ((PropertyName)object).getSimpleName());
                }
            }
            if (object2 != null && !((PropertyName)object).hasSimpleName((String)object2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName((String)object2);
                object = object2;
            } else {
                object = ((PropertyName)object).getSimpleName();
            }
            object2 = map.get(object);
            if (object2 == null) {
                map.put((String)object, pOJOPropertyBuilder);
            } else {
                ((POJOPropertyBuilder)object2).addAll(pOJOPropertyBuilder);
            }
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._replaceCreatorProperty(pOJOPropertiesCollector._creatorProperties, pOJOPropertyBuilder);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(((BeanPropertyDefinition)pOJOPropertyBuilder).getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        Object object2;
        Map<Object, Object> map2;
        String[] stringArray = this._annotationIntrospector;
        Boolean bl2 = this._annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl3 = bl2 == null ? this._config.shouldSortPropertiesAlphabetically() : bl2.booleanValue();
        boolean bl4 = this._anyIndexed(map.values());
        stringArray = stringArray.findSerializationPropertyOrder(this._classDef);
        if (!bl3 && !bl4 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n2 = map.size();
        if (bl3) {
            map2 = new TreeMap();
        } else {
            int n3 = n2;
            map2 = new LinkedHashMap(n3 + n3);
        }
        for (POJOPropertyBuilder object32 : map.values()) {
            map2.put(((BeanPropertyDefinition)object32).getName(), object32);
        }
        map2 = this._putAnyGettersInTheEnd(map2);
        int n4 = n2;
        LinkedHashMap linkedHashMap = new LinkedHashMap(n4 + n4);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n5 = stringArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                void var10_25;
                object2 = stringArray2[n2];
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)map2.remove(object2);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!((String)object2).equals(((BeanPropertyDefinition)pOJOPropertyBuilder2).getInternalName())) continue;
                        POJOPropertyBuilder pOJOPropertyBuilder3 = pOJOPropertyBuilder2;
                        object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder2).getName();
                        break;
                    }
                }
                if (var10_25 == null) continue;
                linkedHashMap.put(object2, var10_25);
            }
        }
        if (bl4) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            Iterator<Map.Entry<Object, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                object2 = (POJOPropertyBuilder)entry.getValue();
                Integer n5 = ((BeanPropertyDefinition)object2).getMetadata().getIndex();
                if (n5 == null) continue;
                treeMap.put(n5, object2);
                iterator.remove();
            }
            for (Object object2 : treeMap.values()) {
                linkedHashMap.put(((BeanPropertyDefinition)object2).getName(), object2);
            }
        }
        if (this._creatorProperties != null && (!bl3 || this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_FIRST))) {
            void var8_23;
            boolean bl5 = bl3 && !this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_BY_DECLARATION_ORDER);
            if (bl5) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    if (pOJOPropertyBuilder == null) continue;
                    treeMap.put(((BeanPropertyDefinition)pOJOPropertyBuilder).getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                List<POJOPropertyBuilder> list = this._creatorProperties;
            }
            for (Object object2 : var8_23) {
                String string;
                if (object2 == null || !map2.containsKey(string = ((BeanPropertyDefinition)object2).getName())) continue;
                linkedHashMap.put(string, object2);
            }
        }
        linkedHashMap.putAll(map2);
        map.clear();
        map.putAll(linkedHashMap);
    }

    private boolean _anyIndexed(Collection<POJOPropertyBuilder> object) {
        object = object.iterator();
        while (object.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)object.next();
            if (!((BeanPropertyDefinition)pOJOPropertyBuilder).getMetadata().hasIndex()) continue;
            return true;
        }
        return false;
    }

    protected boolean _resolveFieldVsGetter(List<AnnotatedMember> list) {
        do {
            AnnotatedMember annotatedMember = list.get(0);
            AnnotatedMember annotatedMember2 = list.get(1);
            if (annotatedMember instanceof AnnotatedField) {
                if (annotatedMember2 instanceof AnnotatedMethod) {
                    list.remove(0);
                    continue;
                }
            } else if (annotatedMember instanceof AnnotatedMethod && annotatedMember2 instanceof AnnotatedField) {
                list.remove(1);
                continue;
            }
            return false;
        } while (list.size() > 1);
        return true;
    }

    protected void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        Object object;
        Object object2 = this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object2 == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object2 instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object2;
        }
        if (!(object2 instanceof Class)) {
            this.reportProblem("AnnotationIntrospector returned PropertyNamingStrategy definition of type %s; expected type `PropertyNamingStrategy` or `Class<PropertyNamingStrategy>` instead", ClassUtil.classNameOf(object2));
        }
        if ((object2 = (Class)object2) == PropertyNamingStrategy.class) {
            return null;
        }
        if (!PropertyNamingStrategy.class.isAssignableFrom((Class<?>)object2)) {
            this.reportProblem("AnnotationIntrospector returned Class %s; expected `Class<PropertyNamingStrategy>`", ClassUtil.classNameOf(object2));
        }
        if ((object = this._config.getHandlerInstantiator()) != null && (object = ((HandlerInstantiator)object).namingStrategyInstance(this._config, this._classDef, (Class<?>)object2)) != null) {
            return object;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(object2, this._config.canOverrideAccessModifiers());
    }

    protected boolean _replaceCreatorProperty(List<POJOPropertyBuilder> list, POJOPropertyBuilder pOJOPropertyBuilder) {
        AnnotatedParameter annotatedParameter = ((BeanPropertyDefinition)pOJOPropertyBuilder).getConstructorParameter();
        if (list != null && annotatedParameter != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                POJOPropertyBuilder pOJOPropertyBuilder2 = list.get(i2);
                if (pOJOPropertyBuilder2 == null || ((BeanPropertyDefinition)pOJOPropertyBuilder2).getConstructorParameter() != annotatedParameter) continue;
                list.set(i2, pOJOPropertyBuilder);
                return true;
            }
        }
        return false;
    }
}

