/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.annotation.JsonProperty$Access;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.AnnotationIntrospector$ReferenceProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyMetadata$MergeInfo;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$1;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$2;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$3;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$4;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$5;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$Linked;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$MemberIterator;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder$WithMember;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class POJOPropertyBuilder
extends BeanPropertyDefinition
implements Comparable<POJOPropertyBuilder> {
    private static final AnnotationIntrospector$ReferenceProperty NOT_REFEFERENCE_PROP = AnnotationIntrospector$ReferenceProperty.managed("");
    protected final boolean _forSerialization;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyName _name;
    protected final PropertyName _internalName;
    protected POJOPropertyBuilder$Linked<AnnotatedField> _fields;
    protected POJOPropertyBuilder$Linked<AnnotatedParameter> _ctorParameters;
    protected POJOPropertyBuilder$Linked<AnnotatedMethod> _getters;
    protected POJOPropertyBuilder$Linked<AnnotatedMethod> _setters;
    protected transient PropertyMetadata _metadata;
    protected transient AnnotationIntrospector$ReferenceProperty _referenceInfo;

    public POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl2, PropertyName propertyName) {
        PropertyName propertyName2 = propertyName;
        this(mapperConfig, annotationIntrospector, bl2, propertyName2, propertyName2);
    }

    protected POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl2, PropertyName propertyName, PropertyName propertyName2) {
        this._config = mapperConfig;
        this._annotationIntrospector = annotationIntrospector;
        this._internalName = propertyName;
        this._name = propertyName2;
        this._forSerialization = bl2;
    }

    protected POJOPropertyBuilder(POJOPropertyBuilder pOJOPropertyBuilder, PropertyName propertyName) {
        this._config = pOJOPropertyBuilder._config;
        this._annotationIntrospector = pOJOPropertyBuilder._annotationIntrospector;
        this._internalName = pOJOPropertyBuilder._internalName;
        this._name = propertyName;
        this._fields = pOJOPropertyBuilder._fields;
        this._ctorParameters = pOJOPropertyBuilder._ctorParameters;
        this._getters = pOJOPropertyBuilder._getters;
        this._setters = pOJOPropertyBuilder._setters;
        this._forSerialization = pOJOPropertyBuilder._forSerialization;
    }

    @Override
    public POJOPropertyBuilder withName(PropertyName propertyName) {
        return new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public POJOPropertyBuilder withSimpleName(String object) {
        if ((object = this._name.withSimpleName((String)object)) == this._name) {
            return this;
        }
        return new POJOPropertyBuilder(this, (PropertyName)object);
    }

    @Override
    public int compareTo(POJOPropertyBuilder pOJOPropertyBuilder) {
        if (this._ctorParameters != null) {
            if (pOJOPropertyBuilder._ctorParameters == null) {
                return -1;
            }
        } else if (pOJOPropertyBuilder._ctorParameters != null) {
            return 1;
        }
        return ((BeanPropertyDefinition)this).getName().compareTo(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
    }

    @Override
    public String getName() {
        if (this._name == null) {
            return null;
        }
        return this._name.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._name;
    }

    @Override
    public boolean hasName(PropertyName propertyName) {
        return this._name.equals(propertyName);
    }

    @Override
    public String getInternalName() {
        return this._internalName.getSimpleName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getPrimaryMember();
        if (annotatedMember == null || this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.findWrapperName(annotatedMember);
    }

    @Override
    public boolean isExplicitlyIncluded() {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._anyExplicits(pOJOPropertyBuilder._fields)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._anyExplicits(pOJOPropertyBuilder2._getters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._anyExplicits(pOJOPropertyBuilder3._setters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._anyExplicitNames(pOJOPropertyBuilder4._ctorParameters)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isExplicitlyNamed() {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._anyExplicitNames(pOJOPropertyBuilder._fields)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._anyExplicitNames(pOJOPropertyBuilder2._getters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._anyExplicitNames(pOJOPropertyBuilder3._setters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._anyExplicitNames(pOJOPropertyBuilder4._ctorParameters)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        if (this._metadata == null) {
            AnnotatedMember annotatedMember = this.getPrimaryMemberUnchecked();
            if (annotatedMember == null) {
                this._metadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            } else {
                Boolean bl2 = this._annotationIntrospector.hasRequiredMarker(annotatedMember);
                String string = this._annotationIntrospector.findPropertyDescription(annotatedMember);
                Integer n2 = this._annotationIntrospector.findPropertyIndex(annotatedMember);
                String string2 = this._annotationIntrospector.findPropertyDefaultValue(annotatedMember);
                this._metadata = bl2 == null && n2 == null && string2 == null ? (string == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : PropertyMetadata.STD_REQUIRED_OR_OPTIONAL.withDescription(string)) : PropertyMetadata.construct(bl2, string, n2, string2);
                if (!this._forSerialization) {
                    this._metadata = this._getSetterInfo(this._metadata, annotatedMember);
                }
            }
        }
        return this._metadata;
    }

    protected PropertyMetadata _getSetterInfo(PropertyMetadata propertyMetadata, AnnotatedMember object) {
        Serializable serializable;
        boolean bl2 = true;
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = this.getAccessor();
        if (object != null) {
            if (this._annotationIntrospector != null) {
                if (annotatedMember != null && (serializable = this._annotationIntrospector.findMergeInfo((Annotated)object)) != null) {
                    bl2 = false;
                    if (((Boolean)serializable).booleanValue()) {
                        propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata$MergeInfo.createForPropertyOverride(annotatedMember));
                    }
                }
                if ((serializable = this._annotationIntrospector.findSetterInfo((Annotated)object)) != null) {
                    nulls = ((JsonSetter$Value)serializable).nonDefaultValueNulls();
                    nulls2 = ((JsonSetter$Value)serializable).nonDefaultContentNulls();
                }
            }
            if (bl2 || nulls == null || nulls2 == null) {
                serializable = this._rawTypeOf((AnnotatedMember)object);
                object = this._config.getConfigOverride((Class<?>)serializable);
                if ((serializable = ((ConfigOverride)object).getSetterInfo()) != null) {
                    if (nulls == null) {
                        nulls = ((JsonSetter$Value)serializable).nonDefaultValueNulls();
                    }
                    if (nulls2 == null) {
                        nulls2 = ((JsonSetter$Value)serializable).nonDefaultContentNulls();
                    }
                }
                if (bl2 && annotatedMember != null && (object = ((ConfigOverride)object).getMergeable()) != null) {
                    bl2 = false;
                    if (((Boolean)object).booleanValue()) {
                        propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata$MergeInfo.createForTypeOverride(annotatedMember));
                    }
                }
            }
        }
        if (bl2 || nulls == null || nulls2 == null) {
            serializable = this._config.getDefaultSetterInfo();
            if (nulls == null) {
                nulls = ((JsonSetter$Value)serializable).nonDefaultValueNulls();
            }
            if (nulls2 == null) {
                nulls2 = ((JsonSetter$Value)serializable).nonDefaultContentNulls();
            }
            if (bl2 && Boolean.TRUE.equals(object = this._config.getDefaultMergeable()) && annotatedMember != null) {
                propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata$MergeInfo.createForDefaults(annotatedMember));
            }
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JavaType getPrimaryType() {
        if (this._forSerialization) {
            AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getGetter();
            if (annotatedMember == null && (annotatedMember = ((BeanPropertyDefinition)this).getField()) == null) {
                return TypeFactory.unknownType();
            }
            return ((Annotated)annotatedMember).getType();
        }
        AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getConstructorParameter();
        if (annotatedMember == null) {
            annotatedMember = ((BeanPropertyDefinition)this).getSetter();
            if (annotatedMember != null) {
                return ((AnnotatedWithParams)((AnnotatedMethod)annotatedMember)).getParameterType(0);
            }
            annotatedMember = ((BeanPropertyDefinition)this).getField();
        }
        if (annotatedMember == null && (annotatedMember = ((BeanPropertyDefinition)this).getGetter()) == null) {
            return TypeFactory.unknownType();
        }
        return ((Annotated)annotatedMember).getType();
    }

    @Override
    public Class<?> getRawPrimaryType() {
        return ((ResolvedType)((BeanPropertyDefinition)this).getPrimaryType()).getRawClass();
    }

    @Override
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override
    public boolean hasField() {
        return this._fields != null;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override
    public boolean couldDeserialize() {
        block3: {
            block2: {
                if (this._ctorParameters != null || this._setters != null) break block2;
                if (this._fields == null) break block3;
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (!pOJOPropertyBuilder._anyVisible(pOJOPropertyBuilder._fields)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean couldSerialize() {
        return this._getters != null || this._fields != null;
    }

    @Override
    public AnnotatedMethod getGetter() {
        POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked = this._getters;
        if (pOJOPropertyBuilder$Linked == null) {
            return null;
        }
        POJOPropertyBuilder$Linked pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked.next;
        if (pOJOPropertyBuilder$Linked2 == null) {
            return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
        }
        while (pOJOPropertyBuilder$Linked2 != null) {
            block11: {
                int n2;
                int n3;
                block9: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block10: {
                        clazz2 = ((AnnotatedMember)((AnnotatedMethod)pOJOPropertyBuilder$Linked.value)).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMember)((AnnotatedMethod)pOJOPropertyBuilder$Linked2.value)).getDeclaringClass())) break block9;
                        if (!clazz2.isAssignableFrom(clazz)) break block10;
                        pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked2;
                        break block11;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block11;
                }
                if ((n3 = this._getterPriority((AnnotatedMethod)pOJOPropertyBuilder$Linked2.value)) != (n2 = this._getterPriority((AnnotatedMethod)pOJOPropertyBuilder$Linked.value))) {
                    if (n3 < n2) {
                        pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked2;
                    }
                } else {
                    throw new IllegalArgumentException("Conflicting getter definitions for property \"" + ((BeanPropertyDefinition)this).getName() + "\": " + ((AnnotatedMember)((AnnotatedMethod)pOJOPropertyBuilder$Linked.value)).getFullName() + " vs " + ((AnnotatedMember)((AnnotatedMethod)pOJOPropertyBuilder$Linked2.value)).getFullName());
                }
            }
            pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked2.next;
        }
        this._getters = pOJOPropertyBuilder$Linked.withoutNext();
        return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
    }

    protected AnnotatedMethod getGetterUnchecked() {
        POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked = this._getters;
        if (pOJOPropertyBuilder$Linked == null) {
            return null;
        }
        return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
    }

    @Override
    public AnnotatedMethod getSetter() {
        POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked = this._setters;
        if (pOJOPropertyBuilder$Linked == null) {
            return null;
        }
        POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked.next;
        if (pOJOPropertyBuilder$Linked2 == null) {
            return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
        }
        while (pOJOPropertyBuilder$Linked2 != null) {
            AnnotatedMethod annotatedMethod = this._selectSetter((AnnotatedMethod)pOJOPropertyBuilder$Linked.value, (AnnotatedMethod)pOJOPropertyBuilder$Linked2.value);
            if (annotatedMethod != pOJOPropertyBuilder$Linked.value) {
                if (annotatedMethod == pOJOPropertyBuilder$Linked2.value) {
                    pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked2;
                } else {
                    return this._selectSetterFromMultiple(pOJOPropertyBuilder$Linked, pOJOPropertyBuilder$Linked2);
                }
            }
            pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked2.next;
        }
        this._setters = pOJOPropertyBuilder$Linked.withoutNext();
        return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
    }

    protected AnnotatedMethod getSetterUnchecked() {
        POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked = this._setters;
        if (pOJOPropertyBuilder$Linked == null) {
            return null;
        }
        return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
    }

    protected AnnotatedMethod _selectSetterFromMultiple(POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked, POJOPropertyBuilder$Linked<AnnotatedMethod> pOJOPropertyBuilder$Linked2) {
        Object object;
        ArrayList arrayList = new ArrayList();
        arrayList.add(pOJOPropertyBuilder$Linked.value);
        arrayList.add(pOJOPropertyBuilder$Linked2.value);
        pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked2.next;
        while (pOJOPropertyBuilder$Linked2 != null) {
            object = this._selectSetter((AnnotatedMethod)pOJOPropertyBuilder$Linked.value, (AnnotatedMethod)pOJOPropertyBuilder$Linked2.value);
            if (object != pOJOPropertyBuilder$Linked.value) {
                if (object == pOJOPropertyBuilder$Linked2.value) {
                    arrayList.clear();
                    pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked2;
                } else {
                    arrayList.add(pOJOPropertyBuilder$Linked2.value);
                }
            }
            pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked2.next;
        }
        if (arrayList.isEmpty()) {
            this._setters = pOJOPropertyBuilder$Linked.withoutNext();
            return (AnnotatedMethod)pOJOPropertyBuilder$Linked.value;
        }
        object = arrayList.stream().map(AnnotatedMethod::getFullName).collect(Collectors.joining(" vs "));
        throw new IllegalArgumentException(String.format("Conflicting setter definitions for property \"%s\": %s", ((BeanPropertyDefinition)this).getName(), object));
    }

    protected AnnotatedMethod _selectSetter(AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        int n2;
        int n3;
        Class<?> clazz;
        Class<?> clazz2 = ((AnnotatedMember)annotatedMethod).getDeclaringClass();
        if (clazz2 != (clazz = ((AnnotatedMember)annotatedMethod2).getDeclaringClass())) {
            if (clazz2.isAssignableFrom(clazz)) {
                return annotatedMethod2;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return annotatedMethod;
            }
        }
        if ((n3 = this._setterPriority(annotatedMethod2)) != (n2 = this._setterPriority(annotatedMethod))) {
            if (n3 < n2) {
                return annotatedMethod2;
            }
            return annotatedMethod;
        }
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.resolveSetterConflict(this._config, annotatedMethod, annotatedMethod2);
    }

    @Override
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField annotatedField = (AnnotatedField)this._fields.value;
        POJOPropertyBuilder$Linked pOJOPropertyBuilder$Linked = this._fields.next;
        while (pOJOPropertyBuilder$Linked != null) {
            block10: {
                boolean bl2;
                boolean bl3;
                AnnotatedField annotatedField2;
                block8: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block9: {
                        annotatedField2 = (AnnotatedField)pOJOPropertyBuilder$Linked.value;
                        clazz2 = ((AnnotatedMember)annotatedField).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMember)annotatedField2).getDeclaringClass())) break block8;
                        if (!clazz2.isAssignableFrom(clazz)) break block9;
                        annotatedField = annotatedField2;
                        break block10;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block10;
                }
                if ((bl3 = annotatedField.isStatic()) != (bl2 = annotatedField2.isStatic())) {
                    if (bl3) {
                        annotatedField = annotatedField2;
                    }
                } else {
                    throw new IllegalArgumentException("Multiple fields representing property \"" + ((BeanPropertyDefinition)this).getName() + "\": " + annotatedField.getFullName() + " vs " + annotatedField2.getFullName());
                }
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return annotatedField;
    }

    protected AnnotatedField getFieldUnchecked() {
        POJOPropertyBuilder$Linked<AnnotatedField> pOJOPropertyBuilder$Linked = this._fields;
        if (pOJOPropertyBuilder$Linked == null) {
            return null;
        }
        return (AnnotatedField)pOJOPropertyBuilder$Linked.value;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        POJOPropertyBuilder$Linked<AnnotatedParameter> pOJOPropertyBuilder$Linked = this._ctorParameters;
        do {
            if (!(((AnnotatedParameter)pOJOPropertyBuilder$Linked.value).getOwner() instanceof AnnotatedConstructor)) continue;
            return (AnnotatedParameter)pOJOPropertyBuilder$Linked.value;
        } while ((pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next) != null);
        return (AnnotatedParameter)this._ctorParameters.value;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        if (this._ctorParameters == null) {
            return ClassUtil.emptyIterator();
        }
        return new POJOPropertyBuilder$MemberIterator<AnnotatedParameter>(this._ctorParameters);
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        if (this._forSerialization) {
            return this.getAccessor();
        }
        AnnotatedMember annotatedMember = this.getMutator();
        if (annotatedMember == null) {
            annotatedMember = this.getAccessor();
        }
        return annotatedMember;
    }

    protected AnnotatedMember getPrimaryMemberUnchecked() {
        if (this._forSerialization) {
            if (this._getters != null) {
                return (AnnotatedMember)this._getters.value;
            }
            if (this._fields != null) {
                return (AnnotatedMember)this._fields.value;
            }
            return null;
        }
        if (this._ctorParameters != null) {
            return (AnnotatedMember)this._ctorParameters.value;
        }
        if (this._setters != null) {
            return (AnnotatedMember)this._setters.value;
        }
        if (this._fields != null) {
            return (AnnotatedMember)this._fields.value;
        }
        if (this._getters != null) {
            return (AnnotatedMember)this._getters.value;
        }
        return null;
    }

    protected int _getterPriority(AnnotatedMethod object) {
        if (((String)(object = ((Annotated)object).getName())).startsWith("get") && ((String)object).length() > 3) {
            return 1;
        }
        if (((String)object).startsWith("is") && ((String)object).length() > 2) {
            return 2;
        }
        return 3;
    }

    protected int _setterPriority(AnnotatedMethod object) {
        if (((String)(object = ((Annotated)object).getName())).startsWith("set") && ((String)object).length() > 3) {
            return 1;
        }
        return 2;
    }

    public boolean hasFieldOrGetter(AnnotatedMember annotatedMember) {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._hasAccessor(pOJOPropertyBuilder._fields, annotatedMember)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (!pOJOPropertyBuilder2._hasAccessor(pOJOPropertyBuilder2._getters, annotatedMember)) break block3;
            }
            return true;
        }
        return false;
    }

    private boolean _hasAccessor(POJOPropertyBuilder$Linked<? extends AnnotatedMember> pOJOPropertyBuilder$Linked, AnnotatedMember object) {
        object = ((AnnotatedMember)object).getMember();
        while (pOJOPropertyBuilder$Linked != null) {
            if (((AnnotatedMember)pOJOPropertyBuilder$Linked.value).getMember() == object) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    @Override
    public Class<?>[] findViews() {
        return this.fromMemberAnnotations(new POJOPropertyBuilder$1(this));
    }

    @Override
    public AnnotationIntrospector$ReferenceProperty findReferenceType() {
        AnnotationIntrospector$ReferenceProperty annotationIntrospector$ReferenceProperty = this._referenceInfo;
        if (annotationIntrospector$ReferenceProperty != null) {
            if (annotationIntrospector$ReferenceProperty == NOT_REFEFERENCE_PROP) {
                return null;
            }
            return annotationIntrospector$ReferenceProperty;
        }
        annotationIntrospector$ReferenceProperty = this.fromMemberAnnotations(new POJOPropertyBuilder$2(this));
        this._referenceInfo = annotationIntrospector$ReferenceProperty == null ? NOT_REFEFERENCE_PROP : annotationIntrospector$ReferenceProperty;
        return annotationIntrospector$ReferenceProperty;
    }

    @Override
    public boolean isTypeId() {
        Boolean bl2 = this.fromMemberAnnotations(new POJOPropertyBuilder$3(this));
        return bl2 != null && bl2 != false;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo() {
        return this.fromMemberAnnotations(new POJOPropertyBuilder$4(this));
    }

    @Override
    public JsonInclude$Value findInclusion() {
        Serializable serializable = this.getAccessor();
        serializable = this._annotationIntrospector == null ? null : this._annotationIntrospector.findPropertyInclusion((Annotated)((Object)serializable));
        if (serializable == null) {
            return JsonInclude$Value.empty();
        }
        return serializable;
    }

    @Override
    public List<PropertyName> findAliases() {
        Object object = ((BeanPropertyDefinition)this).getPrimaryMember();
        if (object != null && (object = this._annotationIntrospector.findPropertyAliases((Annotated)object)) != null) {
            return object;
        }
        return Collections.emptyList();
    }

    public JsonProperty$Access findAccess() {
        JsonProperty$Access jsonProperty$Access = this.fromMemberAnnotationsExcept(new POJOPropertyBuilder$5(this), JsonProperty$Access.AUTO);
        if (this._config.isEnabled(MapperFeature.INVERSE_READ_WRITE_ACCESS)) {
            if (jsonProperty$Access == JsonProperty$Access.READ_ONLY) {
                jsonProperty$Access = JsonProperty$Access.WRITE_ONLY;
            } else if (jsonProperty$Access == JsonProperty$Access.WRITE_ONLY) {
                jsonProperty$Access = JsonProperty$Access.READ_ONLY;
            }
        }
        return jsonProperty$Access;
    }

    public void addField(AnnotatedField annotatedField, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._fields = new POJOPropertyBuilder$Linked<AnnotatedField>(annotatedField, this._fields, propertyName, bl2, bl3, bl4);
    }

    public void addCtor(AnnotatedParameter annotatedParameter, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._ctorParameters = new POJOPropertyBuilder$Linked<AnnotatedParameter>(annotatedParameter, this._ctorParameters, propertyName, bl2, bl3, bl4);
    }

    public void addGetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._getters = new POJOPropertyBuilder$Linked<AnnotatedMethod>(annotatedMethod, this._getters, propertyName, bl2, bl3, bl4);
    }

    public void addSetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._setters = new POJOPropertyBuilder$Linked<AnnotatedMethod>(annotatedMethod, this._setters, propertyName, bl2, bl3, bl4);
    }

    public void addAll(POJOPropertyBuilder pOJOPropertyBuilder) {
        this._fields = POJOPropertyBuilder.merge(this._fields, pOJOPropertyBuilder._fields);
        this._ctorParameters = POJOPropertyBuilder.merge(this._ctorParameters, pOJOPropertyBuilder._ctorParameters);
        this._getters = POJOPropertyBuilder.merge(this._getters, pOJOPropertyBuilder._getters);
        this._setters = POJOPropertyBuilder.merge(this._setters, pOJOPropertyBuilder._setters);
    }

    private static <T> POJOPropertyBuilder$Linked<T> merge(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked, POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked2) {
        if (pOJOPropertyBuilder$Linked == null) {
            return pOJOPropertyBuilder$Linked2;
        }
        if (pOJOPropertyBuilder$Linked2 == null) {
            return pOJOPropertyBuilder$Linked;
        }
        return pOJOPropertyBuilder$Linked.append(pOJOPropertyBuilder$Linked2);
    }

    public void removeIgnored() {
        this._fields = this._removeIgnored(this._fields);
        this._getters = this._removeIgnored(this._getters);
        this._setters = this._removeIgnored(this._setters);
        this._ctorParameters = this._removeIgnored(this._ctorParameters);
    }

    public JsonProperty$Access removeNonVisible(boolean bl2, POJOPropertiesCollector pOJOPropertiesCollector) {
        JsonProperty$Access jsonProperty$Access = this.findAccess();
        if (jsonProperty$Access == null) {
            jsonProperty$Access = JsonProperty$Access.AUTO;
        }
        switch (jsonProperty$Access) {
            case READ_ONLY: {
                if (pOJOPropertiesCollector != null) {
                    pOJOPropertiesCollector._collectIgnorals(((BeanPropertyDefinition)this).getName());
                    for (PropertyName propertyName : this.findExplicitNames()) {
                        pOJOPropertiesCollector._collectIgnorals(propertyName.getSimpleName());
                    }
                }
                this._setters = null;
                this._ctorParameters = null;
                if (this._forSerialization) break;
                this._fields = null;
                break;
            }
            case READ_WRITE: {
                break;
            }
            case WRITE_ONLY: {
                this._getters = null;
                if (!this._forSerialization) break;
                this._fields = null;
                break;
            }
            default: {
                this._getters = this._removeNonVisible(this._getters);
                this._ctorParameters = this._removeNonVisible(this._ctorParameters);
                if (bl2 && this._getters != null) break;
                this._fields = this._removeNonVisible(this._fields);
                this._setters = this._removeNonVisible(this._setters);
            }
        }
        return jsonProperty$Access;
    }

    public void removeConstructors() {
        this._ctorParameters = null;
    }

    public void removeFields() {
        this._fields = null;
    }

    public void trimByVisibility() {
        this._fields = this._trimByVisibility(this._fields);
        this._getters = this._trimByVisibility(this._getters);
        this._setters = this._trimByVisibility(this._setters);
        this._ctorParameters = this._trimByVisibility(this._ctorParameters);
    }

    public void mergeAnnotations(boolean bl2) {
        if (bl2) {
            if (this._getters != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this._applyAnnotations(this._getters, annotationMap);
                return;
            }
            if (this._fields != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this._applyAnnotations(this._fields, annotationMap);
                return;
            }
        } else {
            if (this._ctorParameters != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._ctorParameters, this._setters, this._fields, this._getters);
                this._ctorParameters = this._applyAnnotations(this._ctorParameters, annotationMap);
                return;
            }
            if (this._setters != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._setters, this._fields, this._getters);
                this._setters = this._applyAnnotations(this._setters, annotationMap);
                return;
            }
            if (this._fields != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._getters);
                this._fields = this._applyAnnotations(this._fields, annotationMap);
            }
        }
    }

    private AnnotationMap _mergeAnnotations(int n2, POJOPropertyBuilder$Linked<? extends AnnotatedMember> ... pOJOPropertyBuilder$LinkedArray) {
        AnnotationMap annotationMap = this._getAllAnnotations(pOJOPropertyBuilder$LinkedArray[n2]);
        while (++n2 < pOJOPropertyBuilder$LinkedArray.length) {
            if (pOJOPropertyBuilder$LinkedArray[n2] == null) continue;
            return AnnotationMap.merge(annotationMap, this._mergeAnnotations(n2, pOJOPropertyBuilder$LinkedArray));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> AnnotationMap _getAllAnnotations(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        AnnotationMap annotationMap = ((AnnotatedMember)pOJOPropertyBuilder$Linked.value).getAllAnnotations();
        if (pOJOPropertyBuilder$Linked.next != null) {
            annotationMap = AnnotationMap.merge(annotationMap, this._getAllAnnotations(pOJOPropertyBuilder$Linked.next));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> POJOPropertyBuilder$Linked<T> _applyAnnotations(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked, AnnotationMap annotationMap) {
        AnnotatedMember annotatedMember = (AnnotatedMember)((AnnotatedMember)pOJOPropertyBuilder$Linked.value).withAnnotations(annotationMap);
        if (pOJOPropertyBuilder$Linked.next != null) {
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.withNext(this._applyAnnotations(pOJOPropertyBuilder$Linked.next, annotationMap));
        }
        return pOJOPropertyBuilder$Linked.withValue(annotatedMember);
    }

    private <T> POJOPropertyBuilder$Linked<T> _removeIgnored(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        if (pOJOPropertyBuilder$Linked == null) {
            return pOJOPropertyBuilder$Linked;
        }
        return pOJOPropertyBuilder$Linked.withoutIgnored();
    }

    private <T> POJOPropertyBuilder$Linked<T> _removeNonVisible(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        if (pOJOPropertyBuilder$Linked == null) {
            return pOJOPropertyBuilder$Linked;
        }
        return pOJOPropertyBuilder$Linked.withoutNonVisible();
    }

    private <T> POJOPropertyBuilder$Linked<T> _trimByVisibility(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        if (pOJOPropertyBuilder$Linked == null) {
            return pOJOPropertyBuilder$Linked;
        }
        return pOJOPropertyBuilder$Linked.trimByVisibility();
    }

    private <T> boolean _anyExplicits(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.name != null && pOJOPropertyBuilder$Linked.name.hasSimpleName()) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    private <T> boolean _anyExplicitNames(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.name != null && pOJOPropertyBuilder$Linked.isNameExplicit) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    public boolean anyVisible() {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._anyVisible(pOJOPropertyBuilder._fields)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._anyVisible(pOJOPropertyBuilder2._getters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._anyVisible(pOJOPropertyBuilder3._setters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._anyVisible(pOJOPropertyBuilder4._ctorParameters)) break block3;
            }
            return true;
        }
        return false;
    }

    private <T> boolean _anyVisible(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.isVisible) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    public boolean anyIgnorals() {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._anyIgnorals(pOJOPropertyBuilder._fields)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._anyIgnorals(pOJOPropertyBuilder2._getters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._anyIgnorals(pOJOPropertyBuilder3._setters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._anyIgnorals(pOJOPropertyBuilder4._ctorParameters)) break block3;
            }
            return true;
        }
        return false;
    }

    private <T> boolean _anyIgnorals(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.isMarkedIgnored) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    public boolean anyExplicitsWithoutIgnoral() {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._anyExplicitsWithoutIgnoral(pOJOPropertyBuilder._fields)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._anyExplicitsWithoutIgnoral(pOJOPropertyBuilder2._getters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._anyExplicitsWithoutIgnoral(pOJOPropertyBuilder3._setters)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._anyExplicitNamesWithoutIgnoral(pOJOPropertyBuilder4._ctorParameters)) break block3;
            }
            return true;
        }
        return false;
    }

    private <T> boolean _anyExplicitsWithoutIgnoral(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (!pOJOPropertyBuilder$Linked.isMarkedIgnored && pOJOPropertyBuilder$Linked.name != null && pOJOPropertyBuilder$Linked.name.hasSimpleName()) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    private <T> boolean _anyExplicitNamesWithoutIgnoral(POJOPropertyBuilder$Linked<T> pOJOPropertyBuilder$Linked) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (!pOJOPropertyBuilder$Linked.isMarkedIgnored && pOJOPropertyBuilder$Linked.name != null && pOJOPropertyBuilder$Linked.isNameExplicit) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    public Set<PropertyName> findExplicitNames() {
        POJOPropertyBuilder pOJOPropertyBuilder = this;
        Set<PropertyName> set = pOJOPropertyBuilder._findExplicitNames(pOJOPropertyBuilder._fields, null);
        POJOPropertyBuilder pOJOPropertyBuilder2 = this;
        set = pOJOPropertyBuilder2._findExplicitNames(pOJOPropertyBuilder2._getters, set);
        POJOPropertyBuilder pOJOPropertyBuilder3 = this;
        set = pOJOPropertyBuilder3._findExplicitNames(pOJOPropertyBuilder3._setters, set);
        POJOPropertyBuilder pOJOPropertyBuilder4 = this;
        if ((set = pOJOPropertyBuilder4._findExplicitNames(pOJOPropertyBuilder4._ctorParameters, set)) == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public boolean hasExplicitName(PropertyName propertyName) {
        block3: {
            block2: {
                POJOPropertyBuilder pOJOPropertyBuilder = this;
                if (pOJOPropertyBuilder._hasExplicitName(pOJOPropertyBuilder._fields, propertyName)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder2 = this;
                if (pOJOPropertyBuilder2._hasExplicitName(pOJOPropertyBuilder2._getters, propertyName)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder3 = this;
                if (pOJOPropertyBuilder3._hasExplicitName(pOJOPropertyBuilder3._setters, propertyName)) break block2;
                POJOPropertyBuilder pOJOPropertyBuilder4 = this;
                if (!pOJOPropertyBuilder4._hasExplicitName(pOJOPropertyBuilder4._ctorParameters, propertyName)) break block3;
            }
            return true;
        }
        return false;
    }

    private boolean _hasExplicitName(POJOPropertyBuilder$Linked<? extends AnnotatedMember> pOJOPropertyBuilder$Linked, PropertyName propertyName) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.isNameExplicit && propertyName.equals(pOJOPropertyBuilder$Linked.name)) {
                return true;
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return false;
    }

    public Collection<POJOPropertyBuilder> explode(Collection<PropertyName> collection) {
        HashMap<PropertyName, POJOPropertyBuilder> hashMap = new HashMap<PropertyName, POJOPropertyBuilder>();
        this._explode(collection, hashMap, this._fields);
        this._explode(collection, hashMap, this._getters);
        this._explode(collection, hashMap, this._setters);
        this._explode(collection, hashMap, this._ctorParameters);
        return hashMap.values();
    }

    private void _explode(Collection<PropertyName> collection, Map<PropertyName, POJOPropertyBuilder> map, POJOPropertyBuilder$Linked<?> pOJOPropertyBuilder$Linked) {
        POJOPropertyBuilder$Linked<?> pOJOPropertyBuilder$Linked2 = pOJOPropertyBuilder$Linked;
        while (pOJOPropertyBuilder$Linked != null) {
            POJOPropertyBuilder$Linked<Object> pOJOPropertyBuilder$Linked3 = pOJOPropertyBuilder$Linked.name;
            if (!pOJOPropertyBuilder$Linked.isNameExplicit || pOJOPropertyBuilder$Linked3 == null) {
                if (pOJOPropertyBuilder$Linked.isVisible) {
                    throw new IllegalStateException("Conflicting/ambiguous property name definitions (implicit name " + ClassUtil.name(this._name) + "): found multiple explicit names: " + collection + ", but also implicit accessor: " + pOJOPropertyBuilder$Linked);
                }
            } else {
                POJOPropertyBuilder pOJOPropertyBuilder = map.get(pOJOPropertyBuilder$Linked3);
                if (pOJOPropertyBuilder == null) {
                    pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, this._internalName, (PropertyName)((Object)pOJOPropertyBuilder$Linked3));
                    map.put((PropertyName)((Object)pOJOPropertyBuilder$Linked3), pOJOPropertyBuilder);
                }
                if (pOJOPropertyBuilder$Linked2 == this._fields) {
                    pOJOPropertyBuilder$Linked3 = pOJOPropertyBuilder$Linked;
                    pOJOPropertyBuilder._fields = pOJOPropertyBuilder$Linked3.withNext(pOJOPropertyBuilder._fields);
                } else if (pOJOPropertyBuilder$Linked2 == this._getters) {
                    pOJOPropertyBuilder$Linked3 = pOJOPropertyBuilder$Linked;
                    pOJOPropertyBuilder._getters = pOJOPropertyBuilder$Linked3.withNext(pOJOPropertyBuilder._getters);
                } else if (pOJOPropertyBuilder$Linked2 == this._setters) {
                    pOJOPropertyBuilder$Linked3 = pOJOPropertyBuilder$Linked;
                    pOJOPropertyBuilder._setters = pOJOPropertyBuilder$Linked3.withNext(pOJOPropertyBuilder._setters);
                } else if (pOJOPropertyBuilder$Linked2 == this._ctorParameters) {
                    pOJOPropertyBuilder$Linked3 = pOJOPropertyBuilder$Linked;
                    pOJOPropertyBuilder._ctorParameters = pOJOPropertyBuilder$Linked3.withNext(pOJOPropertyBuilder._ctorParameters);
                } else {
                    throw new IllegalStateException("Internal error: mismatched accessors, property: " + this);
                }
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
    }

    private Set<PropertyName> _findExplicitNames(POJOPropertyBuilder$Linked<? extends AnnotatedMember> pOJOPropertyBuilder$Linked, Set<PropertyName> set) {
        while (pOJOPropertyBuilder$Linked != null) {
            if (pOJOPropertyBuilder$Linked.isNameExplicit && pOJOPropertyBuilder$Linked.name != null) {
                if (set == null) {
                    set = new HashSet<PropertyName>();
                }
                set.add(pOJOPropertyBuilder$Linked.name);
            }
            pOJOPropertyBuilder$Linked = pOJOPropertyBuilder$Linked.next;
        }
        return set;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected <T> T fromMemberAnnotations(POJOPropertyBuilder$WithMember<T> pOJOPropertyBuilder$WithMember) {
        T t2 = null;
        if (this._annotationIntrospector != null) {
            if (this._forSerialization) {
                if (this._getters != null) {
                    t2 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._getters.value);
                }
            } else {
                if (this._ctorParameters != null) {
                    t2 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._ctorParameters.value);
                }
                if (t2 == null && this._setters != null) {
                    t2 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._setters.value);
                }
            }
            if (t2 == null && this._fields != null) {
                t2 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._fields.value);
            }
        }
        return t2;
    }

    protected <T> T fromMemberAnnotationsExcept(POJOPropertyBuilder$WithMember<T> pOJOPropertyBuilder$WithMember, T t2) {
        T t3;
        if (this._annotationIntrospector == null) {
            return null;
        }
        if (this._forSerialization) {
            T t4;
            if (this._getters != null && (t4 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._getters.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._fields != null && (t4 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._fields.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._ctorParameters != null && (t4 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._ctorParameters.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._setters != null && (t4 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._setters.value)) != null && t4 != t2) {
                return t4;
            }
            return null;
        }
        if (this._ctorParameters != null && (t3 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._ctorParameters.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._setters != null && (t3 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._setters.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._fields != null && (t3 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._fields.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._getters != null && (t3 = pOJOPropertyBuilder$WithMember.withMember((AnnotatedMember)this._getters.value)) != null && t3 != t2) {
            return t3;
        }
        return null;
    }

    protected Class<?> _rawTypeOf(AnnotatedMember annotatedMember) {
        AnnotatedMethod annotatedMethod;
        if (annotatedMember instanceof AnnotatedMethod && ((AnnotatedWithParams)(annotatedMethod = (AnnotatedMethod)annotatedMember)).getParameterCount() > 0) {
            return ((ResolvedType)((AnnotatedWithParams)annotatedMethod).getParameterType(0)).getRawClass();
        }
        return ((ResolvedType)annotatedMember.getType()).getRawClass();
    }
}

