/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator$Builder;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator$NameMatcher;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator$TypeMatcher;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator$Base;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator$Validity;
import java.io.Serializable;
import java.util.Set;

public class BasicPolymorphicTypeValidator
extends PolymorphicTypeValidator$Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<Class<?>> _invalidBaseTypes;
    protected final BasicPolymorphicTypeValidator$TypeMatcher[] _baseTypeMatchers;
    protected final BasicPolymorphicTypeValidator$NameMatcher[] _subTypeNameMatchers;
    protected final BasicPolymorphicTypeValidator$TypeMatcher[] _subClassMatchers;

    protected BasicPolymorphicTypeValidator(Set<Class<?>> set, BasicPolymorphicTypeValidator$TypeMatcher[] basicPolymorphicTypeValidator$TypeMatcherArray, BasicPolymorphicTypeValidator$NameMatcher[] basicPolymorphicTypeValidator$NameMatcherArray, BasicPolymorphicTypeValidator$TypeMatcher[] basicPolymorphicTypeValidator$TypeMatcherArray2) {
        this._invalidBaseTypes = set;
        this._baseTypeMatchers = basicPolymorphicTypeValidator$TypeMatcherArray;
        this._subTypeNameMatchers = basicPolymorphicTypeValidator$NameMatcherArray;
        this._subClassMatchers = basicPolymorphicTypeValidator$TypeMatcherArray2;
    }

    public static BasicPolymorphicTypeValidator$Builder builder() {
        return new BasicPolymorphicTypeValidator$Builder();
    }

    @Override
    public PolymorphicTypeValidator$Validity validateBaseType(MapperConfig<?> mapperConfig, JavaType type) {
        type = ((ResolvedType)((Object)type)).getRawClass();
        if (this._invalidBaseTypes != null && this._invalidBaseTypes.contains(type)) {
            return PolymorphicTypeValidator$Validity.DENIED;
        }
        if (this._baseTypeMatchers != null) {
            BasicPolymorphicTypeValidator$TypeMatcher[] basicPolymorphicTypeValidator$TypeMatcherArray = this._baseTypeMatchers;
            int n2 = this._baseTypeMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                BasicPolymorphicTypeValidator$TypeMatcher basicPolymorphicTypeValidator$TypeMatcher = basicPolymorphicTypeValidator$TypeMatcherArray[i2];
                if (!basicPolymorphicTypeValidator$TypeMatcher.match(mapperConfig, (Class<?>)type)) continue;
                return PolymorphicTypeValidator$Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator$Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator$Validity validateSubClassName(MapperConfig<?> mapperConfig, JavaType basicPolymorphicTypeValidator$NameMatcherArray, String string) throws JsonMappingException {
        if (this._subTypeNameMatchers != null) {
            basicPolymorphicTypeValidator$NameMatcherArray = this._subTypeNameMatchers;
            int n2 = this._subTypeNameMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                BasicPolymorphicTypeValidator$NameMatcher basicPolymorphicTypeValidator$NameMatcher = basicPolymorphicTypeValidator$NameMatcherArray[i2];
                if (!basicPolymorphicTypeValidator$NameMatcher.match(mapperConfig, string)) continue;
                return PolymorphicTypeValidator$Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator$Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator$Validity validateSubType(MapperConfig<?> mapperConfig, JavaType type, JavaType basicPolymorphicTypeValidator$TypeMatcherArray) throws JsonMappingException {
        if (this._subClassMatchers != null) {
            type = basicPolymorphicTypeValidator$TypeMatcherArray.getRawClass();
            basicPolymorphicTypeValidator$TypeMatcherArray = this._subClassMatchers;
            int n2 = this._subClassMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                BasicPolymorphicTypeValidator$TypeMatcher basicPolymorphicTypeValidator$TypeMatcher = basicPolymorphicTypeValidator$TypeMatcherArray[i2];
                if (!basicPolymorphicTypeValidator$TypeMatcher.match(mapperConfig, (Class<?>)type)) continue;
                return PolymorphicTypeValidator$Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator$Validity.INDETERMINATE;
    }
}

