/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ClassNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JAVA_UTIL_PKG = "java.util.";
    protected final PolymorphicTypeValidator _subTypeValidator;
    protected final Set<String> _allowedSubtypes;

    @Deprecated
    protected ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        this(javaType, typeFactory, LaissezFaireSubTypeValidator.instance);
    }

    @Deprecated
    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        this(javaType, typeFactory, null, polymorphicTypeValidator);
    }

    public ClassNameIdResolver(JavaType serializable, TypeFactory object, Collection<NamedType> object2, PolymorphicTypeValidator polymorphicTypeValidator) {
        super((JavaType)serializable, (TypeFactory)object);
        this._subTypeValidator = polymorphicTypeValidator;
        serializable = null;
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (NamedType)object.next();
                if (serializable == null) {
                    serializable = new HashSet();
                }
                serializable.add(((NamedType)object2).getType().getName());
            }
        }
        this._allowedSubtypes = serializable == null ? Collections.emptySet() : serializable;
    }

    @Deprecated
    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, Collection<NamedType> collection, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), collection, polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo$Id getMechanism() {
        return JsonTypeInfo$Id.CLASS;
    }

    @Deprecated
    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        Object object2 = object;
        return this._idFrom(object2, object2.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext object) throws IOException {
        DeserializationContext deserializationContext = null;
        if (object instanceof DeserializationContext) {
            deserializationContext = (DeserializationContext)object;
        }
        if (this._allowedSubtypes != null && deserializationContext != null && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED) && !this._allowedSubtypes.contains(string)) {
            throw deserializationContext.invalidTypeIdException(this._baseType, string, "`DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED` is enabled and the input class is not registered using `@JsonSubTypes` annotation");
        }
        if ((object = ((DatabindContext)object).resolveAndValidateSubType(this._baseType, string, this._subTypeValidator)) == null && deserializationContext != null) {
            return deserializationContext.handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return object;
    }

    protected String _idFrom(Object clazz, Class<?> clazz2, TypeFactory typeFactory) {
        String string = (clazz2 = this._resolveToParentAsNecessary(clazz2)).getName();
        if (string.startsWith(JAVA_UTIL_PKG)) {
            if (clazz instanceof EnumSet) {
                clazz = ClassUtil.findEnumType((EnumSet)((Object)clazz));
                string = ((ResolvedType)typeFactory.constructCollectionType(EnumSet.class, clazz)).toCanonical();
            } else if (clazz instanceof EnumMap) {
                clazz = ClassUtil.findEnumType((EnumMap)((Object)clazz));
                clazz2 = Object.class;
                string = ((ResolvedType)typeFactory.constructMapType(EnumMap.class, clazz, clazz2)).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && (clazz = ClassUtil.getOuterClass(clazz2)) != null && ClassUtil.getOuterClass(clazz2 = ((ResolvedType)this._baseType).getRawClass()) == null) {
            clazz2 = ((ResolvedType)this._baseType).getRawClass();
            string = clazz2.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

