/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class StdSubtypeResolver
extends SubtypeResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    public StdSubtypeResolver() {
    }

    protected StdSubtypeResolver(StdSubtypeResolver serializable) {
        serializable = serializable._registeredSubtypes;
        this._registeredSubtypes = serializable == null ? null : new LinkedHashSet(serializable);
    }

    @Override
    public SubtypeResolver copy() {
        return new StdSubtypeResolver(this);
    }

    @Override
    public void registerSubtypes(NamedType ... namedTypeArray) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType namedType : namedTypeArray) {
            this._registeredSubtypes.add(namedType);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classArray) {
        NamedType[] namedTypeArray = new NamedType[classArray.length];
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            namedTypeArray[i2] = new NamedType(classArray[i2]);
        }
        ((SubtypeResolver)this).registerSubtypes(namedTypeArray);
    }

    @Override
    public void registerSubtypes(Collection<Class<?>> object) {
        int n2 = object.size();
        NamedType[] namedTypeArray = new NamedType[n2];
        int n3 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Class clazz = (Class)object.next();
            namedTypeArray[n3++] = new NamedType(clazz);
        }
        ((SubtypeResolver)this).registerSubtypes(namedTypeArray);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> mapperConfig, AnnotatedMember annotated, JavaType type) {
        Object object;
        Object object2;
        Object object3;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        if (type != null) {
            type = ((ResolvedType)((Object)type)).getRawClass();
        } else if (annotated != null) {
            type = annotated.getRawType();
        } else {
            throw new IllegalArgumentException("Both property and base type are nulls");
        }
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            object3 = this._registeredSubtypes.iterator();
            while (object3.hasNext()) {
                object2 = (NamedType)object3.next();
                if (!((Class)type).isAssignableFrom(((NamedType)object2).getType())) continue;
                object = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, ((NamedType)object2).getType());
                this._collectAndResolve((AnnotatedClass)object, (NamedType)object2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        if (annotated != null && (object3 = annotationIntrospector.findSubtypes(annotated)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (NamedType)object2.next();
                annotated = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, ((NamedType)object).getType());
                this._collectAndResolve((AnnotatedClass)annotated, (NamedType)object, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        object3 = new NamedType((Class<?>)type, null);
        object2 = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, type);
        this._collectAndResolve((AnnotatedClass)object2, (NamedType)object3, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        Serializable serializable;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            serializable = ((Annotated)annotatedClass).getRawType();
            for (NamedType namedType : this._registeredSubtypes) {
                if (!((Class)serializable).isAssignableFrom(namedType.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, namedType.getType());
                this._collectAndResolve(annotatedClass2, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        serializable = new NamedType(((Annotated)annotatedClass).getRawType(), null);
        this._collectAndResolve(annotatedClass, (NamedType)serializable, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> mapperConfig, AnnotatedMember iterator, JavaType type) {
        AnnotationIntrospector object3 = mapperConfig.getAnnotationIntrospector();
        type = ((ResolvedType)((Object)type)).getRawClass();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashMap<String, NamedType> linkedHashMap = new LinkedHashMap<String, NamedType>();
        Object object = new NamedType((Class<?>)type, null);
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, type);
        this._collectAndResolveByTypeId(annotatedClass, (NamedType)object, mapperConfig, linkedHashSet, linkedHashMap);
        if (iterator != null && (iterator = object3.findSubtypes((Annotated)((Object)iterator))) != null) {
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                object = (NamedType)iterator2.next();
                annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, ((NamedType)object).getType());
                this._collectAndResolveByTypeId(annotatedClass, (NamedType)object, mapperConfig, linkedHashSet, linkedHashMap);
            }
        }
        if (this._registeredSubtypes != null) {
            for (NamedType namedType : this._registeredSubtypes) {
                if (!((Class)type).isAssignableFrom(namedType.getType())) continue;
                object = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, namedType.getType());
                this._collectAndResolveByTypeId((AnnotatedClass)object, namedType, mapperConfig, linkedHashSet, linkedHashMap);
            }
        }
        return this._combineNamedAndUnnamed((Class<?>)type, linkedHashSet, (Map<String, NamedType>)linkedHashMap);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> mapperConfig, AnnotatedClass object) {
        Class<?> clazz = ((Annotated)object).getRawType();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashMap<String, NamedType> linkedHashMap = new LinkedHashMap<String, NamedType>();
        NamedType namedType2 = new NamedType(clazz, null);
        this._collectAndResolveByTypeId((AnnotatedClass)object, namedType2, mapperConfig, linkedHashSet, linkedHashMap);
        if (this._registeredSubtypes != null) {
            for (NamedType namedType2 : this._registeredSubtypes) {
                if (!clazz.isAssignableFrom(namedType2.getType())) continue;
                AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, namedType2.getType());
                this._collectAndResolveByTypeId(annotatedClass, namedType2, mapperConfig, linkedHashSet, linkedHashMap);
            }
        }
        return this._combineNamedAndUnnamed(clazz, linkedHashSet, linkedHashMap);
    }

    protected void _collectAndResolve(AnnotatedClass object, NamedType namedType, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, HashMap<NamedType, NamedType> hashMap) {
        Object object2;
        if (!namedType.hasName() && (object2 = annotationIntrospector.findTypeName((AnnotatedClass)object)) != null) {
            namedType = new NamedType(namedType.getType(), (String)object2);
        }
        if (hashMap.containsKey(object2 = new NamedType(namedType.getType()))) {
            if (namedType.hasName() && !((NamedType)(object = hashMap.get(object2))).hasName()) {
                hashMap.put((NamedType)object2, namedType);
            }
            return;
        }
        hashMap.put((NamedType)object2, namedType);
        object = annotationIntrospector.findSubtypes((Annotated)object);
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                namedType = (NamedType)object.next();
                object2 = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, namedType.getType());
                this._collectAndResolve((AnnotatedClass)object2, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
    }

    protected void _collectAndResolveByTypeId(AnnotatedClass object, NamedType namedType, MapperConfig<?> mapperConfig, Set<Class<?>> set, Map<String, NamedType> map) {
        Object object2;
        Object object3 = mapperConfig.getAnnotationIntrospector();
        if (!namedType.hasName() && (object2 = ((AnnotationIntrospector)object3).findTypeName((AnnotatedClass)object)) != null) {
            namedType = new NamedType(namedType.getType(), (String)object2);
        }
        if (namedType.hasName()) {
            map.put(namedType.getName(), namedType);
        }
        if (set.add(namedType.getType()) && (object2 = ((AnnotationIntrospector)object3).findSubtypes((Annotated)object)) != null && !object2.isEmpty()) {
            object = object2.iterator();
            while (object.hasNext()) {
                namedType = (NamedType)object.next();
                object3 = AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, namedType.getType());
                this._collectAndResolveByTypeId((AnnotatedClass)object3, namedType, mapperConfig, set, map);
            }
        }
    }

    protected Collection<NamedType> _combineNamedAndUnnamed(Class<?> clazz, Set<Class<?>> set, Map<String, NamedType> iterator) {
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(iterator.values());
        for (NamedType serializable : iterator.values()) {
            set.remove(serializable.getType());
        }
        for (Class<Object> clazz2 : set) {
            if (clazz2 == clazz && Modifier.isAbstract(clazz2.getModifiers())) continue;
            arrayList.add(new NamedType(clazz2));
        }
        return arrayList;
    }
}

