/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;

public abstract class TypeIdResolverBase
implements TypeIdResolver {
    protected final TypeFactory _typeFactory;
    protected final JavaType _baseType;

    protected TypeIdResolverBase() {
        this(null, null);
    }

    protected TypeIdResolverBase(JavaType javaType, TypeFactory typeFactory) {
        this._baseType = javaType;
        this._typeFactory = typeFactory;
    }

    @Override
    public void init(JavaType javaType) {
    }

    @Override
    public String idFromBaseType() {
        return this.idFromValueAndType(null, ((ResolvedType)this._baseType).getRawClass());
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        throw new IllegalStateException("Sub-class " + this.getClass().getName() + " MUST implement `typeFromId(DatabindContext,String)");
    }

    @Override
    public String getDescForKnownTypeIds() {
        return null;
    }

    protected Class<?> _resolveToParentAsNecessary(Class<?> clazz) {
        if (ClassUtil.isEnumType(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }
}

