/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable$Base;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.InternalNodeMapper$IteratorStack;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class InternalNodeMapper$WrapperForSerializer
extends JsonSerializable$Base {
    protected final BaseJsonNode _root;
    protected SerializerProvider _context;

    public InternalNodeMapper$WrapperForSerializer(BaseJsonNode baseJsonNode) {
        this._root = baseJsonNode;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this._context = serializerProvider;
        this._serializeNonRecursive(jsonGenerator, this._root);
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }

    protected void _serializeNonRecursive(JsonGenerator jsonGenerator, JsonNode jsonNode) throws IOException {
        if (jsonNode instanceof ObjectNode) {
            jsonGenerator.writeStartObject(this, jsonNode.size());
            this._serializeNonRecursive(jsonGenerator, new InternalNodeMapper$IteratorStack(), jsonNode.properties().iterator());
            return;
        }
        if (jsonNode instanceof ArrayNode) {
            jsonGenerator.writeStartArray(this, jsonNode.size());
            this._serializeNonRecursive(jsonGenerator, new InternalNodeMapper$IteratorStack(), jsonNode.elements());
            return;
        }
        jsonNode.serialize(jsonGenerator, this._context);
    }

    protected void _serializeNonRecursive(JsonGenerator jsonGenerator, InternalNodeMapper$IteratorStack internalNodeMapper$IteratorStack, Iterator<?> iterator) throws IOException {
        while (true) {
            if (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof Map.Entry) {
                    object = (Map.Entry)object;
                    jsonGenerator.writeFieldName((String)object.getKey());
                    object = (JsonNode)object.getValue();
                } else {
                    object = (JsonNode)object;
                }
                if (object instanceof ObjectNode) {
                    internalNodeMapper$IteratorStack.push(iterator);
                    iterator = ((JsonNode)object).properties().iterator();
                    Object obj = object;
                    jsonGenerator.writeStartObject(obj, ((JsonNode)obj).size());
                    continue;
                }
                if (object instanceof ArrayNode) {
                    internalNodeMapper$IteratorStack.push(iterator);
                    iterator = ((JsonNode)object).elements();
                    Object obj = object;
                    jsonGenerator.writeStartArray(obj, ((JsonNode)obj).size());
                    continue;
                }
                if (object instanceof POJONode) {
                    try {
                        object.serialize(jsonGenerator, this._context);
                    }
                    catch (IOException | RuntimeException exception) {
                        jsonGenerator.writeString(String.format("[ERROR: (%s) %s]", exception.getClass().getName(), exception.getMessage()));
                    }
                    continue;
                }
                object.serialize(jsonGenerator, this._context);
                continue;
            }
            if (jsonGenerator.getOutputContext().inArray()) {
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeEndObject();
            }
            if ((iterator = internalNodeMapper$IteratorStack.popOrNull()) == null) break;
        }
    }
}

