/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.InternalNodeMapper$WrapperForSerializer;
import java.io.IOException;

final class InternalNodeMapper {
    private static final JsonMapper JSON_MAPPER = new JsonMapper();
    private static final ObjectWriter STD_WRITER = JSON_MAPPER.writer();
    private static final ObjectWriter PRETTY_WRITER = JSON_MAPPER.writer().withDefaultPrettyPrinter();
    private static final ObjectReader NODE_READER = JSON_MAPPER.readerFor(JsonNode.class);

    InternalNodeMapper() {
    }

    public static String nodeToString(BaseJsonNode baseJsonNode) {
        try {
            return STD_WRITER.writeValueAsString(InternalNodeMapper._wrapper(baseJsonNode));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String nodeToPrettyString(BaseJsonNode baseJsonNode) {
        try {
            return PRETTY_WRITER.writeValueAsString(InternalNodeMapper._wrapper(baseJsonNode));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] valueToBytes(Object object) throws IOException {
        return JSON_MAPPER.writeValueAsBytes(object);
    }

    public static JsonNode bytesToNode(byte[] byArray) throws IOException {
        return (JsonNode)NODE_READER.readValue(byArray);
    }

    private static JsonSerializable _wrapper(BaseJsonNode baseJsonNode) {
        return new InternalNodeMapper$WrapperForSerializer(baseJsonNode);
    }
}

