/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NodeCursor$ArrayCursor;
import com.fasterxml.jackson.databind.node.NodeCursor$ObjectCursor;

abstract class NodeCursor
extends JsonStreamContext {
    protected final NodeCursor _parent;
    protected String _currentName;
    protected Object _currentValue;

    public NodeCursor(int n2, NodeCursor nodeCursor) {
        this._type = n2;
        this._index = -1;
        this._parent = nodeCursor;
    }

    @Override
    public final NodeCursor getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public abstract JsonToken nextToken();

    public abstract JsonNode currentNode();

    public abstract NodeCursor startObject();

    public abstract NodeCursor startArray();

    public final NodeCursor iterateChildren() {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (jsonNode.isArray()) {
            return new NodeCursor$ArrayCursor(jsonNode, this);
        }
        if (jsonNode.isObject()) {
            return new NodeCursor$ObjectCursor(jsonNode, this);
        }
        throw new IllegalStateException("Current node of type " + jsonNode.getClass().getName());
    }
}

