/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.node.InternalNodeMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

class NodeSerialization
implements Externalizable,
Serializable {
    protected static final int LONGEST_EAGER_ALLOC = 100000;
    private static final long serialVersionUID = 1L;
    public byte[] json;

    public NodeSerialization() {
    }

    public NodeSerialization(byte[] byArray) {
        this.json = byArray;
    }

    protected Object readResolve() {
        try {
            return InternalNodeMapper.bytesToNode(this.json);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to JDK deserialize `JsonNode` value: " + iOException.getMessage(), iOException);
        }
    }

    public static NodeSerialization from(Object object) {
        try {
            return new NodeSerialization(InternalNodeMapper.valueToBytes(object));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to JDK serialize `" + object.getClass().getSimpleName() + "` value: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.json.length);
        objectOutput.write(this.json);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        this.json = this._read(objectInput, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] _read(ObjectInput object, int n2) throws IOException {
        Object object2;
        if (n2 <= 100000) {
            byte[] byArray = new byte[n2];
            object.readFully(byArray, 0, n2);
            return byArray;
        }
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(100000);
        Throwable throwable = null;
        try {
            object2 = byteArrayBuilder.resetAndGetFirstSegment();
            int n3 = 0;
            while (true) {
                int n4 = Math.min(((byte[])object2).length - n3, n2);
                object.readFully((byte[])object2, 0, n4);
                n3 += n4;
                if ((n2 -= n4) == 0) {
                    object = byteArrayBuilder.completeAndCoalesce(n3);
                    byteArrayBuilder.close();
                    return object;
                }
                if (n3 != ((byte[])object2).length) continue;
                object2 = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
                continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            object2 = throwable2;
            throwable = throwable2;
            throw object2;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                byteArrayBuilder.close();
                throw throwable3;
            }
            try {
                byteArrayBuilder.close();
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throwable.addSuppressed(throwable4);
                throw throwable3;
            }
        }
    }
}

