/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import java.io.Serializable;
import java.util.Map;

public class AnyGetterWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanPropertyWriter beanPropertyWriter, BeanProperty beanProperty, AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        super(beanPropertyWriter);
        this._accessor = annotatedMember;
        this._property = beanProperty;
        this._serializer = jsonSerializer;
        if (jsonSerializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)jsonSerializer;
        }
    }

    @Deprecated
    public AnyGetterWriter(BeanProperty beanProperty, AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        this(null, beanProperty, annotatedMember, jsonSerializer);
    }

    @Override
    public void fixAccess(SerializationConfig serializationConfig) {
        this._accessor.fixAccess(serializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if ((object = this._accessor.getValue(object)) == null) {
            return;
        }
        if (!(object instanceof Map)) {
            ((DatabindContext)serializerProvider).reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' %s() not java.util.Map but %s", this._accessor.getName(), object.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeWithoutTypeInfo((Map)object, jsonGenerator, serializerProvider);
            return;
        }
        this._serializer.serialize(object, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        this.getAndSerialize(object, jsonGenerator, serializerProvider);
    }

    public void getAndFilter(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter) throws Exception {
        Object object2 = this._accessor.getValue(object);
        if (object2 == null) {
            return;
        }
        if (!(object2 instanceof Map)) {
            ((DatabindContext)serializerProvider).reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' (%s()) not java.util.Map but %s", this._accessor.getName(), object2.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredAnyProperties(serializerProvider, jsonGenerator, object, (Map)object2, propertyFilter, null);
            return;
        }
        this._serializer.serialize(object2, jsonGenerator, serializerProvider);
    }

    public void resolve(SerializerProvider object) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            this._serializer = object = ((SerializerProvider)object).handlePrimaryContextualization(this._serializer, this._property);
            if (object instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)object;
            }
        }
    }
}

